/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.targetdef.constraint.pattern;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeView;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.exploration.ui.perspective.targetdef.PatternFXControllerBase;
import org.fortiss.af3.exploration.ui.util.ExplorationUiUtils;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.PatternFactoryUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.task.model.Task;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicListContentProvider;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeViewer;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.EmptyChildrenContentProvider;

public class AllocationPatternFXController
extends PatternFXControllerBase {
    @FXML
    private TreeView<Task> taskView;
    @FXML
    private TreeView<ExecutionUnit> ecuView;
    @FXML
    private RadioButton allocationButton;
    @FXML
    private RadioButton dislocationButton;

    @Override
    public boolean isFullySpecified() {
        return !this.getSelectedTasks().isEmpty() && !this.getSelectedExecutionUnits().isEmpty();
    }

    @Override
    public IExplorationTarget<?> getExplorationTarget() {
        DSE dse = IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE();
        IBooleanExpression expression = PatternFactoryUtils.createAllocationPatternExpression((DSE)dse, (boolean)this.allocationButton.isSelected(), this.getSelectedTasks(), this.getSelectedExecutionUnits());
        return ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)expression, (String)this.getExplorationTargetName(), (boolean)false);
    }

    private List<Task> getSelectedTasks() {
        return this.taskView.getSelectionModel().getSelectedItems().stream().map(item -> (Task)item.getValue()).collect(Collectors.toList());
    }

    private List<ExecutionUnit> getSelectedExecutionUnits() {
        return this.ecuView.getSelectionModel().getSelectedItems().stream().map(item -> (ExecutionUnit)item.getValue()).collect(Collectors.toList());
    }

    @Override
    public String getExplorationTargetName() {
        Object name = "";
        List<Task> tasks = this.getSelectedTasks();
        List<ExecutionUnit> ecus = this.getSelectedExecutionUnits();
        if (!tasks.isEmpty()) {
            name = PatternFactoryUtils.calcPatternName(tasks, (String)"; ");
        }
        name = (String)name + (this.allocationButton.isSelected() ? " -> " : " -/> ");
        if (!ecus.isEmpty()) {
            name = (String)name + PatternFactoryUtils.calcPatternName(ecus, (String)"  |  ");
        }
        return name;
    }

    @Override
    public String getCategory() {
        return "";
    }

    @Override
    public String getDescription() {
        return "Allocation: The selected tasks will be mapped onto one of the selected execution units.\nDislocation: The selected tasks will NOT be mapped onto any of the selected execution units.";
    }

    @Override
    public String getPatternName() {
        return "Allocation";
    }

    public String getFXMLLocation() {
        return "AllocationPatternInterface.fxml";
    }

    @Override
    public void setupViews() {
        SuperSet<Task> tasks = this.getSuperSet(Task.class).get();
        SuperSet<ExecutionUnit> ecus = this.getSuperSet(ExecutionUnit.class).get();
        new DynamicTreeViewer(this.taskView, (Collection)tasks.getEntries(), (DynamicListContentProvider)new EmptyChildrenContentProvider(), ExplorationUiUtils.createNameProvider());
        new DynamicTreeViewer(this.ecuView, (Collection)ecus.getEntries(), (DynamicListContentProvider)new EmptyChildrenContentProvider(), ExplorationUiUtils.createNameProvider());
        ToggleGroup group = new ToggleGroup();
        this.allocationButton.setToggleGroup(group);
        this.dislocationButton.setToggleGroup(group);
        this.allocationButton.setSelected(true);
        this.taskView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.ecuView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    @Override
    public void destroyViews() {
        super.destroyViews();
        this.taskView.setRoot(null);
        this.ecuView.setRoot(null);
    }

    @Override
    public Collection<Node> getControls() {
        return Arrays.asList(this.allocationButton, this.dislocationButton, this.ecuView, this.taskView);
    }
}

