/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.targetdef.constraint.pattern;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeView;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;
import org.fortiss.af3.exploration.ui.perspective.targetdef.PatternFXControllerBase;
import org.fortiss.af3.exploration.ui.util.ExplorationUiUtils;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.PatternFactoryUtils;
import org.fortiss.af3.task.model.Task;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicListContentProvider;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeViewer;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.EmptyChildrenContentProvider;

public class CouplingPatternFXController
extends PatternFXControllerBase
implements IEventListener {
    @FXML
    private TreeView<Task> view;
    @FXML
    private RadioButton couplingButton;
    @FXML
    private RadioButton decouplingButton;

    @Override
    public boolean isFullySpecified() {
        return this.getSelectedTasks().size() > 1;
    }

    @Override
    public IExplorationTarget<?> getExplorationTarget() {
        DSE dse = IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE();
        IExpression expression = PatternFactoryUtils.createFunctionCouplingPatternExpression((DSE)dse, (boolean)this.couplingButton.isSelected(), this.getSelectedTasks());
        return ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createSafetyDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)expression, (String)this.getExplorationTargetName(), (boolean)false);
    }

    private List<Task> getSelectedTasks() {
        return this.view.getSelectionModel().getSelectedItems().stream().map(item -> (Task)item.getValue()).collect(Collectors.toList());
    }

    @Override
    public String getExplorationTargetName() {
        Object name;
        List<Task> tasks = this.getSelectedTasks();
        Object object = name = this.couplingButton.isSelected() ? "Coupling " : "Decoupling ";
        if (tasks.size() == 1) {
            name = (String)name + "{";
        }
        name = (String)name + PatternFactoryUtils.calcPatternName(tasks, (String)", ");
        if (tasks.size() == 1) {
            name = (String)name + "}";
        }
        return name;
    }

    @Override
    public String getCategory() {
        return "";
    }

    @Override
    public String getDescription() {
        return "Specifies which tasks need to be deployed onto the same ECU (coupling) or distinct ECUs (decoupling).";
    }

    @Override
    public String getPatternName() {
        return "Function Coupling";
    }

    public String getFXMLLocation() {
        return "CouplingPatternInterface.fxml";
    }

    @Override
    public void setupViews() {
        SuperSet<Task> tasks = this.getSuperSet(Task.class).get();
        new DynamicTreeViewer(this.view, (Collection)tasks.getEntries(), (DynamicListContentProvider)new EmptyChildrenContentProvider(), ExplorationUiUtils.createNameProvider());
        ToggleGroup group = new ToggleGroup();
        this.couplingButton.setToggleGroup(group);
        this.decouplingButton.setToggleGroup(group);
        this.couplingButton.setSelected(true);
        this.view.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    @Override
    public void destroyViews() {
        super.destroyViews();
        this.view.setRoot(null);
    }

    @Override
    public Collection<Node> getControls() {
        return Arrays.asList(this.view, this.couplingButton, this.decouplingButton);
    }
}

