/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.targetdef.constraint.pattern;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TreeTableView;
import org.fortiss.af3.exploration.dseml.model.booleanp.BooleanLiteral;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.exploration.ui.perspective.targetdef.PatternFXControllerBase;
import org.fortiss.af3.exploration.util.DSMLModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.PatternFactoryUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicListContentProvider;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableViewer;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.EmptyChildrenContentProvider;

public abstract class ResourcePatternFXController
extends PatternFXControllerBase {
    @FXML
    private TreeTableView<ExecutionUnit> view;
    private Map<ExecutionUnit, Integer> resourceUtilization;

    public abstract Class<? extends IAnnotatedSpecification> getRequirementAnnotation();

    public abstract Class<? extends IAnnotatedSpecification> getAvailabilityAnnotation();

    public abstract String getResourceLabel();

    @Override
    public boolean isFullySpecified() {
        return !this.view.getSelectionModel().getSelectedItems().isEmpty();
    }

    @Override
    public IExplorationTarget<?> getExplorationTarget() {
        DSE dse = IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE();
        BooleanLiteral expression = DSMLModelElementFactory.createBooleanLiteral((boolean)true);
        for (ExecutionUnit executionUnit : this.getSelectedExecutionUnits()) {
            double utilization = (double)this.resourceUtilization.get(executionUnit).intValue() / 100.0;
            expression = DSMLModelElementFactory.createAnd((IBooleanExpression)expression, (IBooleanExpression)PatternFactoryUtils.createUtilizationPatternExpression((DSE)dse, (double)utilization, (ExecutionUnit)executionUnit, this.getRequirementAnnotation(), this.getAvailabilityAnnotation()));
        }
        return ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)expression, (String)this.getExplorationTargetName(), (boolean)false);
    }

    private Collection<ExecutionUnit> getSelectedExecutionUnits() {
        return this.view.getSelectionModel().getSelectedItems().stream().map(item -> (ExecutionUnit)item.getValue()).collect(Collectors.toList());
    }

    @Override
    public String getExplorationTargetName() {
        return this.getPatternName() + " (" + this.getSelectedExecutionUnits().stream().map(ecu -> ecu.getName() + "[" + String.valueOf(this.resourceUtilization.get(ecu)) + "]").collect(Collectors.joining(", ")) + ")";
    }

    @Override
    public String getCategory() {
        return "";
    }

    public String getFXMLLocation() {
        return "ResourcePatternInterface.fxml";
    }

    @Override
    public void setupViews() {
        SuperSet<ExecutionUnit> executionUnits = this.getSuperSet(ExecutionUnit.class).get();
        this.resourceUtilization = new HashMap<ExecutionUnit, Integer>();
        executionUnits.getEntries().forEach(executionUnit -> {
            Integer n = this.resourceUtilization.put((ExecutionUnit)executionUnit, 100);
        });
        DynamicTreeTableUIProviderBase<ExecutionUnit> uiProvider = new DynamicTreeTableUIProviderBase<ExecutionUnit>(){

            public String getLabel(ExecutionUnit element, int column) {
                switch (column) {
                    case 0: {
                        return element.getName();
                    }
                    case 1: {
                        return ((Long)AnnotationUtils.getAnnotationValue((IModelElement)element, ResourcePatternFXController.this.getAvailabilityAnnotation(), Long.class)).toString();
                    }
                    case 2: {
                        return ResourcePatternFXController.this.resourceUtilization.get(element).toString();
                    }
                }
                return "";
            }

            public boolean isEditable(int column) {
                switch (column) {
                    case 2: {
                        return true;
                    }
                }
                return false;
            }
        };
        DynamicTreeTableViewer viewer = new DynamicTreeTableViewer(this.view, (Collection)executionUnits.getEntries(), (DynamicListContentProvider)new EmptyChildrenContentProvider(), (DynamicTreeTableUIProviderBase)uiProvider);
        this.view.getColumns().clear();
        viewer.addColumn("ECU", 125);
        viewer.addColumn(this.getResourceLabel(), 125);
        EventHandler updateUtilization = event -> {
            this.resourceUtilization.put((ExecutionUnit)event.getRowValue().getValue(), Integer.valueOf((String)event.getNewValue()));
            this.view.refresh();
        };
        viewer.addColumn("Utilization [%]", 125).setOnEditCommit(updateUtilization);
        this.view.getSelectionModel().selectAll();
    }

    @Override
    public void destroyViews() {
        super.destroyViews();
        this.view.setRoot(null);
    }

    @Override
    public Collection<Node> getControls() {
        return Arrays.asList(this.view);
    }
}

