/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.targetdef.constraint.pattern;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TreeTableView;
import org.eclipse.emf.common.util.Enumerator;
import org.fortiss.af3.exploration.dseml.model.booleanp.BooleanLiteral;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.exploration.ui.perspective.targetdef.PatternFXControllerBase;
import org.fortiss.af3.exploration.util.DSMLModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.PatternFactoryUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.safety.model.annotation.SafetyIntegrityLevel;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationEntry;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicListContentProvider;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableViewer;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.EmptyChildrenContentProvider;

public class SafetyPatternFXController
extends PatternFXControllerBase {
    @FXML
    private TreeTableView<ExecutionUnit> view;

    @Override
    public boolean isFullySpecified() {
        return !this.getSelectedExecutionUnits().isEmpty();
    }

    @Override
    public IExplorationTarget<?> getExplorationTarget() {
        DSE dse = IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE();
        SuperSetMap ssMap = dse.getCurrentStep().getSuperSetMap();
        List<ExecutionUnit> executionUnits = this.getSelectedExecutionUnits();
        BooleanLiteral expression = DSMLModelElementFactory.createBooleanLiteral((boolean)true);
        for (ExecutionUnit executionUnit : executionUnits) {
            expression = DSMLModelElementFactory.createAnd((IBooleanExpression)expression, (IBooleanExpression)PatternFactoryUtils.createSafetyPatternExpression((DSE)dse, (ExecutionUnit)executionUnit, (SuperSet)ssMap.get(ComponentToTaskAllocationEntry.class)));
        }
        return ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class}), (IExpression)expression, (String)this.getExplorationTargetName(), (boolean)false);
    }

    private List<ExecutionUnit> getSelectedExecutionUnits() {
        return this.view.getSelectionModel().getSelectedItems().stream().map(item -> (ExecutionUnit)item.getValue()).collect(Collectors.toList());
    }

    @Override
    public String getExplorationTargetName() {
        Object name = "Safety level ";
        List<ExecutionUnit> ecus = this.getSelectedExecutionUnits();
        if (ecus.size() == 1) {
            name = (String)name + "{";
        }
        name = (String)name + PatternFactoryUtils.calcPatternName(ecus, (String)", ");
        if (ecus.size() == 1) {
            name = (String)name + "}";
        }
        return name;
    }

    @Override
    public String getCategory() {
        return "";
    }

    @Override
    public String getDescription() {
        return "Specifies the ECUs for which the safety level constraint should be enabled, i.e., such that no tasks referring to components with a safety level higher than the one indicated can be deployed onto them.";
    }

    @Override
    public String getPatternName() {
        return "Safety Level";
    }

    public String getFXMLLocation() {
        return "SafetyPatternInterface.fxml";
    }

    @Override
    public void setupViews() {
        SuperSet<ExecutionUnit> executionUnits = this.getSuperSet(ExecutionUnit.class).get();
        DynamicTreeTableUIProviderBase<ExecutionUnit> uiProvider = new DynamicTreeTableUIProviderBase<ExecutionUnit>(){

            public String getLabel(ExecutionUnit element, int column) {
                switch (column) {
                    case 0: {
                        return element.getName();
                    }
                    case 1: {
                        return ((Enumerator)AnnotationUtils.getAnnotationValue((IModelElement)element, SafetyIntegrityLevel.class, Enumerator.class)).toString();
                    }
                }
                return "";
            }
        };
        DynamicTreeTableViewer viewer = new DynamicTreeTableViewer(this.view, (Collection)executionUnits.getEntries(), (DynamicListContentProvider)new EmptyChildrenContentProvider(), (DynamicTreeTableUIProviderBase)uiProvider);
        this.view.getColumns().clear();
        viewer.addColumn("ECU", 125);
        viewer.addColumn("Safety Level", 125);
        this.view.getSelectionModel().selectAll();
    }

    @Override
    public void destroyViews() {
        super.destroyViews();
        this.view.setRoot(null);
    }

    @Override
    public Collection<Node> getControls() {
        return Arrays.asList(this.view);
    }
}

