/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.targetdef.objective.pattern;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeView;
import org.fortiss.af3.exploration.dseml.model.booleanp.IBooleanExpression;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.ExplorationConstraint;
import org.fortiss.af3.exploration.model.ExplorationObjective;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.exploration.ui.perspective.targetdef.PatternFXControllerBase;
import org.fortiss.af3.exploration.ui.util.ExplorationUiUtils;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.PatternFactoryUtils;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.TransmissionUnit;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicListContentProvider;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeViewer;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.EmptyChildrenContentProvider;

public class BusBandwidthOptimizationPatternFXController
extends PatternFXControllerBase {
    @FXML
    private TreeView<TransmissionUnit> view;
    @FXML
    private RadioButton minButton;
    @FXML
    private RadioButton maxButton;

    @Override
    public boolean isFullySpecified() {
        return this.getSelectedTransmissionUnit() != null;
    }

    @Override
    public IExplorationTarget<?> getExplorationTarget() {
        DSE dse = IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE();
        TransmissionUnit selectedBus = this.getSelectedTransmissionUnit();
        if (selectedBus == null) {
            return null;
        }
        ArrayList<ExplorationConstraint> constraints = new ArrayList<ExplorationConstraint>();
        IExpression routeWeightExpression = PatternFactoryUtils.createRouteWeightConstraintPatternExpression((DSE)dse);
        HashSet categories = Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class});
        constraints.add(ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)categories, (IExpression)routeWeightExpression, (String)"BandwidthWeight", (boolean)true));
        for (TransmissionUnit bus : dse.getCurrentStep().getSuperSetMap().get(TransmissionUnit.class).getEntries()) {
            for (Route route : dse.getCurrentStep().getSuperSetMap().get(Route.class).getEntries()) {
                IBooleanExpression routeUsesBusExpression = PatternFactoryUtils.createRouteUsesBusConstraintPatternExpression((DSE)dse, (TransmissionUnit)bus, (Route)route);
                constraints.add(ExplorationModelElementFactory.createExplorationConstraint(Boolean.class, (IProblemDimension)ExplorationModelElementFactory.createResourceDimension(), (Collection)categories, (IExpression)routeUsesBusExpression, (String)"RouteUsesBus", (boolean)true));
            }
        }
        IExpression expr = PatternFactoryUtils.createBusWeightOptimizationPatternExpression((DSE)dse, (TransmissionUnit)selectedBus, (boolean)this.minButton.isSelected());
        ExplorationObjective objective = ExplorationModelElementFactory.createExplorationObjective(Double.class, (IProblemDimension)ExplorationModelElementFactory.createUserDefinedDimension((String)this.getCategory()), (Collection)categories, (IExpression)expr, (String)this.getExplorationTargetName());
        objective.getImplicitConstraints().addAll(constraints);
        return objective;
    }

    private TransmissionUnit getSelectedTransmissionUnit() {
        List list = this.view.getSelectionModel().getSelectedItems().stream().map(item -> (TransmissionUnit)item.getValue()).collect(Collectors.toList());
        if (!list.isEmpty()) {
            return (TransmissionUnit)list.get(0);
        }
        return null;
    }

    @Override
    public String getExplorationTargetName() {
        TransmissionUnit transmissionUnit = this.getSelectedTransmissionUnit();
        Object name = this.minButton.isSelected() ? "Min Bandwidth" : "Max Bandwidth";
        String busName = transmissionUnit != null ? transmissionUnit.getName() : "";
        name = (String)name + " (" + busName + ")";
        return name;
    }

    @Override
    public String getCategory() {
        return "";
    }

    @Override
    public String getDescription() {
        return "Optimizes the bandwidth of the selected bus.";
    }

    @Override
    public String getPatternName() {
        return "Bus Bandwidth Optimization";
    }

    public String getFXMLLocation() {
        return "BusBandwidthOptimizationPatternInterface.fxml";
    }

    @Override
    public void setupViews() {
        SuperSet<TransmissionUnit> transmissionUnits = this.getSuperSet(TransmissionUnit.class).get();
        new DynamicTreeViewer(this.view, (Collection)transmissionUnits.getEntries(), (DynamicListContentProvider)new EmptyChildrenContentProvider(), ExplorationUiUtils.createNameProvider());
        ToggleGroup group = new ToggleGroup();
        this.minButton.setToggleGroup(group);
        this.maxButton.setToggleGroup(group);
        this.minButton.setSelected(true);
        this.view.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
    }

    @Override
    public void destroyViews() {
        super.destroyViews();
        this.view.setRoot(null);
    }

    @Override
    public Collection<Node> getControls() {
        return Arrays.asList(this.view, this.minButton, this.maxButton);
    }
}

