/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.targetdef.objective.pattern;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeView;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.ExplorationObjective;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.synthesiscategory.IDeploymentSynthesis;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.exploration.ui.perspective.targetdef.PatternFXControllerBase;
import org.fortiss.af3.exploration.ui.util.ExplorationUiUtils;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.exploration.util.PatternFactoryUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.annotation.FlashSize;
import org.fortiss.af3.platform.model.annotation.HardwareCost;
import org.fortiss.af3.platform.model.annotation.PowerConsumption;
import org.fortiss.af3.platform.model.annotation.RamSize;
import org.fortiss.af3.platform.model.annotation.Weight;
import org.fortiss.af3.task.model.Task;
import org.fortiss.tooling.base.annotation.AnnotationEntry;
import org.fortiss.tooling.base.annotation.IAnnotationValueService;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicListContentProvider;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeUIProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeViewer;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.EmptyChildrenContentProvider;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class HardwareOptimizationPatternFXController
extends PatternFXControllerBase {
    @FXML
    private TreeView<ExecutionUnit> ecuView;
    @FXML
    private TreeView<Class<? extends IAnnotatedSpecification>> propertyView;
    @FXML
    private TreeView<Task> taskView;
    @FXML
    private RadioButton minButton;
    @FXML
    private RadioButton maxButton;
    @FXML
    private RadioButton countButton;
    @FXML
    private RadioButton sumButton;

    @Override
    public boolean isFullySpecified() {
        if (this.getSelectedExecutionUnits().isEmpty() || this.getSelectedTasks().isEmpty()) {
            return false;
        }
        return this.getSelectedProperty() != null || !this.sumButton.isSelected();
    }

    @Override
    public IExplorationTarget<?> getExplorationTarget() {
        DSE dse = IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE();
        int operation = this.sumButton.isSelected() ? 0 : 1;
        Class<? extends IAnnotatedSpecification> property = this.getSelectedProperty();
        IExpression expr = PatternFactoryUtils.createHardwareOptimizationPatternExpression((DSE)dse, (boolean)this.minButton.isSelected(), (int)operation, this.getSelectedTasks(), this.getSelectedExecutionUnits(), property);
        HashSet categories = Sets.newHashSet((Object[])new Class[]{IDeploymentSynthesis.class});
        ExplorationObjective objective = ExplorationModelElementFactory.createExplorationObjective(Double.class, (IProblemDimension)ExplorationModelElementFactory.createUserDefinedDimension((String)this.getCategory()), (Collection)categories, (IExpression)expr, (String)this.getExplorationTargetName());
        UniqueIDUtils.prepareUniqueID((EObject)objective, (EObject)dse);
        return objective;
    }

    private List<ExecutionUnit> getSelectedExecutionUnits() {
        return this.ecuView.getSelectionModel().getSelectedItems().stream().map(item -> (ExecutionUnit)item.getValue()).collect(Collectors.toList());
    }

    private Class<? extends IAnnotatedSpecification> getSelectedProperty() {
        List list = this.propertyView.getSelectionModel().getSelectedItems().stream().map(item -> (Class)item.getValue()).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        return (Class)list.get(0);
    }

    private List<Task> getSelectedTasks() {
        return this.taskView.getSelectionModel().getSelectedItems().stream().map(item -> (Task)item.getValue()).collect(Collectors.toList());
    }

    @Override
    public String getExplorationTargetName() {
        Class<? extends IAnnotatedSpecification> property = this.getSelectedProperty();
        Object name = this.minButton.isSelected() ? "Min " : "Max ";
        name = this.sumButton.isSelected() ? (String)name + "Sum (" : (String)name + "Count (";
        SuperSet ecus = IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE().getCurrentStep().getSuperSetMap().get(ExecutionUnit.class);
        name = this.getSelectedExecutionUnits().size() == ecus.getEntries().size() ? (String)name + "All ECUs, " : (String)name + PatternFactoryUtils.calcPatternName(this.getSelectedExecutionUnits(), (String)", ") + ", ";
        name = property != null ? (String)name + this.getPropertyName(property) + ", " : (String)name + " - , ";
        SuperSet tasks = IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE().getCurrentStep().getSuperSetMap().get(Task.class);
        name = this.getSelectedTasks().size() == tasks.getEntries().size() ? (String)name + "All Tasks)" : (String)name + PatternFactoryUtils.calcPatternName(this.getSelectedTasks(), (String)", ") + ")";
        return name;
    }

    @Override
    public String getCategory() {
        return "";
    }

    @Override
    public String getDescription() {
        return "Optimizes the system with respect to hardware properties.";
    }

    @Override
    public String getPatternName() {
        return "Hardware Optimization";
    }

    public String getFXMLLocation() {
        return "HardwareOptimizationPatternInterface.fxml";
    }

    @Override
    public void setupViews() {
        SuperSet<ExecutionUnit> ecus = this.getSuperSet(ExecutionUnit.class).get();
        new DynamicTreeViewer(this.ecuView, (Collection)ecus.getEntries(), (DynamicListContentProvider)new EmptyChildrenContentProvider(), ExplorationUiUtils.createNameProvider());
        MultipleSelectionModel esm = this.ecuView.getSelectionModel();
        esm.setSelectionMode(SelectionMode.MULTIPLE);
        esm.selectAll();
        ArrayList<Class<PowerConsumption>> annotations = new ArrayList<Class<PowerConsumption>>();
        annotations.add(HardwareCost.class);
        annotations.add(Weight.class);
        annotations.add(RamSize.class);
        annotations.add(FlashSize.class);
        annotations.add(PowerConsumption.class);
        new DynamicTreeViewer(this.propertyView, annotations, (DynamicListContentProvider)new EmptyChildrenContentProvider(), this.createAnnotationNameProvider());
        this.propertyView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        SuperSet<Task> tasks = this.getSuperSet(Task.class).get();
        new DynamicTreeViewer(this.taskView, (Collection)tasks.getEntries(), (DynamicListContentProvider)new EmptyChildrenContentProvider(), ExplorationUiUtils.createNameProvider());
        MultipleSelectionModel tsm = this.taskView.getSelectionModel();
        tsm.setSelectionMode(SelectionMode.MULTIPLE);
        tsm.selectAll();
        ToggleGroup minmaxGroup = new ToggleGroup();
        this.minButton.setToggleGroup(minmaxGroup);
        this.maxButton.setToggleGroup(minmaxGroup);
        this.minButton.setSelected(true);
        ToggleGroup aggrGroup = new ToggleGroup();
        this.sumButton.setToggleGroup(aggrGroup);
        this.countButton.setToggleGroup(aggrGroup);
        this.sumButton.setSelected(true);
    }

    @Override
    public void destroyViews() {
        super.destroyViews();
        this.ecuView.setRoot(null);
        this.propertyView.setRoot(null);
        this.taskView.setRoot(null);
    }

    protected DynamicTreeUIProviderBase<Class<? extends IAnnotatedSpecification>> createAnnotationNameProvider() {
        return new DynamicTreeUIProviderBase<Class<? extends IAnnotatedSpecification>>(){

            public String getLabel(Class<? extends IAnnotatedSpecification> element) {
                return HardwareOptimizationPatternFXController.this.getPropertyName(element);
            }
        };
    }

    @Override
    public Collection<Node> getControls() {
        return Arrays.asList(this.ecuView, this.propertyView, this.taskView, this.minButton, this.maxButton, this.sumButton, this.countButton);
    }

    private <T extends IAnnotatedSpecification> String getPropertyName(Class<T> property) {
        SuperSet ecus = IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE().getCurrentStep().getSuperSetMap().get(ExecutionUnit.class);
        AnnotationEntry annotationEntry = IAnnotationValueService.getInstance().getAnnotationEntry((IModelElement)ecus.getEntries().get(0));
        return annotationEntry.getSpecificationAnnotationName(property);
    }
}

