/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.targetdef.objective.pattern;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javafx.scene.Node;
import org.fortiss.af3.exploration.dseml.model.expression.IExpression;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.dseml.model.function.Minimize;
import org.fortiss.af3.exploration.model.ExplorationObjective;
import org.fortiss.af3.exploration.model.IExplorationTarget;
import org.fortiss.af3.exploration.model.IProblemDimension;
import org.fortiss.af3.exploration.model.synthesiscategory.IScheduleSynthesis;
import org.fortiss.af3.exploration.smt.modeltransformation.EnergyConstraintDefinition;
import org.fortiss.af3.exploration.ui.perspective.targetdef.PatternFXControllerBase;
import org.fortiss.af3.exploration.util.ExplorationModelElementFactory;
import org.fortiss.af3.schedule.model.ResourceAllocation;

public class LatencyMinimizationPatternFXController
extends PatternFXControllerBase {
    @Override
    public void setupViews() {
    }

    @Override
    public boolean isFullySpecified() {
        return true;
    }

    @Override
    public IExplorationTarget<?> getExplorationTarget() {
        SuperSet<ResourceAllocation> raSet = this.getSuperSet(ResourceAllocation.class).get();
        Minimize latencyMin = EnergyConstraintDefinition.createMinimizeSumObjective(raSet);
        HashSet categories = Sets.newHashSet((Object[])new Class[]{IScheduleSynthesis.class});
        ExplorationObjective objective = ExplorationModelElementFactory.createExplorationObjective(Double.class, (IProblemDimension)ExplorationModelElementFactory.createUserDefinedDimension((String)this.getCategory()), (Collection)categories, (IExpression)latencyMin, (String)this.getExplorationTargetName());
        return objective;
    }

    @Override
    public String getExplorationTargetName() {
        return this.getPatternName();
    }

    @Override
    public String getCategory() {
        return "";
    }

    @Override
    public String getDescription() {
        return "Minimizes the span (maximum lenght) of a strictly time-triggered schedule.";
    }

    @Override
    public String getPatternName() {
        return "Schedule Span Minimization";
    }

    public String getFXMLLocation() {
        return "LatencyMinimizationPatternInterface.fxml";
    }

    @Override
    public Collection<Node> getControls() {
        return Collections.emptyList();
    }

    @Override
    public boolean hiddenInNonExpertView() {
        return true;
    }
}

