/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.visualization;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import org.eclipse.core.runtime.Plugin;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SingleExplorationSolution;
import org.fortiss.af3.exploration.ui.AF3ExplorationUIActivator;
import org.fortiss.af3.exploration.ui.util.ExplorationSolutionVisualizationUtils;
import org.fortiss.tooling.base.model.visualization.DataSet;
import org.fortiss.tooling.base.model.visualization.DataSetCollection;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class DSESolutionVisualizationContainer {
    private Map<DataSet, SingleExplorationSolution> visToSolutionModel = new LinkedHashMap<DataSet, SingleExplorationSolution>();
    private DataSetCollection dataSetCol;

    public DSESolutionVisualizationContainer(ExplorationSolution solution) {
        try {
            this.dataSetCol = ExplorationSolutionVisualizationUtils.createVisualizationFor(solution, this.visToSolutionModel);
        }
        catch (InvalidTargetObjectTypeException e) {
            LoggingUtils.error((Plugin)AF3ExplorationUIActivator.getDefault(), (String)("ExplorationTarget with unexpected evaluation target encountered: " + String.valueOf(solution)), (Throwable)e);
            return;
        }
    }

    public SingleExplorationSolution getSolutionOf(DataSet dataSet) {
        return this.visToSolutionModel.get(dataSet);
    }

    public DataSetCollection getDataSetCollection() {
        return this.dataSetCol;
    }

    public Set<Map.Entry<DataSet, SingleExplorationSolution>> entrySet() {
        return this.visToSolutionModel.entrySet();
    }
}

