/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.visualization;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.ExplorationStep;
import org.fortiss.af3.exploration.model.project.ProcessStep;
import org.fortiss.af3.exploration.model.project.SolutionSelectionStep;
import org.fortiss.af3.exploration.ui.perspective.process.IProcessManager;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;
import org.fortiss.af3.exploration.ui.perspective.visualization.DSESolutionVisualizationContainer;
import org.fortiss.af3.exploration.ui.perspective.visualization.VisualizationViewGUI;
import org.fortiss.af3.exploration.ui.perspective.visualization.visualizations.IVisualizationView;
import org.fortiss.af3.exploration.ui.perspective.visualization.visualizations.VisualizationViewFactory;
import org.fortiss.af3.exploration.util.ExplorationScheduleUtils;
import org.fortiss.tooling.base.model.visualization.DataSetCollection;

public class VisualizationViewBackend
extends VisualizationViewGUI {
    private IVisualizationView activeView;

    private DSESolutionVisualizationContainer createDSESolutionVisualizationContainer(DSE dse) {
        ProcessStep pStep;
        ProcessStep processStep = pStep = dse != null ? dse.getCurrentStep() : null;
        if (pStep instanceof SolutionSelectionStep) {
            ProcessStep parentStep = pStep.getParent();
            Assert.isTrue((boolean)(parentStep instanceof ExplorationStep), (String)"According to the DSE Process model, an ExplorationStep is a successor of a SolutionSelectionStep. If the model changed, please adjust the code.");
            return new DSESolutionVisualizationContainer(((ExplorationStep)parentStep).getSolution());
        }
        if (pStep instanceof ExplorationStep) {
            return new DSESolutionVisualizationContainer(((ExplorationStep)pStep).getSolution());
        }
        return null;
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.update();
    }

    private void update() {
        DataSetCollection dataSetCollection;
        Button btnGantt = this.getBtnGanttChart();
        Button btnTable = this.getBtnTable();
        Button btnSpiderChart = this.getBtnSpiderChart();
        DSE dse = IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE();
        DSESolutionVisualizationContainer solution = this.createDSESolutionVisualizationContainer(dse);
        DataSetCollection dataSetCollection2 = dataSetCollection = solution != null ? solution.getDataSetCollection() : null;
        if (solution != null && dataSetCollection != null) {
            IVisualizationView.ViewType currentViewType;
            btnSpiderChart.addSelectionListener((SelectionListener)this.createVisSubViewActivator(IVisualizationView.ViewType.SPIDER, solution));
            boolean isMultiObjective = dataSetCollection.getAxes().size() >= 2;
            btnSpiderChart.setEnabled(isMultiObjective);
            btnTable.addSelectionListener((SelectionListener)this.createVisSubViewActivator(IVisualizationView.ViewType.TABLE, solution));
            btnTable.setEnabled(true);
            btnGantt.addSelectionListener((SelectionListener)this.createVisSubViewActivator(IVisualizationView.ViewType.GANTT, solution));
            btnGantt.setEnabled(!ExplorationScheduleUtils.getSchedulingSolutions((DSE)dse).isEmpty());
            IVisualizationView.ViewType viewType = null;
            IVisualizationView.ViewType viewType2 = currentViewType = this.activeView != null ? this.activeView.getViewType() : null;
            if (currentViewType == IVisualizationView.ViewType.SPIDER && btnSpiderChart.isEnabled()) {
                viewType = IVisualizationView.ViewType.SPIDER;
            } else if (currentViewType == IVisualizationView.ViewType.GANTT && btnGantt.isEnabled()) {
                viewType = IVisualizationView.ViewType.GANTT;
            } else if (currentViewType == IVisualizationView.ViewType.TABLE) {
                viewType = IVisualizationView.ViewType.TABLE;
            }
            if (viewType == null) {
                viewType = isMultiObjective && dataSetCollection.getSets().size() >= 2 ? IVisualizationView.ViewType.SPIDER : IVisualizationView.ViewType.TABLE;
            }
            this.switchView(viewType, solution);
        } else {
            this.disposeActiveSubView();
            btnSpiderChart.setEnabled(false);
            btnTable.setEnabled(false);
            btnGantt.setEnabled(false);
        }
    }

    private SelectionAdapter createVisSubViewActivator(final IVisualizationView.ViewType viewType, final DSESolutionVisualizationContainer solution) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualizationViewBackend.this.switchView(viewType, solution);
                VisualizationViewBackend.this.getSctnVisualization().setExpanded(true);
            }
        };
    }

    private void switchView(IVisualizationView.ViewType viewType, DSESolutionVisualizationContainer solution) {
        this.disposeActiveSubView();
        this.activeView = VisualizationViewFactory.createView(this.getVisualizationViewComposite(), viewType, solution);
        this.getSctnVisualization().setExpanded(true);
    }

    private void disposeActiveSubView() {
        if (this.activeView != null) {
            this.activeView.dispose();
            this.activeView = null;
        }
    }

    @Override
    public String helpButtonText() {
        return "Help";
    }

    @Override
    public IProcessManager.EProcessStep getProcessStep() {
        return IProcessManager.EProcessStep.VISUALIZATION;
    }

    @Override
    public void propertyChanged(Object source, IEventListener.DSE_EVENT event) {
        switch (event) {
            case DSE_SELECTED_EVENT: 
            case DSE_REMOVED_EVENT: 
            case PROCESS_STEP_REMOVED: 
            case PROCESS_STEP_SELECTED: {
                this.update();
            }
        }
    }
}

