/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.visualization.visualizations.gantt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.ProcessStep;
import org.fortiss.af3.exploration.model.solutions.SingleExplorationSolution;
import org.fortiss.af3.exploration.service.IDSESolutionExporterService;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionArtifacts;
import org.fortiss.af3.exploration.solutionconverter.ScheduleConverter;
import org.fortiss.af3.exploration.ui.perspective.service.EventBroker;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;
import org.fortiss.af3.exploration.ui.perspective.visualization.DSESolutionVisualizationContainer;
import org.fortiss.af3.exploration.ui.perspective.visualization.visualizations.IVisualizationView;
import org.fortiss.af3.exploration.ui.perspective.visualization.visualizations.gantt.GanttComposite;
import org.fortiss.af3.exploration.util.ExplorationScheduleUtils;
import org.fortiss.af3.exploration.util.ExplorationUtils;
import org.fortiss.af3.schedule.model.SystemSchedule;

public final class GanttScheduleVisualization
implements IVisualizationView,
IEventListener {
    private GanttComposite ganttViewer;
    private DSE dse;

    @Override
    public void createView(Composite composite, DSESolutionVisualizationContainer solutionViz) {
        this.ganttViewer = new GanttComposite(composite, 0);
        this.addSolutionSelectionComboLogic();
        this.dse = IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE();
        if (this.dse != null) {
            this.updateSolutionSelectionCombo(this.dse);
        }
        EventBroker.getInstance().addListener(this);
    }

    private void addSolutionSelectionComboLogic() {
        this.ganttViewer.schedSelectionCombo.addSelectionChangedListener(event -> {
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            Object selElem = selection.getFirstElement();
            if (selElem instanceof SingleExplorationSolution) {
                SingleExplorationSolution solution = (SingleExplorationSolution)selElem;
                ProcessStep currentStep = this.dse.getCurrentStep();
                EList inputModels = ExplorationUtils.getRootElementsFromSnaps((ProcessStep)currentStep, (Collection)new ScheduleConverter().getRequiredInputCopies());
                ArrayList<SingleExplorationSolution> solutions = new ArrayList<SingleExplorationSolution>(Arrays.asList(solution));
                solutions.addAll(ExplorationUtils.getSelectedSolutions((ProcessStep)currentStep));
                DSESolutionArtifacts solArtifacts = new DSESolutionArtifacts((Collection)inputModels, solutions);
                SuperSetMap solutionSets = ExplorationUtils.getSelectedSolutionSets((ProcessStep)currentStep);
                ArrayList solutionTypes = new ArrayList(solutionSets.keySet());
                solutionTypes.addAll(solution.getAvailableSolutionModels());
                solArtifacts = IDSESolutionExporterService.getInstance().transform(solutionTypes, solArtifacts, "temp");
                SystemSchedule solutionSchedule = (SystemSchedule)solArtifacts.getElementOrThrow(SystemSchedule.class);
                this.ganttViewer.viewer.setSchedule(null, (List)solutionSchedule.getScheduleList(), solutionSchedule.getMajorFrame());
            }
        });
    }

    private void updateSolutionSelectionCombo(DSE dse) {
        List solutionList = ExplorationScheduleUtils.getSchedulingSolutions((DSE)dse);
        this.ganttViewer.schedSelectionCombo.setInput((Object)solutionList);
        if (!solutionList.isEmpty()) {
            StructuredSelection selection = new StructuredSelection(solutionList.get(0));
            this.ganttViewer.schedSelectionCombo.setSelection((ISelection)selection);
        }
        this.ganttViewer.viewer.redrawCanvas();
    }

    @Override
    public void dispose() {
        EventBroker.getInstance().removeListener(this);
        if (this.ganttViewer != null) {
            this.ganttViewer.dispose();
        }
    }

    @Override
    public void propertyChanged(Object source, IEventListener.DSE_EVENT event) {
        if (event == IEventListener.DSE_EVENT.DSE_REMOVED_EVENT) {
            if (!this.ganttViewer.isDisposed()) {
                this.dispose();
            }
            this.dse = null;
        }
    }

    @Override
    public IVisualizationView.ViewType getViewType() {
        return IVisualizationView.ViewType.GANTT;
    }
}

