/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.visualization.visualizations.spider;

import javafx.embed.swt.FXCanvas;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.fortiss.af3.exploration.ui.perspective.service.EventBroker;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;
import org.fortiss.af3.exploration.ui.perspective.visualization.DSESolutionVisualizationContainer;
import org.fortiss.af3.exploration.ui.perspective.visualization.visualizations.IVisualizationView;
import org.fortiss.af3.exploration.ui.util.SpiderChartUtils;
import org.fortiss.tooling.base.model.visualization.DataSetCollection;
import org.fortiss.tooling.spiderchart.control.SpiderChartViewer;

public final class SpiderChartVisualization
implements IVisualizationView,
IEventListener {
    private FXCanvas viewer;

    @Override
    public void createView(Composite composite, DSESolutionVisualizationContainer solutionViz) {
        DataSetCollection vizElements = solutionViz.getDataSetCollection();
        this.viewer = new FXCanvas(composite, 0);
        SpiderChartViewer chart = SpiderChartUtils.transformIntoSpiderChart(vizElements);
        Scene scene = new Scene((Parent)chart.getViewerPane());
        this.viewer.setScene(scene);
        this.viewer.setLayoutData((Object)new GridData(4, 4, true, true));
        Rectangle clientArea = composite.getClientArea();
        this.viewer.setBounds(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
        EventBroker.getInstance().addListener(this);
    }

    @Override
    public void dispose() {
        EventBroker.getInstance().removeListener(this);
        if (this.viewer != null) {
            this.viewer.dispose();
        }
    }

    @Override
    public void propertyChanged(Object source, IEventListener.DSE_EVENT event) {
        if (event == IEventListener.DSE_EVENT.DSE_REMOVED_EVENT && this.viewer.isDisposed()) {
            Display.getDefault().asyncExec(() -> this.dispose());
        }
    }

    @Override
    public IVisualizationView.ViewType getViewType() {
        return IVisualizationView.ViewType.SPIDER;
    }
}

