/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.visualization.visualizations.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.fortiss.af3.exploration.dseml.model.expression.SuperSet;
import org.fortiss.af3.exploration.model.IExplorationConstraint;
import org.fortiss.af3.exploration.model.SuperSetMap;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.ModelSnapshot;
import org.fortiss.af3.exploration.model.project.ProcessStep;
import org.fortiss.af3.exploration.model.project.SolutionSelectionStep;
import org.fortiss.af3.exploration.model.project.SystemConstraintSet;
import org.fortiss.af3.exploration.model.solutions.SingleExplorationSolution;
import org.fortiss.af3.exploration.ui.perspective.service.EventBroker;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;
import org.fortiss.af3.exploration.ui.perspective.service.internal.ExplorationCommandRunner;
import org.fortiss.af3.exploration.ui.perspective.visualization.visualizations.table.TableVisualization;
import org.fortiss.af3.exploration.util.DSEProjectModelElementFactory;
import org.fortiss.af3.exploration.util.ExplorationScheduleUtils;
import org.fortiss.af3.exploration.util.ExplorationTimingConstraintUtils;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.af3.timing.model.TimingSpecification;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

abstract class ButtonColumnLabelProvider
extends ColumnLabelProvider {
    protected final TableVisualization tv;
    private final String buttonName;

    public ButtonColumnLabelProvider(String buttonName, TableVisualization tv) {
        this.tv = tv;
        this.buttonName = buttonName;
    }

    protected void createCellContents(ViewerCell cell) {
        TableItem item = (TableItem)cell.getItem();
        Table table = this.tv.getViewer().getTableViewer().getTable();
        Button button = new Button((Composite)table, 0);
        button.setText(this.buttonName);
        button.setData((Object)item);
        button.addSelectionListener((SelectionListener)this.createButtonListener());
        this.tv.getButtonMap().put(cell, button);
        TableEditor editor = new TableEditor(table);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.setEditor((Control)button, item, cell.getColumnIndex());
        editor.layout();
    }

    protected boolean isSolutionSelectionStep() {
        DSE dse = IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE();
        ProcessStep currentStep = dse.getCurrentStep();
        return currentStep instanceof SolutionSelectionStep;
    }

    protected SolutionSelectionStep getSolutionStep() {
        DSE dse = IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE();
        return this.isSolutionSelectionStep() ? (SolutionSelectionStep)dse.getCurrentStep() : null;
    }

    public void update(ViewerCell cell) {
        if (this.tv.getButtonMap().get(cell) == null) {
            this.createCellContents(cell);
        }
    }

    protected SolutionSelectionStep selectSolution(SingleExplorationSolution selectedSolution) {
        SolutionSelectionStep solutionStep;
        DSE dse = IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE();
        if (dse == null) {
            return null;
        }
        ProcessStep step = dse.getCurrentStep();
        if (!(step instanceof SolutionSelectionStep)) {
            solutionStep = this.addSolutionSelectionStep(selectedSolution, dse);
            this.conditionallyAddSchedulingSupplements(selectedSolution, solutionStep);
        } else {
            solutionStep = (SolutionSelectionStep)step;
            ExplorationCommandRunner.getRunner().run(() -> solutionStep.setSelectedSolution(selectedSolution));
            EventBroker.getInstance().firePropertyChanged(solutionStep, IEventListener.DSE_EVENT.PROCESS_STEP_ADDED);
        }
        return solutionStep;
    }

    private void conditionallyAddSchedulingSupplements(SingleExplorationSolution selectedSolution, SolutionSelectionStep solStep) {
        if (selectedSolution.getSolutionModel(TaskToExecutionUnitAllocationEntry.class) != null && selectedSolution.getSolutionModel(ResourceAllocation.class) == null) {
            Optional<SuperSet> ta2HwSet = Optional.of(selectedSolution.getSolutionModel(TaskToExecutionUnitAllocationEntry.class));
            if (!ta2HwSet.isPresent() || ta2HwSet.get().getEntries().isEmpty()) {
                return;
            }
            SuperSet routeSet = solStep.getSuperSetMap().get(Route.class);
            ModelSnapshot modelSnapshot = LambdaUtils.getFirst((Collection)solStep.getModelSnapshots(), ms -> ms.getRootElement() instanceof TimingSpecification).orElse(null);
            if (modelSnapshot == null) {
                return;
            }
            TimingSpecification timingSpec = (TimingSpecification)modelSnapshot.getRootElement();
            ArrayList entityContainments = new ArrayList();
            SuperSetMap schedSuperSets = ExplorationScheduleUtils.constructSchedulableEntities(ta2HwSet, (SuperSet)routeSet, Optional.empty(), (TimingSpecification)timingSpec, entityContainments);
            SystemConstraintSet timingConstraints = ExplorationTimingConstraintUtils.generateTimingConstraints((TimingSpecification)timingSpec, (SuperSet)schedSuperSets.get(ResourceAllocation.class));
            EList innerConstraints = EcoreUtils.pickInstanceOf(IExplorationConstraint.class, (List)timingConstraints.getExplorationTargets());
            ExplorationCommandRunner.getRunner().run(() -> ButtonColumnLabelProvider.lambda$2(solStep, schedSuperSets, entityContainments, timingConstraints, (Collection)innerConstraints));
        }
    }

    private SolutionSelectionStep addSolutionSelectionStep(SingleExplorationSolution selectedSolution, DSE dse) {
        SolutionSelectionStep solStep = DSEProjectModelElementFactory.createSolutionSelectionStep((String)"Selected Solution");
        solStep.setSelectedSolution(selectedSolution);
        UniqueIDUtils.prepareIDs((EObject)solStep, (EObject)dse, (int)UniqueIDUtils.getLargestID((EObject)dse));
        ExplorationCommandRunner.getRunner().run(() -> dse.addProcessStep((ProcessStep)solStep));
        EventBroker.getInstance().firePropertyChanged(solStep, IEventListener.DSE_EVENT.PROCESS_STEP_ADDED);
        return solStep;
    }

    protected abstract ButtonSelectionAdapter createButtonListener();

    private static /* synthetic */ void lambda$2(SolutionSelectionStep solutionSelectionStep, SuperSetMap superSetMap, Collection collection, SystemConstraintSet systemConstraintSet, Collection collection2) {
        solutionSelectionStep.setImplicitSuperSets(superSetMap);
        solutionSelectionStep.getContainedSuperSets().addAll((Collection)superSetMap.values());
        solutionSelectionStep.getOptionalEntityContainments().addAll(collection);
        solutionSelectionStep.getImplicitSystemConstraintSets().add((Object)systemConstraintSet);
        solutionSelectionStep.getSystemConstraintContainmentList().addAll(collection2);
        UniqueIDUtils.generateMissingIDs((EObject)solutionSelectionStep, (int)UniqueIDUtils.getLargestID((EObject)solutionSelectionStep));
    }

    public abstract class ButtonSelectionAdapter
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            ((Button)e.widget).setEnabled(false);
            ButtonColumnLabelProvider.this.tv.removeSortListener();
            ButtonColumnLabelProvider.this.tv.getViewer().getTableViewer().refresh();
        }

        protected SingleExplorationSolution getSingleExplorationSolution(Button button) {
            TableItem item = (TableItem)button.getData();
            Map.Entry entry = (Map.Entry)item.getData();
            return (SingleExplorationSolution)entry.getValue();
        }
    }
}

