/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.visualization.visualizations.table;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.fortiss.af3.exploration.model.project.DSE;
import org.fortiss.af3.exploration.model.project.SolutionSelectionStep;
import org.fortiss.af3.exploration.model.solutions.SingleExplorationSolution;
import org.fortiss.af3.exploration.service.IDSESolutionExporterService;
import org.fortiss.af3.exploration.solutionconverter.DSESolutionArtifacts;
import org.fortiss.af3.exploration.ui.perspective.service.IDSEPerspectiveManager;
import org.fortiss.af3.exploration.ui.perspective.visualization.visualizations.table.ButtonColumnLabelProvider;
import org.fortiss.af3.exploration.ui.perspective.visualization.visualizations.table.TableVisualization;

class ExportButtonColumnLabelProvider
extends ButtonColumnLabelProvider {
    public ExportButtonColumnLabelProvider(TableVisualization tv) {
        super("Export", tv);
    }

    @Override
    protected ButtonColumnLabelProvider.ButtonSelectionAdapter createButtonListener() {
        return new SolutionExportAdapter();
    }

    class SolutionExportAdapter
    extends ButtonColumnLabelProvider.ButtonSelectionAdapter {
        private IDSESolutionExporterService dseSES = IDSESolutionExporterService.getInstance();

        SolutionExportAdapter() {
        }

        @Override
        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            Button button = (Button)e.widget;
            SingleExplorationSolution singleSolution = this.getSingleExplorationSolution(button);
            SolutionSelectionStep solutionStep = ExportButtonColumnLabelProvider.this.selectSolution(singleSolution);
            for (Button otherButton : ExportButtonColumnLabelProvider.this.tv.getButtonMap().values()) {
                if (this.getSingleExplorationSolution(otherButton) != singleSolution) continue;
                otherButton.setEnabled(false);
            }
            ExportButtonColumnLabelProvider.this.tv.getViewer().getTableViewer().refresh();
            DSESolutionArtifacts transformationResult = this.transformSolutions(solutionStep, singleSolution.getName());
            DSE dse = IDSEPerspectiveManager.INSTANCE.getCurrentlySelectedDSE();
            this.dseSES.exportToAF3Project(transformationResult, dse, singleSolution.getName());
        }

        private DSESolutionArtifacts transformSolutions(SolutionSelectionStep solSelStep, String baseName) {
            EList artifacts = solSelStep.getSolutionSuperSetMap().keySet();
            return this.dseSES.transform((Collection)artifacts, solSelStep, baseName);
        }
    }
}

