/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.visualization.visualizations.table;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.fortiss.af3.exploration.model.solutions.SingleExplorationSolution;
import org.fortiss.af3.exploration.ui.perspective.visualization.DSESolutionVisualizationContainer;
import org.fortiss.tooling.base.model.visualization.Axis;
import org.fortiss.tooling.base.model.visualization.DataSet;
import org.fortiss.tooling.base.model.visualization.DataSetCollection;

public class TableComposite
extends Composite {
    private Table table;
    private TableViewer tableViewer;
    TableViewerColumn solutionNameViewerColumn;
    Map<String, TableViewerColumn> addSolCharacteristicsColumns = new LinkedHashMap<String, TableViewerColumn>();
    Map<Axis<?>, TableViewerColumn> axisViewerColumns = new LinkedHashMap();
    TableViewerColumn selectButtonViewerColumn;
    TableViewerColumn exportButtonViewerColumn;

    public TableComposite(Composite parent, int style, DSESolutionVisualizationContainer solutionViz) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.tableViewer = new TableViewer((Composite)this, 67584);
        this.table = this.tableViewer.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createColumns(solutionViz);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    private void createColumns(DSESolutionVisualizationContainer solutionViz) {
        TableColumn tableColumn;
        DataSetCollection dataSetCollection = solutionViz.getDataSetCollection();
        this.solutionNameViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn solutionNameColumn = this.solutionNameViewerColumn.getColumn();
        solutionNameColumn.setWidth(100);
        solutionNameColumn.setText("Model");
        if (dataSetCollection.getSets().isEmpty()) {
            throw new RuntimeException("There must be at least one solution data set.");
        }
        DataSet dataSet = (DataSet)dataSetCollection.getSets().get(0);
        SingleExplorationSolution solution = solutionViz.getSolutionOf(dataSet);
        for (Map.Entry entry : solution.getAdditionalSolutionCharacteristics()) {
            TableViewerColumn tableViewerAdditionalCharacteristicsColumn = new TableViewerColumn(this.tableViewer, 0);
            tableColumn = tableViewerAdditionalCharacteristicsColumn.getColumn();
            tableColumn.setWidth(100);
            tableColumn.setText((String)entry.getKey());
            this.addSolCharacteristicsColumns.put((String)entry.getKey(), tableViewerAdditionalCharacteristicsColumn);
        }
        for (Axis axis : dataSetCollection.getAxes()) {
            TableViewerColumn tableViewerAxisColumn = new TableViewerColumn(this.tableViewer, 0);
            tableColumn = tableViewerAxisColumn.getColumn();
            tableColumn.setWidth(100);
            tableColumn.setText(axis.getName());
            this.axisViewerColumns.put(axis, tableViewerAxisColumn);
        }
        this.selectButtonViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn selectButtonColumn = this.selectButtonViewerColumn.getColumn();
        selectButtonColumn.setWidth(100);
        selectButtonColumn.setText("Select Solution");
        this.exportButtonViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn exportButtonColumn = this.exportButtonViewerColumn.getColumn();
        exportButtonColumn.setWidth(100);
        exportButtonColumn.setText("Export to AF3 Project");
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }
}

