/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.perspective.visualization.visualizations.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.fortiss.af3.exploration.model.solutions.SingleExplorationSolution;
import org.fortiss.af3.exploration.ui.perspective.service.EventBroker;
import org.fortiss.af3.exploration.ui.perspective.service.IEventListener;
import org.fortiss.af3.exploration.ui.perspective.visualization.DSESolutionVisualizationContainer;
import org.fortiss.af3.exploration.ui.perspective.visualization.visualizations.IVisualizationView;
import org.fortiss.af3.exploration.ui.perspective.visualization.visualizations.table.ExportButtonColumnLabelProvider;
import org.fortiss.af3.exploration.ui.perspective.visualization.visualizations.table.SelectionButtonColumnLabelProvider;
import org.fortiss.af3.exploration.ui.perspective.visualization.visualizations.table.TableComposite;
import org.fortiss.tooling.base.model.visualization.Axis;
import org.fortiss.tooling.base.model.visualization.DataPoint;
import org.fortiss.tooling.base.model.visualization.DataSet;

public class TableVisualization
implements IVisualizationView,
IEventListener {
    private TableComposite viewer;
    private Listener sortListener;
    private Map<ViewerCell, Button> buttonMap = new HashMap<ViewerCell, Button>();

    public Map<ViewerCell, Button> getButtonMap() {
        return this.buttonMap;
    }

    @Override
    public void createView(Composite composite, DSESolutionVisualizationContainer solutionViz) {
        this.viewer = new TableComposite(composite, 0, solutionViz);
        this.viewer.setLayoutData(new GridData(4, 4, true, true));
        Rectangle clientArea = composite.getClientArea();
        this.viewer.setBounds(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
        this.createTableContents(solutionViz);
        this.addSortListener();
        EventBroker.getInstance().addListener(this);
    }

    public TableComposite getViewer() {
        return this.viewer;
    }

    private void createTableContents(DSESolutionVisualizationContainer solutionViz) {
        Object labelProvider;
        this.viewer.solutionNameViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                DataSet dataset = (DataSet)((Map.Entry)element).getKey();
                return dataset.getName();
            }
        });
        for (Map.Entry<String, TableViewerColumn> entry : this.viewer.addSolCharacteristicsColumns.entrySet()) {
            labelProvider = new AdditionalSolutionCharacteristicsColumnLabelProvider(entry.getKey());
            entry.getValue().setLabelProvider((CellLabelProvider)labelProvider);
        }
        for (Map.Entry<String, TableViewerColumn> entry : this.viewer.axisViewerColumns.entrySet()) {
            labelProvider = new AxisLabelProvider((Axis)entry.getKey());
            entry.getValue().setLabelProvider((CellLabelProvider)labelProvider);
        }
        SelectionButtonColumnLabelProvider selectionButtonColumnLabelProvider = new SelectionButtonColumnLabelProvider(this);
        this.viewer.selectButtonViewerColumn.setLabelProvider((CellLabelProvider)selectionButtonColumnLabelProvider);
        ExportButtonColumnLabelProvider exportButtonProvider = new ExportButtonColumnLabelProvider(this);
        this.viewer.exportButtonViewerColumn.setLabelProvider((CellLabelProvider)exportButtonProvider);
        this.viewer.getTableViewer().setInput(new ArrayList<Map.Entry<DataSet, SingleExplorationSolution>>(solutionViz.entrySet()));
        for (TableViewerColumn tvc : this.viewer.addSolCharacteristicsColumns.values()) {
            tvc.getColumn().pack();
        }
    }

    private void addSortListener() {
        this.sortListener = new SortListener();
        this.viewer.solutionNameViewerColumn.getColumn().addListener(13, this.sortListener);
        for (TableViewerColumn col : this.viewer.axisViewerColumns.values()) {
            col.getColumn().addListener(13, this.sortListener);
        }
    }

    public void removeSortListener() {
        this.viewer.solutionNameViewerColumn.getColumn().removeListener(13, this.sortListener);
        for (TableViewerColumn col : this.viewer.axisViewerColumns.values()) {
            col.getColumn().removeListener(13, this.sortListener);
        }
    }

    private Object getAxisStartValue(Map.Entry<DataSet, SingleExplorationSolution> entry, Axis<?> axis) {
        DataSet dataset = entry.getKey();
        DataPoint dataPoint = dataset.getPoints().stream().filter(s -> s.getAxis().equals(axis)).findFirst().get();
        return dataPoint.getStart();
    }

    @Override
    public void dispose() {
        EventBroker.getInstance().removeListener(this);
        if (this.viewer != null) {
            this.viewer.dispose();
        }
    }

    @Override
    public void propertyChanged(Object source, IEventListener.DSE_EVENT event) {
        if (event == IEventListener.DSE_EVENT.DSE_REMOVED_EVENT && !this.viewer.isDisposed()) {
            Display.getDefault().asyncExec(() -> this.dispose());
        }
    }

    @Override
    public IVisualizationView.ViewType getViewType() {
        return IVisualizationView.ViewType.TABLE;
    }

    private class AdditionalSolutionCharacteristicsColumnLabelProvider
    extends OwnerDrawLabelProvider {
        private static final int TEXT_MARGIN = 3;
        private String charName;

        public AdditionalSolutionCharacteristicsColumnLabelProvider(String charName) {
            this.charName = charName;
        }

        private String getText(Object element) {
            SingleExplorationSolution sol = (SingleExplorationSolution)((Map.Entry)element).getValue();
            return (String)sol.getAdditionalSolutionCharacteristics().map().get(this.charName);
        }

        protected void erase(Event event, Object element) {
            event.detail &= 0xFFFFFFEF;
        }

        protected void measure(Event event, Object element) {
            String text = this.getText(element);
            Point size = event.gc.textExtent(text);
            event.width = size.x + 6;
            event.height = size.y;
        }

        protected void paint(Event event, Object element) {
            String text = this.getText(element);
            event.gc.drawText(text, event.x + 3, event.y, true);
        }
    }

    private class AxisLabelProvider
    extends ColumnLabelProvider {
        private Axis<?> axis;

        public AxisLabelProvider(Axis<?> axis) {
            this.axis = axis;
        }

        public String getText(Object element) {
            Map.Entry entry = (Map.Entry)element;
            return TableVisualization.this.getAxisStartValue(entry, this.axis).toString();
        }
    }

    private final class SortListener
    implements Listener {
        private static final String ARROW_UP = "\u25b2";
        private static final String ARROW_DOWN = "\u25bc";
        private Map<TableColumn, Boolean> directionMap = new HashMap<TableColumn, Boolean>();

        public SortListener() {
            this.sortColumn(TableVisualization.this.viewer.solutionNameViewerColumn.getColumn());
        }

        public void handleEvent(Event e) {
            TableColumn column = (TableColumn)e.widget;
            this.sortColumn(column);
        }

        public void sortColumn(TableColumn column) {
            Comparator<Map.Entry<DataSet, SingleExplorationSolution>> cmp = null;
            if (column == TableVisualization.this.viewer.solutionNameViewerColumn.getColumn()) {
                cmp = new SolutionNameComparator();
            } else {
                Optional<Map.Entry> colEntry = TableVisualization.this.viewer.axisViewerColumns.entrySet().stream().filter(entry -> ((TableViewerColumn)entry.getValue()).getColumn() == column).findFirst();
                if (colEntry.isPresent()) {
                    Axis axis = (Axis)colEntry.get().getKey();
                    cmp = new SolutionAxisValueComparator(axis);
                }
            }
            if (cmp != null) {
                TableViewer tableViewer = TableVisualization.this.viewer.getTableViewer();
                List data = (List)tableViewer.getInput();
                if (data.size() <= 1) {
                    return;
                }
                boolean sortUp = this.directionMap.getOrDefault(column, true);
                this.directionMap.put(column, !sortUp);
                Collections.sort(data, sortUp ? cmp : cmp.reversed());
                TableColumn[] tableColumnArray = tableViewer.getTable().getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn col = tableColumnArray[n2];
                    String columnTitle = col.getText();
                    if (columnTitle.startsWith(ARROW_UP) || columnTitle.startsWith(ARROW_DOWN)) {
                        columnTitle = columnTitle.substring(2, columnTitle.length());
                        col.setText(columnTitle);
                    }
                    ++n2;
                }
                String columnTitle = (sortUp ? ARROW_UP : ARROW_DOWN) + " " + column.getText();
                column.setText(columnTitle);
                tableViewer.refresh();
            }
        }

        final class SolutionAxisValueComparator
        implements Comparator<Map.Entry<DataSet, SingleExplorationSolution>> {
            private final Axis<?> axis;

            private SolutionAxisValueComparator(Axis<?> axis) {
                this.axis = axis;
            }

            @Override
            public int compare(Map.Entry<DataSet, SingleExplorationSolution> e1, Map.Entry<DataSet, SingleExplorationSolution> e2) {
                Object v1 = TableVisualization.this.getAxisStartValue(e1, this.axis);
                Object v2 = TableVisualization.this.getAxisStartValue(e2, this.axis);
                return Double.compare(this.getDoubleValue(v1), this.getDoubleValue(v2));
            }

            private double getDoubleValue(Object obj) {
                if (obj instanceof Integer) {
                    int tmp = (Integer)obj;
                    return tmp;
                }
                if (obj instanceof Double) {
                    return (Double)obj;
                }
                return 0.0;
            }
        }

        final class SolutionNameComparator
        implements Comparator<Map.Entry<DataSet, SingleExplorationSolution>> {
            SolutionNameComparator() {
            }

            @Override
            public int compare(Map.Entry<DataSet, SingleExplorationSolution> e1, Map.Entry<DataSet, SingleExplorationSolution> e2) {
                String name1 = e1.getValue().getName();
                String name2 = e2.getValue().getName();
                return name1.compareTo(name2);
            }
        }
    }
}

