/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.RGB;
import org.fortiss.af3.exploration.model.IExplorationObjective;
import org.fortiss.af3.exploration.model.solutions.ExplorationResult;
import org.fortiss.af3.exploration.model.solutions.ExplorationSolution;
import org.fortiss.af3.exploration.model.solutions.SingleExplorationSolution;
import org.fortiss.af3.exploration.ui.util.SpiderChartUtils;
import org.fortiss.tooling.base.model.visualization.Axis;
import org.fortiss.tooling.base.model.visualization.DataPoint;
import org.fortiss.tooling.base.model.visualization.DataSet;
import org.fortiss.tooling.base.model.visualization.DataSetCollection;
import org.fortiss.tooling.base.model.visualization.Dimension;
import org.fortiss.tooling.base.utils.VisualizationModelElementFactory;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.graphicsGL.model.Color3D;
import org.fortiss.tooling.graphicsGL.ui.util.ColorUtil;

public class ExplorationSolutionVisualizationUtils {
    public static DataSetCollection createVisualizationFor(ExplorationSolution expSolutionSet) throws InvalidTargetObjectTypeException {
        return ExplorationSolutionVisualizationUtils.createVisualizationFor(expSolutionSet, new HashMap<DataSet, SingleExplorationSolution>());
    }

    public static DataSetCollection createVisualizationFor(ExplorationSolution expSolutionSet, Map<DataSet, SingleExplorationSolution> solutionVisAssoc) throws InvalidTargetObjectTypeException {
        if (expSolutionSet == null || !LambdaUtils.getFirst((Collection)expSolutionSet.getSolutions()).isPresent()) {
            return null;
        }
        DataSetCollection dataSetCol = VisualizationModelElementFactory.createDataSetCollection();
        HashMap objectiveAxes = new HashMap();
        EList targets = expSolutionSet.getExplorationSpec().getTargets();
        for (IExplorationObjective objective : LambdaUtils.filterType((Collection)targets, IExplorationObjective.class)) {
            Axis axis = VisualizationModelElementFactory.createAxis((String)objective.getName());
            objectiveAxes.put(objective, axis);
            dataSetCol.getAxes().add((Object)axis);
        }
        for (SingleExplorationSolution expSolution : expSolutionSet.getSolutions()) {
            String solutionName = expSolution.getName();
            DataSet dataSet = ExplorationSolutionVisualizationUtils.addVisualizationFor(expSolution, solutionName, dataSetCol, objectiveAxes);
            solutionVisAssoc.put(dataSet, expSolution);
        }
        return dataSetCol;
    }

    public static <T> DataSet addVisualizationFor(SingleExplorationSolution expSolution, String name, DataSetCollection dataSetCol, Map<IExplorationObjective<?>, Axis<?>> objectiveAxes) throws InvalidTargetObjectTypeException {
        DataSet dataSet = VisualizationModelElementFactory.createDataSet((String)name);
        Iterator iterator = LambdaUtils.filterTypeSafe((Collection)expSolution.keySet(), IExplorationObjective.class).iterator();
        while (iterator.hasNext()) {
            IExplorationObjective expObjective;
            IExplorationObjective castedObjective = expObjective = (IExplorationObjective)iterator.next();
            Dimension dim = VisualizationModelElementFactory.createDimension((String)(expObjective.getName() + "_Dimension"));
            dataSet.getPoints().add(ExplorationSolutionVisualizationUtils.createDataPoint(castedObjective, objectiveAxes.get(expObjective), dim, expSolution));
        }
        dataSetCol.getSets().add((Object)dataSet);
        return dataSet;
    }

    public static <T> DataPoint<T> createDataPoint(IExplorationObjective<T> expObjective, Axis<T> objectiveAxis, Dimension<T> dim, SingleExplorationSolution expSolution) {
        ExplorationResult value = expSolution.get(expObjective);
        return VisualizationModelElementFactory.createDataPoint((Object)value.getResult(), (Object)value.getResult(), objectiveAxis, dim);
    }

    public static RGB getColor(double p) {
        RGB rgb;
        if (p <= 0.5) {
            rgb = new RGB(255, (int)((p *= 2.0) * 255.0), 0);
        } else if (p <= 1.0) {
            p = (1.0 - p) * 2.0;
            rgb = new RGB((int)(p * 255.0), 255, 0);
        } else {
            return null;
        }
        return rgb;
    }

    public static double getGradientPrecentage(int max, int min, int value) {
        return 1.0 - (double)(value - min) * 1.0 / (double)(max - min) * 1.0;
    }

    public static double getGradientPrecentage(double max, double min, double value) {
        if (max == min) {
            return 1.0;
        }
        return 1.0 - (value - min) * 1.0 / (max - min) * 1.0;
    }

    public static Color3D get4DimColor(Axis<?> dim4, DataSet set, DataSetCollection dataSets) {
        ArrayList<Double> values = new ArrayList<Double>();
        for (DataSet s : dataSets.getSets()) {
            values.add(SpiderChartUtils.getValueOfAxis(s, dim4));
        }
        Collections.sort(values);
        return ExplorationSolutionVisualizationUtils.gradient(values, SpiderChartUtils.getValueOfAxis(set, dim4));
    }

    public static Color3D gradient(ArrayList<Integer> orderedValues, int value) {
        if (orderedValues.isEmpty()) {
            return null;
        }
        int max = orderedValues.get(orderedValues.size() - 1);
        int min = orderedValues.get(0);
        double p = ExplorationSolutionVisualizationUtils.getGradientPrecentage(max, min, value);
        if (min == max) {
            p = 1.0;
        }
        RGB rgb = ExplorationSolutionVisualizationUtils.getColor(p);
        Color3D col = ColorUtil.rgbToColor3D((RGB)rgb);
        return col;
    }

    public static Color3D gradient(ArrayList<Double> orderedValues, double value) {
        double max = Collections.max(orderedValues);
        double min = Collections.min(orderedValues);
        double p = ExplorationSolutionVisualizationUtils.getGradientPrecentage(max, min, value);
        if (min == max) {
            p = 1.0;
        }
        RGB rgb = ExplorationSolutionVisualizationUtils.getColor(p);
        Color3D col = ColorUtil.rgbToColor3D((RGB)rgb);
        return col;
    }
}

