/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.util;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.fortiss.af3.exploration.ui.AF3ExplorationUIActivator;
import org.fortiss.af3.exploration.ui.perspective.DSEperspective;
import org.fortiss.af3.exploration.ui.perspective.dashboard.DashboardFXViewPart;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeUIProviderBase;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class ExplorationUiUtils {
    public static void updateTreeWithComboSelection(ComboViewer comboViewer, TreeViewer treeViewer) {
        IStructuredSelection selection = (IStructuredSelection)comboViewer.getSelection();
        Object ca = selection.getFirstElement();
        treeViewer.setInput(ca);
        treeViewer.expandAll();
    }

    public static String getFQNID(Class<?> type) {
        return type.getName();
    }

    public static <T extends INamedElement> DynamicTreeUIProviderBase<T> createNameProvider() {
        return new DynamicTreeUIProviderBase<T>(){

            public String getLabel(T element) {
                return element.getName();
            }
        };
    }

    public static void showDSEPerspective() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
        IPerspectiveDescriptor dsePespective = wb.getPerspectiveRegistry().findPerspectiveWithId(ExplorationUiUtils.getFQNID(DSEperspective.class));
        activePage.setPerspective(dsePespective);
        try {
            activePage.showView(ExplorationUiUtils.getFQNID(DashboardFXViewPart.class));
        }
        catch (PartInitException e) {
            LoggingUtils.error((Plugin)AF3ExplorationUIActivator.getDefault(), (String)"Could not open the DSE dashboard.");
        }
    }
}

