/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.exploration.ui.util;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javafx.scene.paint.Color;
import org.eclipse.swt.graphics.RGB;
import org.fortiss.af3.schedule.ui.ganttchartview.ScheduleViewColors;
import org.fortiss.tooling.base.model.visualization.Axis;
import org.fortiss.tooling.base.model.visualization.DataPoint;
import org.fortiss.tooling.base.model.visualization.DataSet;
import org.fortiss.tooling.base.model.visualization.DataSetCollection;
import org.fortiss.tooling.common.ui.javafx.style.FillStyle;
import org.fortiss.tooling.common.ui.javafx.style.FontStyle;
import org.fortiss.tooling.common.ui.javafx.style.LineStyle;
import org.fortiss.tooling.spiderchart.control.SpiderChartViewer;
import org.fortiss.tooling.spiderchart.model.AxisBase;
import org.fortiss.tooling.spiderchart.model.DataSeries;
import org.fortiss.tooling.spiderchart.model.DoubleAxis;
import org.fortiss.tooling.spiderchart.model.SpiderChart;
import org.fortiss.tooling.spiderchart.style.AxisStyle;
import org.fortiss.tooling.spiderchart.style.ChartStyle;
import org.fortiss.tooling.spiderchart.style.DataSeriesStyle;
import org.fortiss.tooling.spiderchart.style.LegendStyle;

public class SpiderChartUtils {
    public static double getMaxAxisValue(DataSetCollection setCollection, Axis<?> axis) {
        double max = 0.0;
        for (DataSet set : setCollection.getSets()) {
            for (DataPoint point : set.getPoints()) {
                if (point.getAxis().equals(axis) && point.getStart() instanceof Double) {
                    max = Math.max((Double)point.getStart(), max);
                    max = Math.max((Double)point.getEnd(), max);
                    continue;
                }
                if (!point.getAxis().equals(axis) || !(point.getStart() instanceof Integer)) continue;
                max = Math.max((double)((Integer)point.getStart()).intValue(), max);
                max = Math.max((double)((Integer)point.getEnd()).intValue(), max);
            }
        }
        return max;
    }

    public static double getMinAxisValue(DataSetCollection setCollection, Axis<?> axis) {
        double min = 0.0;
        for (DataSet set : setCollection.getSets()) {
            for (DataPoint point : set.getPoints()) {
                if (point.getAxis().equals(axis) && point.getStart() instanceof Double) {
                    min = Math.min((Double)point.getStart(), min);
                    min = Math.min((Double)point.getEnd(), min);
                    continue;
                }
                if (!point.getAxis().equals(axis) || !(point.getStart() instanceof Integer)) continue;
                min = Math.min((double)((Integer)point.getStart()).intValue(), min);
                min = Math.min((double)((Integer)point.getEnd()).intValue(), min);
            }
        }
        return min;
    }

    public static List<Double> getAllValuesOFAxis(DataSetCollection setCollection, Axis<?> axis) {
        ArrayList<Double> results = new ArrayList<Double>();
        for (DataSet set : setCollection.getSets()) {
            for (DataPoint point : set.getPoints()) {
                double e;
                if (point.getAxis().equals(axis) && point.getStart() instanceof Double) {
                    e = (Double)point.getStart();
                    results.add(e);
                    continue;
                }
                if (!point.getAxis().equals(axis) || !(point.getStart() instanceof Integer)) continue;
                e = ((Integer)point.getStart()).intValue();
                results.add(e);
            }
        }
        return results;
    }

    public static Double getValueOfAxis(DataSet set, Axis<?> axis) {
        for (DataPoint point : set.getPoints()) {
            if (point.getAxis().equals(axis) && point.getStart() instanceof Double) {
                return (double)((Double)point.getStart());
            }
            if (!point.getAxis().equals(axis) || !(point.getStart() instanceof Integer)) continue;
            return (double)((Integer)point.getStart());
        }
        return -1.0;
    }

    public static SpiderChartViewer transformIntoSpiderChart(DataSetCollection dataSetCollection) {
        SpiderChart spiderChart = new SpiderChart();
        spiderChart.setTitle(dataSetCollection.getName());
        spiderChart.setLegendLabel("Legend");
        ChartStyle chartStyle = new ChartStyle(true, true, false);
        chartStyle.setTitleStyle(new FontStyle("Verdana", 14.0, Color.BLUE.darker()));
        LegendStyle legendStyle = new LegendStyle(false, 5.0, FontStyle.BLACK_VERDANA_12PT);
        chartStyle.setLegendStyle(legendStyle);
        chartStyle.setAxisSegments(4);
        chartStyle.setBackgroundFillStyle(new FillStyle(Color.LIGHTGRAY));
        chartStyle.setBackgroundLineStyle(new LineStyle(Color.DARKGRAY));
        HashMap<Axis, DoubleAxis> modelToVisAxisMapping = new HashMap<Axis, DoubleAxis>();
        for (Axis a : dataSetCollection.getAxes()) {
            double max = SpiderChartUtils.getMaxAxisValue(dataSetCollection, a);
            double maxAxisValue = max * 1.2;
            double minAxisValue = 0.0;
            DoubleAxis axis = new DoubleAxis(a.getName(), Double.valueOf(minAxisValue), Double.valueOf(maxAxisValue));
            spiderChart.addAxis((AxisBase)axis);
            AxisStyle aStyle4Segs = new AxisStyle(LineStyle.SOLID_BLACK_1PT, FontStyle.BLACK_VERDANA_14PT, 4, FontStyle.BLACK_VERDANA_8PT, new DecimalFormat("#.##"));
            chartStyle.setAxisStyle((AxisBase)axis, aStyle4Segs);
            modelToVisAxisMapping.put(a, axis);
        }
        Random rand = new Random(System.currentTimeMillis());
        for (DataSet s : dataSetCollection.getSets()) {
            DataSeries dataSeries = new DataSeries(s.getName());
            for (DataPoint p : s.getPoints()) {
                Double value = 0.0;
                if (p.getStart() instanceof Integer) {
                    value = (double)((Integer)p.getStart());
                } else if (p.getStart() instanceof Double) {
                    value = (double)((Double)p.getStart());
                }
                dataSeries.setPoint((AxisBase)modelToVisAxisMapping.get(p.getAxis()), (Object)value);
            }
            RGB rgb = ScheduleViewColors.getColor((int)rand.nextInt(255)).getRGB();
            Color color = new Color((double)rgb.red / 255.0, (double)rgb.green / 255.0, (double)rgb.blue / 255.0, 1.0);
            LineStyle line = new LineStyle(color.darker());
            FillStyle fill = new FillStyle(color.brighter(), 0.5);
            DataSeriesStyle style = new DataSeriesStyle(line, fill, true, true, FontStyle.BLACK_VERDANA_10PT, 7.0, new DecimalFormat("#.#"));
            chartStyle.setDataSeriesStyle(dataSeries, style);
            spiderChart.addData(dataSeries);
        }
        return new SpiderChartViewer(spiderChart, chartStyle);
    }
}

