/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.graphicsGL.util;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.graphicsGL.model.Color3D;
import org.fortiss.tooling.graphicsGL.model.graph.Axis3D;
import org.fortiss.tooling.graphicsGL.model.graph.CoordinateSystem3D;
import org.fortiss.tooling.graphicsGL.model.graph.Graph3D;
import org.fortiss.tooling.graphicsGL.model.graph.GraphFactory;
import org.fortiss.tooling.graphicsGL.model.graph.GraphLine3D;
import org.fortiss.tooling.graphicsGL.model.graph.GraphPoint3D;
import org.fortiss.tooling.graphicsGL.model.graph.GraphText3D;
import org.fortiss.tooling.graphicsGL.util.Graphics3DModelElementFactory;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class Graph3DModelElementFactory {
    public static GraphPoint3D graphPoint(float x, float y, float z) {
        GraphPoint3D point = GraphFactory.eINSTANCE.createGraphPoint3D();
        point.setPosition(Graphics3DModelElementFactory.vector(x, y, z));
        return point;
    }

    public static GraphLine3D graphLine(GraphPoint3D start, GraphPoint3D end) {
        GraphLine3D line = GraphFactory.eINSTANCE.createGraphLine3D();
        line.setStart(start);
        line.setEnd(end);
        return line;
    }

    public static Axis3D axis(float length, Color3D color) {
        Axis3D axis = GraphFactory.eINSTANCE.createAxis3D();
        axis.setLength(length);
        axis.setColor((Color3D)EcoreUtils.copy((EObject)color));
        return axis;
    }

    public static CoordinateSystem3D coordSystem(Axis3D xAxis, Axis3D yAxis, Axis3D zAxis) {
        CoordinateSystem3D sys = GraphFactory.eINSTANCE.createCoordinateSystem3D();
        sys.setXAxis(xAxis);
        sys.setYAxis(yAxis);
        sys.setZAxis(zAxis);
        return sys;
    }

    public static Graph3D graph(CoordinateSystem3D system, List<GraphPoint3D> points, List<GraphLine3D> lines) {
        Graph3D g = GraphFactory.eINSTANCE.createGraph3D();
        g.setCoordinateSystem(system);
        g.getPoints().addAll(points);
        g.getLines().addAll(lines);
        return g;
    }

    public static GraphText3D text(String text, GraphPoint3D pos) {
        GraphText3D gt = GraphFactory.eINSTANCE.createGraphText3D();
        gt.setText(text);
        gt.setPosition(pos);
        return gt;
    }
}

