/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.graphicsGL.util;

import java.util.List;
import org.fortiss.tooling.graphicsGL.model.Color3D;
import org.fortiss.tooling.graphicsGL.model.mesh.Face3D;
import org.fortiss.tooling.graphicsGL.model.mesh.Material3D;
import org.fortiss.tooling.graphicsGL.model.mesh.MaterialGroup3D;
import org.fortiss.tooling.graphicsGL.model.mesh.Mesh3D;
import org.fortiss.tooling.graphicsGL.model.mesh.MeshFactory;
import org.fortiss.tooling.graphicsGL.model.mesh.Normal3D;
import org.fortiss.tooling.graphicsGL.model.mesh.Vertex3D;
import org.fortiss.tooling.graphicsGL.util.Graphics3DModelElementFactory;

public class Mesh3DModelElementFactory {
    public static final Material3D DEFAULT_MATERIAL = Mesh3DModelElementFactory.material(Graphics3DModelElementFactory.color(0.4f, 0.4f, 0.4f), Graphics3DModelElementFactory.color(0.8f, 0.8f, 0.8f), Graphics3DModelElementFactory.color(1.0f, 1.0f, 1.0f), 1.0f);

    public static Vertex3D vertex(float x, float y, float z) {
        Vertex3D v = MeshFactory.eINSTANCE.createVertex3D();
        v.setX(x);
        v.setY(y);
        v.setZ(z);
        return v;
    }

    public static Normal3D normal(float x, float y, float z) {
        Normal3D n = MeshFactory.eINSTANCE.createNormal3D();
        n.setX(x);
        n.setY(y);
        n.setZ(z);
        return n;
    }

    public static Face3D triangleFace(Vertex3D v1, Vertex3D v2, Vertex3D v3) {
        Face3D face = MeshFactory.eINSTANCE.createFace3D();
        face.getVertices().add((Object)Mesh3DModelElementFactory.vertex(v1.getX(), v1.getY(), v1.getZ()));
        face.getVertices().add((Object)Mesh3DModelElementFactory.vertex(v2.getX(), v2.getY(), v2.getZ()));
        face.getVertices().add((Object)Mesh3DModelElementFactory.vertex(v3.getX(), v3.getY(), v3.getZ()));
        return face;
    }

    public static Face3D triangleFace(Vertex3D v1, Vertex3D v2, Vertex3D v3, Normal3D n1, Normal3D n2, Normal3D n3) {
        Face3D f = Mesh3DModelElementFactory.triangleFace(v1, v2, v3);
        f.getNormals().add((Object)Mesh3DModelElementFactory.normal(n1.getX(), n1.getY(), n1.getZ()));
        f.getNormals().add((Object)Mesh3DModelElementFactory.normal(n2.getX(), n2.getY(), n2.getZ()));
        f.getNormals().add((Object)Mesh3DModelElementFactory.normal(n3.getX(), n3.getY(), n3.getZ()));
        return f;
    }

    public static Face3D quadFace(Vertex3D v1, Vertex3D v2, Vertex3D v3, Vertex3D v4) {
        Face3D face = MeshFactory.eINSTANCE.createFace3D();
        face.getVertices().add((Object)Mesh3DModelElementFactory.vertex(v1.getX(), v1.getY(), v1.getZ()));
        face.getVertices().add((Object)Mesh3DModelElementFactory.vertex(v2.getX(), v2.getY(), v2.getZ()));
        face.getVertices().add((Object)Mesh3DModelElementFactory.vertex(v3.getX(), v3.getY(), v3.getZ()));
        face.getVertices().add((Object)Mesh3DModelElementFactory.vertex(v4.getX(), v4.getY(), v4.getZ()));
        return face;
    }

    public static Face3D quadFace(Vertex3D v1, Vertex3D v2, Vertex3D v3, Vertex3D v4, Normal3D n1, Normal3D n2, Normal3D n3, Normal3D n4) {
        Face3D f = Mesh3DModelElementFactory.quadFace(v1, v2, v3, v4);
        f.getNormals().add((Object)Mesh3DModelElementFactory.normal(n1.getX(), n1.getY(), n1.getZ()));
        f.getNormals().add((Object)Mesh3DModelElementFactory.normal(n2.getX(), n2.getY(), n2.getZ()));
        f.getNormals().add((Object)Mesh3DModelElementFactory.normal(n3.getX(), n3.getY(), n3.getZ()));
        f.getNormals().add((Object)Mesh3DModelElementFactory.normal(n4.getX(), n4.getY(), n4.getZ()));
        return f;
    }

    public static Mesh3D mesh(List<MaterialGroup3D> groups) {
        Mesh3D m = MeshFactory.eINSTANCE.createMesh3D();
        m.getMaterialGroups().addAll(groups);
        return m;
    }

    public static MaterialGroup3D materialGroup(Material3D m, List<Face3D> faces, boolean smoothShading) {
        MaterialGroup3D group = MeshFactory.eINSTANCE.createMaterialGroup3D();
        group.setMaterial(Mesh3DModelElementFactory.material(m.getAmbient(), m.getDiffuse(), m.getSpecular(), m.getSpecularCoeff()));
        group.setSmoothShading(smoothShading);
        group.getFaces().addAll(faces);
        return group;
    }

    public static Material3D material(Color3D ambient) {
        Material3D m = MeshFactory.eINSTANCE.createMaterial3D();
        m.setAmbient(Graphics3DModelElementFactory.color(ambient.getRed(), ambient.getGreen(), ambient.getBlue()));
        return m;
    }

    public static Material3D material(Color3D ambient, Color3D diffuse) {
        Material3D m = Mesh3DModelElementFactory.material(ambient);
        m.setDiffuse(Graphics3DModelElementFactory.color(diffuse.getRed(), diffuse.getGreen(), diffuse.getBlue()));
        return m;
    }

    public static Material3D material(Color3D ambient, Color3D diffuse, Color3D specular, float specularCoeff) {
        Material3D m = Mesh3DModelElementFactory.material(ambient, diffuse);
        m.setSpecular(Graphics3DModelElementFactory.color(specular.getRed(), specular.getGreen(), specular.getBlue()));
        m.setSpecularCoeff(specularCoeff);
        return m;
    }
}

