/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.graphicsGL.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.fortiss.tooling.graphicsGL.model.Color3D;
import org.fortiss.tooling.graphicsGL.model.mesh.Face3D;
import org.fortiss.tooling.graphicsGL.model.mesh.Material3D;
import org.fortiss.tooling.graphicsGL.model.mesh.MaterialGroup3D;
import org.fortiss.tooling.graphicsGL.model.mesh.Mesh3D;
import org.fortiss.tooling.graphicsGL.model.mesh.Normal3D;
import org.fortiss.tooling.graphicsGL.model.mesh.Vertex3D;
import org.fortiss.tooling.graphicsGL.model.scene.Object3D;
import org.fortiss.tooling.graphicsGL.util.Graphics3DModelElementFactory;
import org.fortiss.tooling.graphicsGL.util.Mesh3DModelElementFactory;
import org.fortiss.tooling.graphicsGL.util.Scene3DModelElementFactory;

public class OBJLoaderUtil {
    private Map<String, Material3D> materials = new HashMap<String, Material3D>();
    private List<Vertex3D> vertices = new ArrayList<Vertex3D>();
    private List<Normal3D> normals = new ArrayList<Normal3D>();
    private List<Face3D> faces = new ArrayList<Face3D>();
    private List<MaterialGroup3D> matGroups = new ArrayList<MaterialGroup3D>();
    private Material3D material = null;
    private String objectName = null;
    private boolean smoothShading = false;
    private List<Object3D> objectData;

    public OBJLoaderUtil(File objFile) throws IOException {
        List objData = FileSystemUtils.readLinesUTF8((File)objFile);
        for (String line : objData) {
            if (!line.startsWith("mtllib ")) continue;
            File matFile = new File(objFile.getParentFile(), line.split(" ")[1]);
            this.loadMaterial(FileSystemUtils.readLinesUTF8((File)matFile));
        }
        this.loadVerticesAndNormals(objData);
        this.loadObjects(objData);
    }

    public OBJLoaderUtil(List<String> objectData, List<String> materialData) {
        this.loadMaterial(materialData);
        this.loadVerticesAndNormals(objectData);
        this.loadObjects(objectData);
    }

    private void loadVerticesAndNormals(List<String> objData) {
        for (String line : objData) {
            if (line.startsWith("#")) continue;
            if (line.startsWith("vn ")) {
                this.addNormal(line.split(" "));
                continue;
            }
            if (!line.startsWith("v ")) continue;
            this.addVertex(line.split(" "));
        }
    }

    public List<Object3D> getLoadedObjects() {
        return this.objectData;
    }

    private void loadObjects(List<String> objData) {
        this.objectData = new LinkedList<Object3D>();
        for (String line : objData) {
            if (line.startsWith("#")) continue;
            if (line.startsWith("f ")) {
                this.addFace(line.split(" "));
                continue;
            }
            if (line.startsWith("s ")) {
                if (!line.split(" ")[1].equals("1")) continue;
                this.smoothShading = true;
                continue;
            }
            if (line.startsWith("o ")) {
                this.addMaterialGroup();
                this.addObject(this.objectData);
                this.objectName = line.split(" ")[1];
                continue;
            }
            if (!line.startsWith("usemtl ")) continue;
            this.addMaterialGroup();
            String mat = line.split(" ")[1];
            this.material = this.materials.get(mat);
            if (this.material != null) continue;
            throw new IllegalArgumentException("Unknown material used in OBJ file: " + mat);
        }
        this.addMaterialGroup();
        this.addObject(this.objectData);
    }

    private void addMaterialGroup() {
        if (this.material != null) {
            this.matGroups.add(Mesh3DModelElementFactory.materialGroup(this.material, this.faces, this.smoothShading));
            this.material = null;
            this.smoothShading = false;
            this.faces.clear();
        }
    }

    private void addObject(List<Object3D> result) {
        if (!this.matGroups.isEmpty()) {
            Mesh3D mesh = Mesh3DModelElementFactory.mesh(this.matGroups);
            result.add(Scene3DModelElementFactory.object3D(this.objectName, "", 0.0f, 0.0f, 0.0f, mesh));
            this.objectName = null;
            this.material = null;
            this.faces.clear();
            this.matGroups.clear();
        }
    }

    private void addFace(String[] tokens) {
        if (tokens.length != 4) {
            throw new IllegalArgumentException("OBJ file contains non-triangles.");
        }
        int[] v1 = this.getVertexData(tokens[1]);
        int[] v2 = this.getVertexData(tokens[2]);
        int[] v3 = this.getVertexData(tokens[3]);
        Face3D f = Mesh3DModelElementFactory.triangleFace(this.vertices.get(v1[0]), this.vertices.get(v2[0]), this.vertices.get(v3[0]), this.normals.get(v1[1]), this.normals.get(v2[1]), this.normals.get(v3[1]));
        this.faces.add(f);
    }

    private int[] getVertexData(String s) {
        String[] ids = s.split("/");
        if (ids.length != 3) {
            throw new IllegalArgumentException("OBJ file does not contain normal vectors.");
        }
        return new int[]{Integer.valueOf(ids[0]) - 1, Integer.valueOf(ids[2]) - 1};
    }

    private void addVertex(String[] tokens) {
        this.vertices.add(Mesh3DModelElementFactory.vertex(Float.valueOf(tokens[1]).floatValue(), Float.valueOf(tokens[2]).floatValue(), Float.valueOf(tokens[3]).floatValue()));
    }

    private void addNormal(String[] tokens) {
        this.normals.add(Mesh3DModelElementFactory.normal(Float.valueOf(tokens[1]).floatValue(), Float.valueOf(tokens[2]).floatValue(), Float.valueOf(tokens[3]).floatValue()));
    }

    public void loadMaterial(List<String> lines) {
        String matName = null;
        Color3D ambient = null;
        Color3D diffuse = null;
        Color3D specular = null;
        float specularCoeff = 0.0f;
        for (String line : lines) {
            String[] tokens;
            if (line.startsWith("#") || (tokens = line.split(" ")).length <= 1) continue;
            if ("newmtl".equals(tokens[0])) {
                if (matName != null) {
                    Material3D newMat = Mesh3DModelElementFactory.material(ambient, diffuse, specular, specularCoeff);
                    this.materials.put(matName, newMat);
                    ambient = Graphics3DModelElementFactory.color(0.0f, 0.0f, 0.0f);
                    diffuse = Graphics3DModelElementFactory.color(0.0f, 0.0f, 0.0f);
                    specular = Graphics3DModelElementFactory.color(0.0f, 0.0f, 0.0f);
                    specularCoeff = 0.0f;
                }
                matName = tokens[1];
                continue;
            }
            if ("Ka".equals(tokens[0])) {
                ambient = Graphics3DModelElementFactory.color(Float.valueOf(tokens[1]).floatValue(), Float.valueOf(tokens[2]).floatValue(), Float.valueOf(tokens[3]).floatValue());
                continue;
            }
            if ("Kd".equals(tokens[0])) {
                diffuse = Graphics3DModelElementFactory.color(Float.valueOf(tokens[1]).floatValue(), Float.valueOf(tokens[2]).floatValue(), Float.valueOf(tokens[3]).floatValue());
                continue;
            }
            if ("Ks".equals(tokens[0])) {
                specular = Graphics3DModelElementFactory.color(Float.valueOf(tokens[1]).floatValue(), Float.valueOf(tokens[2]).floatValue(), Float.valueOf(tokens[3]).floatValue());
                continue;
            }
            if (!"Ns".equals(tokens[0])) continue;
            specularCoeff = Float.valueOf(tokens[1]).floatValue();
        }
        if (matName != null) {
            Material3D newMat = Mesh3DModelElementFactory.material(ambient, diffuse, specular, specularCoeff);
            this.materials.put(matName, newMat);
        }
    }
}

