/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.graphicsGL.util;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.graphicsGL.model.Color3D;
import org.fortiss.tooling.graphicsGL.model.mesh.Mesh3D;
import org.fortiss.tooling.graphicsGL.model.scene.Camera3D;
import org.fortiss.tooling.graphicsGL.model.scene.Light3D;
import org.fortiss.tooling.graphicsGL.model.scene.Object3D;
import org.fortiss.tooling.graphicsGL.model.scene.Scene3D;
import org.fortiss.tooling.graphicsGL.model.scene.SceneFactory;
import org.fortiss.tooling.graphicsGL.util.Graphics3DModelElementFactory;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class Scene3DModelElementFactory {
    public static Object3D object3D(float x, float y, float z, Mesh3D mesh) {
        Object3D o = SceneFactory.eINSTANCE.createObject3D();
        o.setMesh(mesh);
        o.setPosition(Graphics3DModelElementFactory.vector(x, y, z));
        return o;
    }

    public static Object3D object3D(String name, String comment, float x, float y, float z, Mesh3D mesh) {
        Object3D o = Scene3DModelElementFactory.object3D(x, y, z, mesh);
        o.setName(name);
        o.setComment(comment);
        return o;
    }

    public static Light3D light3D(float x, float y, float z, Color3D color) {
        Light3D l = SceneFactory.eINSTANCE.createLight3D();
        l.setPosition(Graphics3DModelElementFactory.vector(x, y, z));
        l.setDiffuse((Color3D)EcoreUtils.copy((EObject)color));
        return l;
    }

    public static Light3D light3D(float x, float y, float z, Color3D ambient, Color3D diffuse, Color3D specular) {
        Light3D l = SceneFactory.eINSTANCE.createLight3D();
        l.setPosition(Graphics3DModelElementFactory.vector(x, y, z));
        l.setAmbient((Color3D)EcoreUtils.copy((EObject)ambient));
        l.setDiffuse((Color3D)EcoreUtils.copy((EObject)diffuse));
        l.setSpecular((Color3D)EcoreUtils.copy((EObject)specular));
        l.setAttenuation(Graphics3DModelElementFactory.vector(1.0f, 0.0f, 0.0f));
        return l;
    }

    public static Light3D light3D(String name, String comment, float x, float y, float z, Color3D ambient, Color3D diffuse, Color3D specular) {
        Light3D l = Scene3DModelElementFactory.light3D(x, y, z, ambient, diffuse, specular);
        l.setName(name);
        l.setComment(comment);
        return l;
    }

    public static Camera3D camera3D(float posX, float posY, float posZ, float tx, float ty, float tz) {
        Camera3D cam = SceneFactory.eINSTANCE.createCamera3D();
        cam.setPosition(Graphics3DModelElementFactory.vector(posX, posY, posZ));
        cam.setLookAtLocation(Graphics3DModelElementFactory.vector(tx, ty, tz));
        return cam;
    }

    public static Camera3D camera3d(String name, String comment, float posX, float posY, float posZ, float tx, float ty, float tz) {
        Camera3D c = Scene3DModelElementFactory.camera3D(posX, posY, posZ, tx, ty, tz);
        c.setName(name);
        c.setComment(comment);
        return c;
    }

    public static Scene3D scene3D() {
        return SceneFactory.eINSTANCE.createScene3D();
    }

    public static Scene3D scene3D(List<Object3D> objects, List<Light3D> lights, List<Camera3D> cameras) {
        Scene3D scene = Scene3DModelElementFactory.scene3D();
        scene.getObjects().addAll(objects);
        scene.getLights().addAll(lights);
        scene.getCameras().addAll(cameras);
        return scene;
    }
}

