/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.compositor;

import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.ResourceAllocationFragment;
import org.fortiss.af3.schedule.model.SubSchedule;
import org.fortiss.af3.schedule.model.SystemSchedule;
import org.fortiss.tooling.base.compose.ModelElementCompositorBase;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.extension.data.IElementCompositionContext;
import org.fortiss.tooling.kernel.extension.data.Prototype;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class ResourceAllocationCompositor
extends ModelElementCompositorBase<ResourceAllocation> {
    public boolean compose(ResourceAllocation container, EObject contained, IElementCompositionContext context) {
        if (contained instanceof SubSchedule) {
            container.setSubSchedule((SubSchedule)contained);
        } else if (contained instanceof ResourceAllocationFragment) {
            container.getFragments().add((Object)((ResourceAllocationFragment)contained));
        } else assert (false);
        return super.compose((EObject)container, contained, context);
    }

    public boolean canCompose(ResourceAllocation container, EObject contained, IElementCompositionContext context) {
        SystemSchedule systemSchedule = (SystemSchedule)KernelModelElementUtils.getParentElement((EObject)container, SystemSchedule.class, (boolean)false);
        AllocationTableCollection atc = systemSchedule.getAllocationTableCollection();
        boolean isCaAllocation = false;
        if (atc != null) {
            IModelElement modelElement = container.getSchedulableEntity().getModelElement();
            AllocationTable at = AllocationUtils.getAllocationTableWithTargetElement((AllocationTableCollection)atc, (IModelElement)modelElement);
            isCaAllocation = at.getSourceView() instanceof ComponentArchitecture;
        }
        boolean isSubSchedule = container.getSubSchedule() == null && contained instanceof SubSchedule;
        boolean isResourceAllocationFragment = contained instanceof ResourceAllocationFragment;
        return !isCaAllocation && isSubSchedule || isResourceAllocationFragment;
    }

    public boolean canComposePrototype(Prototype prototype) {
        return this.isCorrectElementClass(prototype.getPrototype());
    }

    public boolean canDecompose(EObject contained) {
        return this.isCorrectElementClass(contained);
    }

    private boolean isCorrectElementClass(EObject element) {
        return ReflectionUtils.isInstanceOfAny((Object)element, (Class[])new Class[]{SubSchedule.class, ResourceAllocationFragment.class});
    }
}

