/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.utils;

import java.math.BigDecimal;
import org.fortiss.af3.platform.model.IPlatformResource;
import org.fortiss.af3.schedule.model.AF3ScheduleFactory;
import org.fortiss.af3.schedule.model.PeriodicFlexibilityTimeTrigger;
import org.fortiss.af3.schedule.model.PeriodicTimeTrigger;
import org.fortiss.af3.schedule.model.RateConstraintTrigger;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.ResourceAllocationFragment;
import org.fortiss.af3.schedule.model.ResourceSchedule;
import org.fortiss.af3.schedule.model.SchedulableEntity;
import org.fortiss.af3.schedule.model.SubSchedule;
import org.fortiss.af3.schedule.model.SystemSchedule;

public class AF3ScheduleModelElementFactory {
    public static SystemSchedule createSystemSchedule(String name) {
        SystemSchedule systemSchedule = AF3ScheduleFactory.eINSTANCE.createSystemSchedule();
        systemSchedule.setName(name);
        return systemSchedule;
    }

    public static ResourceSchedule createResourceSchedule(IPlatformResource resource, String name) {
        ResourceSchedule resourceSchedule = AF3ScheduleModelElementFactory.createResourceSchedule(name);
        resourceSchedule.setResource(resource);
        return resourceSchedule;
    }

    public static ResourceSchedule createResourceSchedule(String name) {
        ResourceSchedule resourceSchedule = AF3ScheduleFactory.eINSTANCE.createResourceSchedule();
        resourceSchedule.setName(name);
        return resourceSchedule;
    }

    public static SubSchedule createSubSchedule(String name) {
        SubSchedule subSchedule = AF3ScheduleFactory.eINSTANCE.createSubSchedule();
        subSchedule.setName(name);
        return subSchedule;
    }

    public static SchedulableEntity createSchedulableEntity(String name) {
        SchedulableEntity schedulableEntity = AF3ScheduleFactory.eINSTANCE.createSchedulableEntity();
        schedulableEntity.setName(name);
        return schedulableEntity;
    }

    public static ResourceAllocation createResourceAllocation(String name) {
        ResourceAllocation resourceAllocation = AF3ScheduleFactory.eINSTANCE.createResourceAllocation();
        resourceAllocation.setName(name);
        resourceAllocation.setSchedulableEntity(AF3ScheduleModelElementFactory.createSchedulableEntity(null));
        return resourceAllocation;
    }

    public static ResourceAllocationFragment createResourceAllocationFragment(String name) {
        ResourceAllocationFragment resourceAllocationFragment = AF3ScheduleFactory.eINSTANCE.createResourceAllocationFragment();
        resourceAllocationFragment.setName(name);
        resourceAllocationFragment.setTrigger(AF3ScheduleFactory.eINSTANCE.createResourceAllocationFragmentTimeTrigger());
        return resourceAllocationFragment;
    }

    public static PeriodicTimeTrigger createPeriodicTimeTrigger(BigDecimal period, BigDecimal phase) {
        PeriodicTimeTrigger periodicTimeTrigger = AF3ScheduleFactory.eINSTANCE.createPeriodicTimeTrigger();
        periodicTimeTrigger.setPeriod(period);
        periodicTimeTrigger.setStartTime(phase);
        return periodicTimeTrigger;
    }

    public static PeriodicFlexibilityTimeTrigger createPeriodicFlexibilityTimeTrigger(BigDecimal phase) {
        return AF3ScheduleModelElementFactory.createPeriodicFlexibilityTimeTrigger(phase, BigDecimal.ZERO);
    }

    public static PeriodicFlexibilityTimeTrigger createPeriodicFlexibilityTimeTrigger(BigDecimal phase, BigDecimal flexibility) {
        PeriodicFlexibilityTimeTrigger periodicFlexibilityTimeTrigger = AF3ScheduleFactory.eINSTANCE.createPeriodicFlexibilityTimeTrigger();
        periodicFlexibilityTimeTrigger.setStartTime(phase);
        periodicFlexibilityTimeTrigger.setFlexibility(flexibility);
        return periodicFlexibilityTimeTrigger;
    }

    public static RateConstraintTrigger createRateConstraintTrigger(BigDecimal mint, BigDecimal jitter) {
        RateConstraintTrigger rateConstraintTrigger = AF3ScheduleFactory.eINSTANCE.createRateConstraintTrigger();
        rateConstraintTrigger.setMint(mint);
        rateConstraintTrigger.setJitter(jitter);
        return rateConstraintTrigger;
    }
}

