/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;

public class MathUtils {
    public static int gcd(int a, int b) {
        while (b > 0) {
            int temp = b;
            b = a % b;
            a = temp;
        }
        return a;
    }

    public static int gcdIntegerCollection(Collection<Integer> input) {
        for (int i : input) {
            if (i > 0) continue;
            throw new IllegalArgumentException("Collection must contain only positive elments.");
        }
        int result = -1;
        for (int i : input) {
            result = result < 0 ? i : MathUtils.gcd(result, i);
        }
        return result;
    }

    public static BigInteger gcdBigIntegerCollection(Collection<BigInteger> input) {
        for (BigInteger i : input) {
            if (i.compareTo(BigInteger.ZERO) == 1) continue;
            throw new IllegalArgumentException("Collection must contain only positive elments.");
        }
        BigInteger result = null;
        for (BigInteger i : input) {
            result = result == null ? i : result.gcd(i);
        }
        return result;
    }

    public static int lcm(int a, int b) {
        return a * (b / MathUtils.gcd(a, b));
    }

    public static BigInteger lcm(BigInteger a, BigInteger b) {
        return a.multiply(b.divide(a.gcd(b)));
    }

    public static int lcmIntegerCollection(Collection<Integer> input) {
        for (int i : input) {
            if (i > 0) continue;
            throw new IllegalArgumentException("Collection must contain only positive elments.");
        }
        int result = -1;
        for (int i : input) {
            result = result < 0 ? i : MathUtils.lcm(result, i);
        }
        return result;
    }

    public static BigInteger lcmBigIntegerCollection(Collection<BigInteger> input) {
        for (BigInteger i : input) {
            if (i.compareTo(BigInteger.ZERO) == 1) continue;
            throw new IllegalArgumentException("Collection must contain only positive elments.");
        }
        BigInteger result = null;
        for (BigInteger i : input) {
            result = result == null ? i : MathUtils.lcm(result, i);
        }
        return result;
    }

    private static double reduceDoubleCollectionByDelegatingToBigInteger(BigIntegerReductionFunction bigIntegerFunction, Collection<Double> doubles, int precision) {
        int largestExponent = MathUtils.getReqExponentForIntegerCalc10Double(doubles, precision);
        double scaleUpFactor = Math.pow(10.0, largestExponent);
        Collection lcmNumbersBigInteger = doubles.stream().map(n -> BigDecimal.valueOf(n * scaleUpFactor).toBigInteger()).collect(Collectors.toList());
        BigDecimal result = BigDecimal.valueOf(bigIntegerFunction.reduce(lcmNumbersBigInteger).doubleValue() * Math.pow(10.0, -largestExponent));
        return MathUtils.round(result, largestExponent).doubleValue();
    }

    private static BigDecimal reduceBigDecimalCollectionByDelegatingToBigInteger(BigIntegerReductionFunction bigIntegerFunction, Collection<BigDecimal> bigDecimals, int tolerance) {
        int largestExponent = MathUtils.getReqExponentForIntegerCalc10(bigDecimals, tolerance);
        BigDecimal scaleUpFactor = BigDecimal.ONE.movePointRight(largestExponent);
        Collection lcmNumbersBigInteger = bigDecimals.stream().map(n -> n.multiply(scaleUpFactor).toBigInteger()).collect(Collectors.toList());
        BigDecimal result = new BigDecimal(bigIntegerFunction.reduce(lcmNumbersBigInteger)).movePointLeft(largestExponent);
        return MathUtils.round(result, largestExponent);
    }

    public static double lcmDoubleCollection(Collection<Double> lcmNumbers, int precision) {
        return MathUtils.reduceDoubleCollectionByDelegatingToBigInteger(MathUtils::lcmBigIntegerCollection, lcmNumbers, precision);
    }

    public static BigDecimal lcmBigDecimalCollection(Collection<BigDecimal> lcmNumbers, int precision) {
        return MathUtils.reduceBigDecimalCollectionByDelegatingToBigInteger(MathUtils::lcmBigIntegerCollection, lcmNumbers, precision);
    }

    public static BigDecimal gcdBigDecimalCollection(Collection<BigDecimal> gcdNumbers, int precision) {
        return MathUtils.reduceBigDecimalCollectionByDelegatingToBigInteger(MathUtils::gcdBigIntegerCollection, gcdNumbers, precision);
    }

    public static double gcdDoubleCollection(Collection<Double> gcdNumbers, int precision) {
        return MathUtils.reduceDoubleCollectionByDelegatingToBigInteger(MathUtils::gcdBigIntegerCollection, gcdNumbers, precision);
    }

    public static BigDecimal round(BigDecimal bigDecimal, int precision) {
        return bigDecimal.setScale(precision, RoundingMode.HALF_UP);
    }

    public static double round(double d, int precision) {
        if (d == (double)((int)d)) {
            return d;
        }
        return MathUtils.round(BigDecimal.valueOf(d), precision).doubleValue();
    }

    public static int getPrecision(double d, int maxiumPrecision) {
        if ((d = MathUtils.round(d, maxiumPrecision)) == 0.0) {
            return 0;
        }
        if (d < 0.0) {
            d *= -1.0;
        }
        int i = 0;
        while ((double)((int)d) != d) {
            d = MathUtils.round(d * 10.0, maxiumPrecision);
            ++i;
        }
        return i;
    }

    public static int getPrecision(BigDecimal d, int maxiumPrecision) {
        return Math.min(maxiumPrecision, d.scale());
    }

    private static int getReqExponentForIntegerCalc10Double(Collection<Double> numbers, int precision) {
        ArrayList<BigDecimal> convertedNumbers = new ArrayList<BigDecimal>();
        convertedNumbers.addAll(numbers.stream().map(n -> BigDecimal.valueOf(n)).collect(Collectors.toList()));
        return MathUtils.getReqExponentForIntegerCalc10(convertedNumbers, precision);
    }

    private static int getReqExponentForIntegerCalc10(Collection<BigDecimal> numbers, int precision) {
        if (numbers == null || numbers.isEmpty()) {
            throw new IllegalArgumentException("The collection of numbers may not be empty.");
        }
        ArrayList<Integer> reqExponentPerNumber = new ArrayList<Integer>();
        for (BigDecimal currNumber : numbers) {
            reqExponentPerNumber.add(MathUtils.getRequiredIndividualExponent(currNumber, precision));
        }
        Optional effectiveExponent = reqExponentPerNumber.stream().reduce(Integer::max);
        if (!effectiveExponent.isPresent()) {
            throw new ArithmeticException("An error occured during the calculation of the required exponent.");
        }
        return (Integer)effectiveExponent.get();
    }

    private static int getRequiredIndividualExponent(BigDecimal number, int precision) {
        int reqMinExponent = MathUtils.getNormalizingExponent10(number);
        reqMinExponent = reqMinExponent <= 0 ? 0 : reqMinExponent;
        BigDecimal shiftedNumber = number.movePointRight(reqMinExponent);
        int i = 0;
        while (i < precision) {
            if (shiftedNumber.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0) {
                return reqMinExponent + i;
            }
            shiftedNumber = shiftedNumber.movePointRight(1);
            ++i;
        }
        return reqMinExponent + precision;
    }

    private static int getNormalizingExponent10(BigDecimal number) {
        int normExponent = 0;
        int step = number.compareTo(BigDecimal.ONE) < 0 ? 1 : -1;
        step = number.compareTo(BigDecimal.ZERO) == 0 ? 0 : step;
        BigDecimal shiftedNumber = number;
        while (step > 0 && shiftedNumber.compareTo(BigDecimal.ONE) < 0 || step < 0 && shiftedNumber.compareTo(BigDecimal.ONE) > 0) {
            shiftedNumber = MathUtils.shiftBigDecimal(shiftedNumber, step);
            normExponent += step;
        }
        if (shiftedNumber.compareTo(BigDecimal.ONE) == 0) {
            --normExponent;
        }
        return normExponent;
    }

    public static BigDecimal shiftBigDecimal(BigDecimal number, int shift) {
        if (shift > 0) {
            return number.movePointRight(shift);
        }
        if (shift < 0) {
            return number.movePointLeft(-shift);
        }
        return number;
    }

    public static double roundToNearestQuarterHalfFull(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        int i = 0;
        while (d > 1.0) {
            d /= 10.0;
            --i;
        }
        while (d < 0.1) {
            d *= 10.0;
            ++i;
        }
        if (d > 0.5) {
            d = 1.0;
        } else if (d > 0.25) {
            d = 0.5;
        } else if (d > 0.1) {
            d = 0.25;
        }
        return d * Math.pow(10.0, -i);
    }

    public static BigDecimal roundToNearestQuarterHalfFull(BigDecimal d) {
        if (d.equals(BigDecimal.ZERO)) {
            return BigDecimal.ZERO;
        }
        int i = 0;
        while (d.compareTo(BigDecimal.ONE) == 1) {
            d = d.movePointLeft(1);
            --i;
        }
        while (d.compareTo(BigDecimal.valueOf(0.1)) == -1) {
            d = d.movePointRight(1);
            ++i;
        }
        if (d.compareTo(BigDecimal.valueOf(0.5)) == 1) {
            d = BigDecimal.ONE;
        } else if (d.compareTo(BigDecimal.valueOf(0.25)) == 1) {
            d = BigDecimal.valueOf(0.5);
        } else if (d.compareTo(BigDecimal.valueOf(0.1)) == 1) {
            d = BigDecimal.valueOf(0.25);
        }
        return d.movePointLeft(i);
    }

    private static interface BigIntegerReductionFunction {
        public BigInteger reduce(Collection<BigInteger> var1);
    }
}

