/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.IPlatformResource;
import org.fortiss.af3.schedule.AF3ScheduleActivator;
import org.fortiss.af3.schedule.model.PeriodicTimeTrigger;
import org.fortiss.af3.schedule.model.RateConstraintTrigger;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.ResourceAllocationFragment;
import org.fortiss.af3.schedule.model.ResourceAllocationFragmentTimeTrigger;
import org.fortiss.af3.schedule.model.ResourceAllocationTrigger;
import org.fortiss.af3.schedule.model.ResourceSchedule;
import org.fortiss.af3.schedule.model.Schedule;
import org.fortiss.af3.schedule.model.SubSchedule;
import org.fortiss.af3.schedule.model.SystemSchedule;
import org.fortiss.af3.schedule.model.TimeTrigger;
import org.fortiss.af3.schedule.utils.MathUtils;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class ScheduleUtils {
    public static final int TOLERANCE = 6;
    public static final int TRANSMISSION_TIME = 5;

    public static BigDecimal getMint(ResourceAllocation resourceAllocation) {
        ResourceAllocationTrigger trigger = resourceAllocation.getTrigger();
        if (trigger instanceof RateConstraintTrigger) {
            return ((RateConstraintTrigger)trigger).getMint();
        }
        return null;
    }

    public static BigDecimal getJitter(ResourceAllocation resourceAllocation) {
        ResourceAllocationTrigger trigger = resourceAllocation.getTrigger();
        if (trigger instanceof RateConstraintTrigger) {
            return ((RateConstraintTrigger)trigger).getJitter();
        }
        return null;
    }

    public static boolean setJitter(ResourceAllocation resourceAllocation, BigDecimal jitter) {
        ResourceAllocationTrigger trigger = resourceAllocation.getTrigger();
        if (trigger instanceof RateConstraintTrigger) {
            ((RateConstraintTrigger)trigger).setJitter(jitter);
            return true;
        }
        return false;
    }

    public static Integer getPriority(ResourceAllocation resourceAllocation) {
        ResourceAllocationTrigger trigger = resourceAllocation.getTrigger();
        if (trigger instanceof RateConstraintTrigger) {
            return ((RateConstraintTrigger)trigger).getPriority();
        }
        return null;
    }

    public static boolean setPriority(ResourceAllocation resourceAllocation, Integer priority) {
        ResourceAllocationTrigger trigger = resourceAllocation.getTrigger();
        if (trigger instanceof RateConstraintTrigger) {
            ((RateConstraintTrigger)trigger).setPriority(priority);
            return true;
        }
        return false;
    }

    public static BigDecimal getPhase(ResourceAllocation resourceAllocation) {
        ResourceAllocationTrigger trigger = resourceAllocation.getTrigger();
        if (trigger instanceof TimeTrigger) {
            return ((TimeTrigger)((Object)trigger)).getStartTime();
        }
        return null;
    }

    public static BigDecimal getPhase(ResourceAllocationFragment resourceAllocationFragment) {
        ResourceAllocationFragmentTimeTrigger trigger = resourceAllocationFragment.getTrigger();
        if (trigger instanceof ResourceAllocationFragmentTimeTrigger) {
            return trigger.getStartTime();
        }
        return null;
    }

    public static boolean setPhase(ResourceAllocation resourceAllocation, BigDecimal phase) {
        ResourceAllocationTrigger trigger = resourceAllocation.getTrigger();
        if (trigger instanceof TimeTrigger) {
            ((TimeTrigger)((Object)trigger)).setStartTime(phase);
            return true;
        }
        return false;
    }

    public static BigDecimal getPeriod(ResourceAllocation resourceAllocation) {
        ResourceAllocationTrigger trigger = resourceAllocation.getTrigger();
        if (trigger instanceof PeriodicTimeTrigger) {
            return ((PeriodicTimeTrigger)trigger).getPeriod();
        }
        return null;
    }

    public static boolean setPeriod(ResourceAllocation resourceAllocation, BigDecimal period) {
        ResourceAllocationTrigger trigger = resourceAllocation.getTrigger();
        if (trigger instanceof PeriodicTimeTrigger) {
            ((PeriodicTimeTrigger)trigger).setPeriod(period);
            return true;
        }
        return false;
    }

    public static BigDecimal getHyperPeriod(Schedule schedule) {
        return schedule instanceof ResourceSchedule ? ((ResourceSchedule)schedule).getHyperPeriod() : ScheduleUtils.getPeriod(((SubSchedule)schedule).getRefinedResourceAllocation());
    }

    public static void calculateSystemHyperPeriods(SystemSchedule schedule, boolean override) {
        EList subSchedules = EcoreUtils.pickInstanceOf(ResourceSchedule.class, (List)schedule.getScheduleList());
        List<ResourceSchedule> ecuSchedules = subSchedules.stream().filter(s -> s.getResource() instanceof ExecutionUnit).collect(Collectors.toList());
        ecuSchedules.forEach(s -> ScheduleUtils.calculateHyperPeriod(s, override));
        if (override || schedule.getMajorFrame() == null) {
            ArrayList<BigDecimal> periods = new ArrayList<BigDecimal>();
            ecuSchedules.forEach(s -> {
                boolean bl = periods.add(s.getHyperPeriod());
            });
            schedule.setMajorFrame(MathUtils.lcmBigDecimalCollection(periods, 6));
        }
    }

    public static void calculateHyperPeriod(ResourceSchedule schedule, boolean override) {
        if (!override && schedule.getHyperPeriod() != null) {
            return;
        }
        ArrayList<BigDecimal> periods = new ArrayList<BigDecimal>();
        schedule.getResourceAllocationList().forEach(ra -> {
            boolean bl = periods.add(ScheduleUtils.getPeriod(ra));
        });
        schedule.setHyperPeriod(MathUtils.lcmBigDecimalCollection(periods, 6));
    }

    private static boolean updateDerivedValuesRec(EObject obj) {
        ResourceAllocation resourceAllocation;
        boolean rval = true;
        if (obj instanceof SystemSchedule) {
            SystemSchedule systemSchedule = (SystemSchedule)obj;
            if (!systemSchedule.getScheduleList().isEmpty()) {
                for (Schedule schedule : systemSchedule.getScheduleList()) {
                    rval &= ScheduleUtils.updateDerivedValuesRec((EObject)schedule);
                }
                try {
                    systemSchedule.setMajorFrame(MathUtils.lcmBigDecimalCollection(systemSchedule.getScheduleList().stream().map(s -> ScheduleUtils.getHyperPeriod(s)).filter(p -> p != null).collect(Collectors.toList()), 6));
                }
                catch (Exception e) {
                    rval = false;
                }
            }
        } else if (obj instanceof ResourceSchedule) {
            ResourceSchedule resourceSchedule = (ResourceSchedule)obj;
            if (!resourceSchedule.getResourceAllocationList().isEmpty()) {
                for (ResourceAllocation resourceAllocation2 : resourceSchedule.getResourceAllocationList()) {
                    rval &= ScheduleUtils.updateDerivedValuesRec((EObject)resourceAllocation2);
                }
                try {
                    resourceSchedule.setHyperPeriod(MathUtils.lcmBigDecimalCollection(resourceSchedule.getResourceAllocationList().stream().map(r -> ScheduleUtils.getPeriod(r)).filter(p -> p != null).collect(Collectors.toList()), 6));
                }
                catch (Exception e) {
                    rval = false;
                }
            }
        } else if (obj instanceof ResourceAllocation && !(resourceAllocation = (ResourceAllocation)obj).getFragments().isEmpty()) {
            BigDecimal duration = resourceAllocation.getFragments().stream().map(r -> r.getDuration() != null ? r.getDuration() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b));
            resourceAllocation.setDuration(duration);
            if (resourceAllocation.getTrigger() instanceof TimeTrigger) {
                Optional<BigDecimal> earliestStartTime = resourceAllocation.getFragments().stream().map(r -> r.getTrigger() != null && r.getTrigger().getStartTime() != null ? r.getTrigger().getStartTime() : BigDecimal.ZERO).min(BigDecimal::compareTo);
                ScheduleUtils.setPhase(resourceAllocation, earliestStartTime.orElse(BigDecimal.ZERO));
            }
        }
        return rval;
    }

    public static boolean updateDerivedValues(SystemSchedule systemSchedule) {
        return ScheduleUtils.updateDerivedValuesRec((EObject)systemSchedule);
    }

    public static boolean updateDerivedValues(EObject obj) {
        return ScheduleUtils.updateDerivedValues((SystemSchedule)KernelModelElementUtils.getParentElement((EObject)obj, SystemSchedule.class, (boolean)true));
    }

    private static int getHighestRequiredPrecision(ResourceAllocation resourceAllocation, int maxPrecision) {
        int phasePrecision;
        BigDecimal phase;
        int periodPrecision;
        BigDecimal period;
        int rval = 0;
        if (resourceAllocation.getDuration() != null) {
            rval = MathUtils.getPrecision(resourceAllocation.getDuration(), maxPrecision);
        }
        if ((period = ScheduleUtils.getPeriod(resourceAllocation)) != null && (periodPrecision = MathUtils.getPrecision(period, maxPrecision)) > rval) {
            rval = periodPrecision;
        }
        if ((phase = ScheduleUtils.getPhase(resourceAllocation)) != null && (phasePrecision = MathUtils.getPrecision(phase, maxPrecision)) > rval) {
            rval = phasePrecision;
        }
        for (ResourceAllocationFragment resourceAllocationFragment : resourceAllocation.getFragments()) {
            int phaseFragmentPrecision;
            int durationFragmentPrecision;
            if (resourceAllocationFragment.getDuration() != null && (durationFragmentPrecision = MathUtils.getPrecision(resourceAllocationFragment.getDuration(), maxPrecision)) > rval) {
                rval = durationFragmentPrecision;
            }
            if ((phase = ScheduleUtils.getPhase(resourceAllocationFragment)) == null || (phaseFragmentPrecision = MathUtils.getPrecision(phase, maxPrecision)) <= rval) continue;
            rval = phaseFragmentPrecision;
        }
        return rval;
    }

    private static int getHighestRequiredPrecision(Schedule schedule, int maxPrecision) {
        int rval = 0;
        for (ResourceAllocation resourceAllocation : schedule.getResourceAllocationList()) {
            int precision = ScheduleUtils.getHighestRequiredPrecision(resourceAllocation, maxPrecision);
            if (precision <= rval) continue;
            rval = precision;
        }
        return rval;
    }

    public static int getHighestRequiredPrecision(List<Schedule> schedules, int maxPrecision) {
        int rval = 0;
        for (Schedule schedule : schedules) {
            int precision = ScheduleUtils.getHighestRequiredPrecision(schedule, maxPrecision);
            if (precision <= rval) continue;
            rval = precision;
        }
        return rval;
    }

    public static int getHighestRequiredPrecision(SystemSchedule systemSchedule, int maxPrecision) {
        return ScheduleUtils.getHighestRequiredPrecision((List<Schedule>)systemSchedule.getScheduleList(), maxPrecision);
    }

    public static ResourceAllocation getResourceAllocation(Schedule schedule, IModelElement modelElement) {
        for (ResourceAllocation resourceAllocation : schedule.getResourceAllocationList()) {
            if (resourceAllocation.getSchedulableEntity().getModelElement() == modelElement) {
                return resourceAllocation;
            }
            if (resourceAllocation.getSubSchedule() == null) continue;
            return ScheduleUtils.getResourceAllocation(resourceAllocation.getSubSchedule(), modelElement);
        }
        return null;
    }

    public static ResourceAllocation getResourceAllocation(SystemSchedule systemSchedule, IModelElement modelElement) {
        for (Schedule schedule : systemSchedule.getScheduleList()) {
            ResourceAllocation resourceAllocation = ScheduleUtils.getResourceAllocation(schedule, modelElement);
            if (resourceAllocation == null) continue;
            return resourceAllocation;
        }
        return null;
    }

    public static ResourceSchedule getResourceSchedule(SystemSchedule systemSchedule, IPlatformResource modelElement) {
        List<ResourceSchedule> scheduleList = ScheduleUtils.getResourceSchedules(systemSchedule, IPlatformResource.class);
        return ScheduleUtils.getResourceSchedule(scheduleList, modelElement);
    }

    public static ResourceSchedule getResourceSchedule(List<ResourceSchedule> scheduleList, IPlatformResource modelElement) {
        for (Schedule schedule : scheduleList) {
            if (!(schedule instanceof ResourceSchedule) || ((IIdLabeled)((ResourceSchedule)schedule).getResource()).getId() != ((IIdLabeled)modelElement).getId()) continue;
            return (ResourceSchedule)schedule;
        }
        return null;
    }

    public static List<ResourceSchedule> getResourceSchedules(SystemSchedule systemSchedule, Class<? extends IPlatformResource> type) {
        ArrayList<ResourceSchedule> resourceSchedules = new ArrayList<ResourceSchedule>();
        for (Schedule schedule : systemSchedule.getScheduleList()) {
            if (!(schedule instanceof ResourceSchedule) || !type.isAssignableFrom(((ResourceSchedule)schedule).getResource().getClass())) continue;
            resourceSchedules.add((ResourceSchedule)schedule);
        }
        return resourceSchedules;
    }

    public static String formatTimeTriggeredResourceAllocation(ResourceAllocation resourceAllocation) {
        if (resourceAllocation == null) {
            return "<>";
        }
        BigDecimal period = ScheduleUtils.getPeriod(resourceAllocation);
        BigDecimal phase = ScheduleUtils.getPhase(resourceAllocation);
        return "period=" + String.valueOf(period != null ? period : "?") + ", phase=" + String.valueOf(phase != null ? phase : "?");
    }

    public static String formatRateConstraintResourceAllocation(ResourceAllocation resourceAllocation) {
        if (resourceAllocation == null) {
            return "<>";
        }
        BigDecimal mint = ScheduleUtils.getMint(resourceAllocation);
        BigDecimal jitter = ScheduleUtils.getJitter(resourceAllocation);
        Integer priority = ScheduleUtils.getPriority(resourceAllocation);
        return "mint=" + String.valueOf(mint != null ? mint : "?") + ", jitter=" + String.valueOf(jitter != null ? jitter : "?") + ", priority" + String.valueOf(priority != null ? priority : "?");
    }

    public static String formatResourceAllocation(ResourceAllocation resourceAllocation) {
        ResourceAllocationTrigger trigger;
        ResourceAllocationTrigger resourceAllocationTrigger = trigger = resourceAllocation != null ? resourceAllocation.getTrigger() : null;
        if (trigger instanceof PeriodicTimeTrigger) {
            return ScheduleUtils.formatTimeTriggeredResourceAllocation(resourceAllocation);
        }
        if (trigger instanceof RateConstraintTrigger) {
            return ScheduleUtils.formatRateConstraintResourceAllocation(resourceAllocation);
        }
        return "!";
    }

    public static String formatResourceSchedule(ResourceSchedule resourceSchedule) {
        if (resourceSchedule == null) {
            return "<>";
        }
        BigDecimal period = resourceSchedule.getHyperPeriod();
        return KernelModelElementUtils.computeFullyQualifiedName((INamedElement)resourceSchedule) + ", period=" + String.valueOf(period != null ? period : "?");
    }

    public static void csvDescription(SystemSchedule systemSchedule) {
        if (systemSchedule == null) {
            LoggingUtils.warning((Plugin)AF3ScheduleActivator.getDefault(), (String)"Cannot output a csv file. The system schedule does not exist.");
            return;
        }
        Object output = "";
        for (Schedule schedule : systemSchedule.getScheduleList()) {
            ResourceSchedule resourceSchedule = (ResourceSchedule)schedule;
            for (ResourceAllocation ra : schedule.getResourceAllocationList()) {
                IModelElement element = ra.getSchedulableEntity().getModelElement();
                output = (String)output + ((INamedElement)element).getName() + "," + String.valueOf(((TimeTrigger)((Object)ra.getTrigger())).getStartTime()) + "," + String.valueOf(ra.getDuration()) + "," + ((INamedElement)resourceSchedule.getResource()).getName() + "," + resourceSchedule.getFrequency() + "\n";
            }
        }
        try {
            PrintWriter writer = new PrintWriter(String.valueOf(Platform.getLocation()) + "/schedule_" + System.currentTimeMillis() + ".csv", "UTF-8");
            writer.print((String)output);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

