/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.variability.analysis;

import com.microsoft.z3.BoolSort;
import com.microsoft.z3.Context;
import com.microsoft.z3.EnumSort;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.IntSort;
import com.microsoft.z3.SeqSort;
import com.microsoft.z3.Sort;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.fortiss.variability.analysis.DualKeyMap;
import org.fortiss.variability.analysis.EMFProductLineModelTranslation;
import org.fortiss.variability.analysis.constraint.ComplexPreComputedFunctionBase;
import org.fortiss.variability.analysis.constraint.IPreComputedFunction;
import org.fortiss.variability.analysis.constraint.PrimitivePreComputedFunctionBase;
import org.fortiss.variability.util.VariabilityUtilsInternal;

public class EMFProductLineMetaModelTranslation {
    IntSort intSort;
    SeqSort<?> stringSort;
    BoolSort boolSort;
    Map<EDataType, Sort> eDataType2Sort;
    Map<EClass, EnumSort<?>> eClass2z3Sort;
    Map<Enum<?>, Expr<?>> eLiteral2Expr;
    Map<EClass, Expr<?>> eClass2NullElement;
    Map<EEnum, Expr<?>> eEnum2NullElement;
    DualKeyMap<EReference, EClass, EClass> reference2TranslatedEClass;
    DualKeyMap<EAttribute, EClass, FuncDecl<?>> eAttribute2FunDecl;
    DualKeyMap<EReference, EClass, FuncDecl<?>> eReference2FunDecl;
    DualKeyMap<IPreComputedFunction<?, ?>, EClass, FuncDecl<?>> preComputedFunction2FunDecl;
    private Context ctx;
    private EMFProductLineModelTranslation translation;

    EMFProductLineMetaModelTranslation(EMFProductLineModelTranslation translation) {
        this.translation = translation;
        this.ctx = translation.getContext();
        this.reference2TranslatedEClass = new DualKeyMap();
        this.eDataType2Sort = new HashMap<EDataType, Sort>();
        this.eClass2z3Sort = new HashMap();
        this.eLiteral2Expr = new HashMap();
        this.eClass2NullElement = new HashMap();
        this.eEnum2NullElement = new HashMap();
        this.eAttribute2FunDecl = new DualKeyMap();
        this.eReference2FunDecl = new DualKeyMap();
        this.preComputedFunction2FunDecl = new DualKeyMap();
        this.intSort = this.ctx.mkIntSort();
        this.stringSort = this.ctx.mkStringSort();
        this.boolSort = this.ctx.mkBoolSort();
        this.eDataType2Sort.put(EcorePackage.Literals.EINT, (Sort)this.intSort);
        this.eDataType2Sort.put(EcorePackage.Literals.ESTRING, (Sort)this.stringSort);
        this.eDataType2Sort.put(EcorePackage.Literals.EBOOLEAN, (Sort)this.boolSort);
    }

    void translateAttributesAndReferencesMetamodel() {
        for (EClass ec : this.translation.translatedClasses) {
            FuncDecl funDecl;
            String funId;
            for (EAttribute ea : ec.getEAllAttributes()) {
                if (!this.translation.translatedAttributes.contains(ea)) continue;
                funId = ec.getName() + "_" + ea.getName();
                EDataType attDataType = ea.getEAttributeType();
                Sort rangeSort = this.eDataType2Sort.get(attDataType);
                if (attDataType instanceof EEnum && rangeSort == null) {
                    rangeSort = this.translateEnum((EEnum)attDataType);
                    this.eDataType2Sort.put(attDataType, rangeSort);
                }
                if (rangeSort == null) continue;
                funDecl = this.ctx.mkFuncDecl(funId, (Sort)this.eClass2z3Sort.get(ec), rangeSort);
                this.eAttribute2FunDecl.put(ea, ec, funDecl);
            }
            for (EReference er : ec.getEAllReferences()) {
                if (!this.translation.translatedReferences.contains(er)) continue;
                funId = ec.getName() + "_" + er.getName();
                EClass refType = this.reference2TranslatedEClass.get(er, this.translation.getTranslatedClass(ec));
                Sort refSort = (Sort)this.eClass2z3Sort.get(refType);
                if (refSort == null) {
                    for (EClass ecls : this.translation.translatedClasses) {
                        if (!refType.isSuperTypeOf(ecls)) continue;
                        refSort = (Sort)this.eClass2z3Sort.get(ecls);
                    }
                }
                if (refSort == null) {
                    String msg = "Reference " + er.getName() + " shall be translated, but is of type " + refType.getName() + " which is not translated. Add the type to the translated classes to translate this reference.";
                    VariabilityUtilsInternal.logError("[EMF product-line translation]: " + msg, null);
                    throw new RuntimeException(msg);
                }
                if (er.getUpperBound() < 0) {
                    refSort = this.ctx.mkSeqSort(refSort);
                }
                funDecl = this.ctx.mkFuncDecl(funId, (Sort)this.eClass2z3Sort.get(ec), refSort);
                this.eReference2FunDecl.put(er, ec, funDecl);
            }
            this.translatePreComputedFunctions(ec);
        }
    }

    private void translatePreComputedFunctions(EClass ec) {
        EnumSort<?> domain = this.translation.getDatatype(ec);
        Iterator iterator = this.translation.eClass2PreComputedFunctions.get(ec).iterator();
        while (iterator.hasNext()) {
            IPreComputedFunction f = (IPreComputedFunction)iterator.next();
            Sort range = null;
            if (f instanceof ComplexPreComputedFunctionBase) {
                EClass outputClass = ((ComplexPreComputedFunctionBase)f).getOutputType();
                range = (Sort)this.eClass2z3Sort.get(outputClass);
            } else if (f instanceof PrimitivePreComputedFunctionBase) {
                EDataType outputType = ((PrimitivePreComputedFunctionBase)f).getOutputType();
                range = this.eDataType2Sort.get(outputType);
            }
            if (range == null) continue;
            FuncDecl decl = this.ctx.mkFuncDecl(f.getIdentifier(), domain, range);
            this.preComputedFunction2FunDecl.put(f, ec, decl);
        }
    }

    private Sort translateEnum(EEnum en) {
        String name = en.getName();
        EList enumLiterals = en.getELiterals();
        int numLiterals = enumLiterals.size();
        String[] literals = new String[numLiterals + 1];
        int i = 0;
        while (i < numLiterals) {
            literals[i] = name + "_" + ((EEnumLiteral)enumLiterals.get(i)).getName();
            ++i;
        }
        literals[numLiterals] = name + "_NONE_LITERAL";
        EnumSort enumSort = this.ctx.mkEnumSort(name, literals);
        int i2 = 0;
        while (i2 < numLiterals) {
            this.eLiteral2Expr.put((Enum)((EEnumLiteral)enumLiterals.get(i2)).getInstance(), enumSort.getConst(i2));
            ++i2;
        }
        this.eEnum2NullElement.put(en, enumSort.getConst(numLiterals));
        return enumSort;
    }
}

