/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.variability.analysis;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.EnumSort;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.SeqExpr;
import com.microsoft.z3.SeqSort;
import com.microsoft.z3.Solver;
import com.microsoft.z3.Sort;
import com.microsoft.z3.StringSymbol;
import com.microsoft.z3.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.variability.analysis.BucketSetMap;
import org.fortiss.variability.analysis.DualKeyMap;
import org.fortiss.variability.analysis.EMFProductLineMetaModelTranslation;
import org.fortiss.variability.analysis.IProductLineTranslation;
import org.fortiss.variability.analysis.constraint.ComplexPreComputedFunctionBase;
import org.fortiss.variability.analysis.constraint.IPreComputedFunction;
import org.fortiss.variability.analysis.constraint.IProductLineConstraint;
import org.fortiss.variability.analysis.constraint.IQuantifier;
import org.fortiss.variability.analysis.constraint.PrimitivePreComputedFunctionBase;
import org.fortiss.variability.model.IAlternative;
import org.fortiss.variability.model.IOptionalVariationPoint;
import org.fortiss.variability.model.VariabilityModelElementFactory;
import org.fortiss.variability.model.features.AbstractAlternativeFeature;
import org.fortiss.variability.model.features.AbstractCompositionalFeature;
import org.fortiss.variability.model.features.AbstractCrossFeatureConstraint;
import org.fortiss.variability.model.features.AbstractFeature;
import org.fortiss.variability.model.features.AbstractFeatureModel;
import org.fortiss.variability.model.presence.AndPC;
import org.fortiss.variability.model.presence.DefaultPC;
import org.fortiss.variability.model.presence.ILiteralReferencable;
import org.fortiss.variability.model.presence.LiteralPC;
import org.fortiss.variability.model.presence.NotPC;
import org.fortiss.variability.model.presence.OrPC;
import org.fortiss.variability.model.presence.PresenceCondition;
import org.fortiss.variability.model.presence.PresenceConditionTerm;
import org.fortiss.variability.model.presence.TruePC;
import org.fortiss.variability.util.VariabilityUtilsInternal;

public class EMFProductLineModelTranslation
implements IProductLineTranslation {
    static final String LOG_PREFIX = "[EMF product-line translation]: ";
    private boolean isIslandOptimizationEnabled = false;
    private int islandOptimizationStepNum = 0;
    Set<EClass> translatedClasses = new LinkedHashSet<EClass>();
    Set<EReference> translatedReferences = new LinkedHashSet<EReference>();
    Set<EAttribute> translatedAttributes = new LinkedHashSet<EAttribute>();
    BucketSetMap<EClass, IPreComputedFunction<EObject, ?>> eClass2PreComputedFunctions = new BucketSetMap();
    private Context ctx;
    private List<BoolExpr> modelAssertions;
    private List<BoolExpr> featureModelAssertions;
    private List<BoolExpr> presenceConditionAssertions;
    private List<BoolExpr> constraintAssertions;
    private EMFProductLineMetaModelTranslation metamodel;
    protected BucketSetMap<EClass, EObject> class2TranslatedEObjects;
    private DualKeyMap<EObject, EClass, Expr<?>> eObject2z3Expr;
    private Map<Expr<?>, EObject> z3Expr2EObject;
    private Map<EObject, BucketSetMap<EReference, EObject>> eObject2referencingEObjects;
    private AbstractFeatureModel featureModel;
    private Map<AbstractFeature, BoolExpr> feature2BoolExpr;
    protected Map<EObject, PresenceConditionTerm> object2presenceCondition;
    private Map<EClass, FuncDecl<?>> eClass2SelectionFunction;

    public EMFProductLineModelTranslation() {
        this.initialize();
    }

    private void initialize() {
        this.ctx = new Context();
        this.metamodel = new EMFProductLineMetaModelTranslation(this);
        this.class2TranslatedEObjects = new BucketSetMap();
        this.object2presenceCondition = new HashMap<EObject, PresenceConditionTerm>();
        this.modelAssertions = new ArrayList<BoolExpr>();
        this.featureModelAssertions = new ArrayList<BoolExpr>();
        this.presenceConditionAssertions = new ArrayList<BoolExpr>();
        this.constraintAssertions = new ArrayList<BoolExpr>();
        this.eClass2SelectionFunction = new HashMap();
        this.feature2BoolExpr = new HashMap<AbstractFeature, BoolExpr>();
        this.eObject2z3Expr = new DualKeyMap();
        this.z3Expr2EObject = new HashMap();
        this.eObject2referencingEObjects = new HashMap<EObject, BucketSetMap<EReference, EObject>>(){
            private static final long serialVersionUID = -4436109358184535028L;

            @Override
            public BucketSetMap<EReference, EObject> get(Object key1) {
                BucketSetMap retMap = (BucketSetMap)super.get(key1);
                if (retMap == null) {
                    retMap = new BucketSetMap();
                    super.put((EObject)key1, retMap);
                }
                return retMap;
            }
        };
    }

    @Override
    public void translateModel(EObject model) {
        this.initialize();
        this.collectReferenceTypes();
        this.featureModel = this.preSelectFeatureModel(model);
        this.collectTranslatedObjects(model, this.computeParentPresenceCondition(model));
        if (this.isIslandOptimizationEnabled) {
            this.collectReferencedIslandObjects();
        }
        this.translateObjectSorts();
        this.metamodel.translateAttributesAndReferencesMetamodel();
        this.translateObjects();
        this.translateFeatureModel();
        this.translatePresenceConditions();
        this.addParentVariability(model);
    }

    private void addParentVariability(EObject model) {
        PresenceConditionTerm parentPC = this.computeParentPresenceCondition(model);
        if (parentPC != null) {
            BoolExpr z3PC = this.translatePresenceCondition(parentPC);
            this.presenceConditionAssertions.add(z3PC);
        }
    }

    private void collectReferenceTypes() {
        for (EClass cls : this.translatedClasses) {
            for (EReference ref : cls.getEAllReferences()) {
                if (!this.translatedReferences.contains(ref)) continue;
                EClass refType = ref.getEReferenceType();
                if (this.metamodel.reference2TranslatedEClass.get(ref, cls) != null) continue;
                EClass translatedRefType = this.getTranslatedClass(refType);
                if (translatedRefType != null) {
                    this.metamodel.reference2TranslatedEClass.put(ref, cls, translatedRefType);
                    continue;
                }
                for (EClass ecls : this.translatedClasses) {
                    if (!refType.isSuperTypeOf(ecls)) continue;
                    this.metamodel.reference2TranslatedEClass.put(ref, cls, ecls);
                }
                if (this.metamodel.reference2TranslatedEClass.get(ref, cls) != null) continue;
                String errMsg = "[EMF product-line translation]: ERefernce \"" + ref.getName() + "\" is of type " + ref.getEReferenceType().getName() + " which is not translated.";
                VariabilityUtilsInternal.logError(errMsg);
                throw new RuntimeException(errMsg);
            }
        }
    }

    protected AbstractFeatureModel preSelectFeatureModel(EObject obj) {
        return null;
    }

    private void collectTranslatedObjects(EObject model, PresenceConditionTerm parentCondition) {
        if (model instanceof AbstractFeatureModel && this.featureModel == null) {
            this.featureModel = (AbstractFeatureModel)model;
            return;
        }
        EClass modelClass = model.eClass();
        PresenceConditionTerm pc = this.getLocalPresenceCondition(model);
        if (pc == null) {
            pc = (PresenceConditionTerm)EcoreUtil.copy((EObject)parentCondition);
        } else if (parentCondition != null) {
            pc = VariabilityModelElementFactory.createAndPC((PresenceConditionTerm)EcoreUtil.copy((EObject)pc), (PresenceConditionTerm)EcoreUtil.copy((EObject)parentCondition), "");
        }
        EClass translatedClass = this.getTranslatedClass(modelClass);
        if (translatedClass != null) {
            if (this.isIslandOptimizationEnabled) {
                if (pc != null) {
                    this.collectEObject(model, translatedClass, pc);
                }
            } else {
                this.collectEObject(model, translatedClass, pc);
            }
        }
        if (this.isIslandOptimizationEnabled) {
            this.collectIncomingReferences(model);
        }
        for (EObject child : model.eContents()) {
            this.collectTranslatedObjects(child, pc);
        }
    }

    protected void collectEObject(EObject eo, EClass cls, PresenceConditionTerm pc) {
        this.class2TranslatedEObjects.add(cls, eo);
        this.object2presenceCondition.put(eo, pc);
    }

    private void collectIncomingReferences(EObject refSource) {
        for (EReference ref : refSource.eClass().getEAllReferences()) {
            if (!this.translatedReferences.contains(ref)) continue;
            ArrayList<EObject> allTargets = new ArrayList<EObject>();
            Object target = refSource.eGet((EStructuralFeature)ref);
            if (target instanceof List) {
                allTargets.addAll((List)target);
            } else {
                allTargets.add((EObject)target);
            }
            for (EObject refTarget : allTargets) {
                BucketSetMap<EReference, EObject> referencingObj = this.eObject2referencingEObjects.get(refTarget);
                referencingObj.add(ref, refSource);
            }
        }
    }

    private void collectReferencedIslandObjects() {
        for (EClass trgEcls : this.translatedClasses) {
            LinkedHashSet trgObjs = new LinkedHashSet();
            trgObjs.addAll(this.class2TranslatedEObjects.get(trgEcls));
            for (EObject trgObj : trgObjs) {
                this.collectTranslatedReferences(trgObj, this.islandOptimizationStepNum);
            }
        }
    }

    private void collectTranslatedReferences(EObject model, int remainingSteps) {
        if (remainingSteps <= 0) {
            return;
        }
        EClass modelClass = model.eClass();
        for (EReference ref : modelClass.getEAllReferences()) {
            if (!this.translatedReferences.contains(ref)) continue;
            ArrayList<EObject> refValues = new ArrayList<EObject>();
            Object refObj = model.eGet((EStructuralFeature)ref);
            if (refObj instanceof Collection) {
                refValues.addAll((Collection)refObj);
            } else {
                refValues.add((EObject)refObj);
            }
            for (EObject refEObj : refValues) {
                EClass refClass = this.metamodel.reference2TranslatedEClass.get(ref, modelClass);
                this.class2TranslatedEObjects.add(refClass, refEObj);
                this.collectTranslatedReferences(refEObj, remainingSteps - 1);
            }
        }
        BucketSetMap<EReference, EObject> incomingReferences = this.eObject2referencingEObjects.get(model);
        for (EReference ref : incomingReferences.keySet()) {
            Iterator iterator = incomingReferences.get(ref).iterator();
            while (iterator.hasNext()) {
                EObject srcObj = (EObject)iterator.next();
                EClass srcObjTransClass = this.getTranslatedClass(srcObj.eClass());
                if (srcObjTransClass == null) continue;
                this.class2TranslatedEObjects.add(srcObjTransClass, srcObj);
                this.collectTranslatedReferences(srcObj, remainingSteps - 1);
            }
        }
    }

    private void translatePresenceConditions() {
        for (EClass ec : this.translatedClasses) {
            EnumSort<?> ecSort = this.metamodel.eClass2z3Sort.get(ec);
            FuncDecl selFun = this.ctx.mkFuncDecl("SELECTED_" + ec.getName(), ecSort, (Sort)this.metamodel.boolSort);
            this.eClass2SelectionFunction.put(ec, selFun);
            Iterator iterator = this.class2TranslatedEObjects.get(ec).iterator();
            while (iterator.hasNext()) {
                EObject eo = (EObject)iterator.next();
                PresenceConditionTerm globalPC = this.object2presenceCondition.get(eo);
                BoolExpr eoSelection = globalPC != null ? this.translatePresenceCondition(globalPC) : this.ctx.mkTrue();
                Expr<?> eoExpr = this.eObject2z3Expr.get(eo, ec);
                this.presenceConditionAssertions.add(this.ctx.mkEq(this.ctx.mkApp(selFun, new Expr[]{eoExpr}), (Expr)eoSelection));
            }
        }
    }

    private BoolExpr translatePresenceCondition(PresenceCondition pc) {
        if (pc == null) {
            return null;
        }
        if (pc instanceof LiteralPC) {
            ILiteralReferencable literal = ((LiteralPC)pc).getLiteralReference();
            if (literal == null || literal.getName() == null || literal.getName().length() == 0) {
                return this.ctx.mkTrue();
            }
            return this.feature2BoolExpr.get(literal);
        }
        if (pc instanceof DefaultPC) {
            return this.translatePresenceCondition(pc.resolveToFeatureLiterals());
        }
        if (pc instanceof OrPC) {
            PresenceConditionTerm op1 = ((OrPC)pc).getOperand1();
            PresenceConditionTerm op2 = ((OrPC)pc).getOperand2();
            return this.ctx.mkOr(new Expr[]{this.translatePresenceCondition(op1), this.translatePresenceCondition(op2)});
        }
        if (pc instanceof AndPC) {
            PresenceConditionTerm op1 = ((AndPC)pc).getOperand1();
            PresenceConditionTerm op2 = ((AndPC)pc).getOperand2();
            return this.ctx.mkAnd(new Expr[]{this.translatePresenceCondition(op1), this.translatePresenceCondition(op2)});
        }
        if (pc instanceof NotPC) {
            return this.ctx.mkNot((Expr)this.translatePresenceCondition(((NotPC)pc).getOperand()));
        }
        if (pc instanceof TruePC) {
            return this.ctx.mkTrue();
        }
        VariabilityUtilsInternal.logError("[EMF product-line translation]: Unknown PresenceCondition: " + String.valueOf(pc));
        return null;
    }

    private void translateFeatureModel() {
        if (this.featureModel == null) {
            return;
        }
        BoolExpr fmExpr = this.ctx.mkBoolConst("FEATURE_" + this.featureModel.getName());
        this.feature2BoolExpr.put(this.featureModel, fmExpr);
        this.featureModelAssertions.add(fmExpr);
        for (AbstractFeature f : VariabilityUtilsInternal.getChildrenWithType(this.featureModel, AbstractFeature.class)) {
            String name = f.getName();
            String constName = "FEATURE_" + name;
            BoolExpr fExpr = this.ctx.mkBoolConst(constName.replaceAll("@", "AT"));
            this.feature2BoolExpr.put(f, fExpr);
            EObject fContainer = f.eContainer();
            if (!(fContainer instanceof AbstractFeature)) continue;
            AbstractFeature parentF = (AbstractFeature)fContainer;
            BoolExpr parentExpr = this.feature2BoolExpr.get(parentF);
            if (f.isOptional()) {
                this.featureModelAssertions.add(this.ctx.mkImplies((Expr)fExpr, (Expr)parentExpr));
                continue;
            }
            if (!(fContainer instanceof AbstractCompositionalFeature)) continue;
            this.featureModelAssertions.add(this.ctx.mkImplies((Expr)parentExpr, (Expr)fExpr));
        }
        for (AbstractAlternativeFeature af : VariabilityUtilsInternal.getChildrenWithType(this.featureModel, AbstractAlternativeFeature.class)) {
            BoolExpr afExpr = this.feature2BoolExpr.get(af);
            EList<AbstractFeature> as = af.getAlternatives();
            this.featureModelAssertions.add(this.ctx.mkImplies((Expr)afExpr, (Expr)this.ctx.mkOr((Expr[])as.stream().map(alt -> this.feature2BoolExpr.get(alt)).collect(Collectors.toList()).toArray(new BoolExpr[0]))));
            for (AbstractFeature a : as) {
                BoolExpr aExpr = this.feature2BoolExpr.get(a);
                this.featureModelAssertions.add(this.ctx.mkImplies((Expr)aExpr, (Expr)afExpr));
                this.featureModelAssertions.add(this.ctx.mkImplies((Expr)aExpr, (Expr)this.ctx.mkAnd((Expr[])as.stream().filter(alt -> alt != a).map(alt -> this.ctx.mkNot((Expr)this.feature2BoolExpr.get(alt))).collect(Collectors.toList()).toArray(new BoolExpr[0]))));
            }
        }
        for (AbstractCrossFeatureConstraint c : VariabilityUtilsInternal.getChildrenWithType(this.featureModel, AbstractCrossFeatureConstraint.class)) {
            AbstractFeature target = c.getTarget();
            AbstractFeature source = (AbstractFeature)c.eContainer();
            BoolExpr srcExpr = this.feature2BoolExpr.get(source);
            BoolExpr trgExpr = this.feature2BoolExpr.get(target);
            switch (c.getType()) {
                case REQUIRES: {
                    this.featureModelAssertions.add(this.ctx.mkImplies((Expr)srcExpr, (Expr)trgExpr));
                    break;
                }
                case EXCLUDES: {
                    this.featureModelAssertions.add(this.ctx.mkImplies((Expr)srcExpr, (Expr)this.ctx.mkNot((Expr)trgExpr)));
                }
            }
        }
    }

    private void translateObjects() {
        for (EClass ec : this.translatedClasses) {
            Iterator attVal;
            Object objs = this.class2TranslatedEObjects.get(ec);
            EList attributes = ec.getEAllAttributes();
            for (EAttribute ea : attributes) {
                if (!this.translatedAttributes.contains(ea)) continue;
                FuncDecl<?> attFunc = this.metamodel.eAttribute2FunDecl.get(ea, ec);
                Iterator iterator = objs.iterator();
                while (iterator.hasNext()) {
                    EObject eo = (EObject)iterator.next();
                    attVal = this.translateAttributeValue(eo, ea);
                    BoolExpr attValAssertion = this.ctx.mkEq(this.ctx.mkApp(attFunc, new Expr[]{this.eObject2z3Expr.get(eo, ec)}), attVal);
                    this.modelAssertions.add(attValAssertion);
                }
            }
            EList references = ec.getEAllReferences();
            for (EReference er : references) {
                if (!this.translatedReferences.contains(er)) continue;
                FuncDecl<?> refFunc = this.metamodel.eReference2FunDecl.get(er, ec);
                attVal = objs.iterator();
                while (attVal.hasNext()) {
                    EObject eo = (EObject)attVal.next();
                    Expr<?> eoExpr = this.eObject2z3Expr.get(eo, ec);
                    Expr<?> refVal = this.translateReferenceValue(eo, er);
                    BoolExpr rafValAssertion = this.ctx.mkEq(this.ctx.mkApp(refFunc, new Expr[]{eoExpr}), refVal);
                    this.modelAssertions.add(rafValAssertion);
                }
                EClass refType = this.metamodel.reference2TranslatedEClass.get(er, ec);
                Expr<?> nullElement = this.metamodel.eClass2NullElement.get(ec);
                if (er.getUpperBound() > 0) {
                    this.modelAssertions.add(this.ctx.mkEq(this.ctx.mkApp(refFunc, new Expr[]{nullElement}), this.metamodel.eClass2NullElement.get(refType)));
                    continue;
                }
                this.modelAssertions.add(this.ctx.mkEq(this.ctx.mkApp(refFunc, new Expr[]{nullElement}), (Expr)this.ctx.mkEmptySeq((Sort)this.ctx.mkSeqSort(this.getSortForReference(er, ec)))));
            }
            Iterator iterator = this.eClass2PreComputedFunctions.get(ec).iterator();
            while (iterator.hasNext()) {
                IPreComputedFunction f = (IPreComputedFunction)iterator.next();
                FuncDecl<?> funcDecl = this.metamodel.preComputedFunction2FunDecl.get(f, ec);
                Iterator iterator2 = objs.iterator();
                while (iterator2.hasNext()) {
                    EObject obj = (EObject)iterator2.next();
                    Expr<?> objExpr = this.eObject2z3Expr.get(obj, ec);
                    Expr<?> resultExpr = null;
                    if (f instanceof ComplexPreComputedFunctionBase) {
                        ComplexPreComputedFunctionBase compexFunction = (ComplexPreComputedFunctionBase)f;
                        outputType = compexFunction.getOutputType();
                        result = (EObject)compexFunction.apply(obj);
                        resultExpr = this.eObject2z3Expr.get((EObject)result, outputType);
                    } else if (f instanceof PrimitivePreComputedFunctionBase) {
                        PrimitivePreComputedFunctionBase primitiveFunction = (PrimitivePreComputedFunctionBase)f;
                        outputType = primitiveFunction.getOutputType();
                        result = primitiveFunction.apply(obj);
                        resultExpr = this.translatePrimitiveObject(result, (EDataType)outputType);
                    }
                    if (resultExpr == null) continue;
                    this.modelAssertions.add(this.ctx.mkEq(this.ctx.mkApp(funcDecl, new Expr[]{objExpr}), resultExpr));
                }
            }
        }
    }

    private <R extends Sort> Expr<?> translateReferenceValue(EObject eo, EReference er) {
        Object value = eo.eGet((EStructuralFeature)er);
        EClass eoTranslatedClass = this.getTranslatedClass(eo.eClass());
        EClass refType = this.metamodel.reference2TranslatedEClass.get(er, eoTranslatedClass);
        Expr<?> refNullValue = this.metamodel.eClass2NullElement.get(refType);
        FuncDecl<?> refSelFun = this.eClass2SelectionFunction.get(refType);
        if (er.getUpperBound() < 0) {
            List values = (List)value;
            EnumSort<?> sortForReference = this.getSortForReference(er, eoTranslatedClass);
            SeqSort seqSortForReference = this.ctx.mkSeqSort(sortForReference);
            if (values.size() == 0) {
                return this.ctx.mkEmptySeq((Sort)seqSortForReference);
            }
            ArrayList<SeqExpr> seqElems = new ArrayList<SeqExpr>();
            int i = 0;
            while (i < values.size()) {
                Object o = values.get(i);
                Expr<?> elemExpr = this.eObject2z3Expr.get((EObject)o, refType);
                if (elemExpr != null) {
                    SeqExpr selectedExpr = this.ctx.mkUnit(elemExpr);
                    if (refSelFun != null) {
                        SeqExpr notSelectedExpr = this.ctx.mkEmptySeq((Sort)seqSortForReference);
                        seqElems.add((SeqExpr)this.ctx.mkITE((Expr)((BoolExpr)this.ctx.mkApp(refSelFun, new Expr[]{elemExpr})), (Expr)selectedExpr, (Expr)notSelectedExpr));
                    } else {
                        seqElems.add(selectedExpr);
                    }
                }
                ++i;
            }
            if (seqElems.size() == 0) {
                return this.ctx.mkEmptySeq((Sort)seqSortForReference);
            }
            if (seqElems.size() == 1) {
                return (Expr)seqElems.get(0);
            }
            return this.ctx.mkConcat((Expr[])seqElems.toArray(new SeqExpr[0]));
        }
        if (value == null) {
            return refNullValue;
        }
        Expr<?> singleValExpr = this.eObject2z3Expr.get((EObject)value, refType);
        if (refSelFun != null) {
            BoolExpr eoSel = (BoolExpr)this.ctx.mkApp(refSelFun, new Expr[]{singleValExpr});
            return this.ctx.mkITE((Expr)eoSel, singleValExpr, refNullValue);
        }
        if (this.isIslandOptimizationEnabled && singleValExpr == null) {
            return this.getNullElement(refType);
        }
        return singleValExpr;
    }

    private Expr<?> translateAttributeValue(EObject eo, EAttribute ea) {
        Object value = eo.eGet((EStructuralFeature)ea);
        EDataType attType = ea.getEAttributeType();
        if (ea.getUpperBound() < 0 && value instanceof List) {
            List values = (List)value;
            SeqExpr[] seqElem = new SeqExpr[values.size()];
            int i = 0;
            while (i < values.size()) {
                Object o = values.get(i);
                Expr<?> elemExpr = this.translatePrimitiveObject(o, attType);
                seqElem[i] = this.ctx.mkUnit(elemExpr);
                ++i;
            }
            return this.ctx.mkConcat((Expr[])seqElem);
        }
        return this.translatePrimitiveObject(value, attType);
    }

    private Expr<?> translatePrimitiveObject(Object value, EDataType attType) {
        if (attType.equals(EcorePackage.Literals.EINT)) {
            if (value == null) {
                VariabilityUtilsInternal.logError("[EMF product-line translation]: null int found");
                return this.ctx.mkInt(0);
            }
            return this.ctx.mkInt(((Integer)value).intValue());
        }
        if (attType.equals(EcorePackage.Literals.ESTRING)) {
            if (value == null) {
                return this.ctx.mkString("");
            }
            return this.ctx.mkString((String)value);
        }
        if (attType.equals(EcorePackage.Literals.EBOOLEAN)) {
            if (value == null) {
                VariabilityUtilsInternal.logError("[EMF product-line translation]: null bool found");
                return this.ctx.mkBool(false);
            }
            return this.ctx.mkBool(((Boolean)value).booleanValue());
        }
        if (attType instanceof EEnum) {
            if (value == null) {
                return this.metamodel.eEnum2NullElement.get(attType);
            }
            return this.metamodel.eLiteral2Expr.get(value);
        }
        return null;
    }

    private void translateObjectSorts() {
        for (EClass cls : this.translatedClasses) {
            ArrayList objs = new ArrayList(this.class2TranslatedEObjects.get(cls));
            Symbol[] objSymbols = new Symbol[objs.size() + 1];
            String clsName = cls.getName();
            int i = 0;
            while (i < objs.size()) {
                String id = clsName + i;
                StringSymbol objSymbol = this.ctx.mkSymbol(id);
                objSymbols[i] = objSymbol;
                ++i;
            }
            objSymbols[objs.size()] = this.ctx.mkSymbol(clsName + "NONE");
            EnumSort enumSort = this.ctx.mkEnumSort((Symbol)this.ctx.mkSymbol(clsName), objSymbols);
            this.metamodel.eClass2z3Sort.put(cls, enumSort);
            Expr[] consts = enumSort.getConsts();
            int i2 = 0;
            while (i2 < objs.size()) {
                this.eObject2z3Expr.put((EObject)objs.get(i2), cls, consts[i2]);
                this.z3Expr2EObject.put(consts[i2], (EObject)objs.get(i2));
                ++i2;
            }
            Expr noneExpr = consts[consts.length - 1];
            this.metamodel.eClass2NullElement.put(cls, noneExpr);
        }
    }

    @Override
    public Solver createSolver() {
        Solver solver = this.ctx.mkSolver();
        solver.add((Expr[])this.featureModelAssertions.toArray(new BoolExpr[this.featureModelAssertions.size()]));
        solver.add((Expr[])this.presenceConditionAssertions.toArray(new BoolExpr[this.presenceConditionAssertions.size()]));
        solver.add((Expr[])this.modelAssertions.toArray(new BoolExpr[this.modelAssertions.size()]));
        solver.add((Expr[])this.constraintAssertions.toArray(new BoolExpr[this.constraintAssertions.size()]));
        return solver;
    }

    @Override
    public Context getContext() {
        return this.ctx;
    }

    @Override
    public EObject getEObjectForExpression(Expr<?> expr) {
        return this.z3Expr2EObject.get(expr);
    }

    @Override
    public Expr<?> getNullElement(EClass cls) {
        return this.metamodel.eClass2NullElement.get(cls);
    }

    @Override
    public EnumSort<?> getDatatype(EClass ec) {
        return this.metamodel.eClass2z3Sort.get(ec);
    }

    @Override
    public FuncDecl<?> getAttributeReferenceFunctionDeclaration(EClass cVarType, String name) {
        for (EReference ref : cVarType.getEAllReferences()) {
            if (!ref.getName().equals(name)) continue;
            return this.metamodel.eReference2FunDecl.get(ref, cVarType);
        }
        for (EAttribute att : cVarType.getEAllAttributes()) {
            if (!att.getName().equals(name)) continue;
            return this.metamodel.eAttribute2FunDecl.get(att, cVarType);
        }
        Iterator iterator = this.eClass2PreComputedFunctions.get(cVarType).iterator();
        while (iterator.hasNext()) {
            IPreComputedFunction f = (IPreComputedFunction)iterator.next();
            if (!f.getIdentifier().equals(name)) continue;
            return this.metamodel.preComputedFunction2FunDecl.get(f, cVarType);
        }
        return null;
    }

    @Override
    public Map<BoolExpr, IProductLineConstraint> translateConstraints(Collection<IProductLineConstraint> constraints) {
        HashMap<BoolExpr, IProductLineConstraint> constraintTracker2Constraint = new HashMap<BoolExpr, IProductLineConstraint>();
        for (IProductLineConstraint constraint : constraints) {
            BoolExpr quantifier = this.translateQuantifier(constraint);
            BoolExpr constraintTracker = this.ctx.mkBoolConst("CONSTRAINT_" + constraint.getConstraintName());
            constraintTracker2Constraint.put(constraintTracker, constraint);
            this.constraintAssertions.add(this.ctx.mkEq((Expr)constraintTracker, (Expr)quantifier));
        }
        Set allConstraints = constraintTracker2Constraint.keySet();
        this.constraintAssertions.add(this.ctx.mkOr((Expr[])allConstraints.toArray(new BoolExpr[0])));
        return constraintTracker2Constraint;
    }

    @Override
    public BoolExpr translateQuantifier(IQuantifier quantifier) {
        Expr<?>[] quantifierValiables = quantifier.translateQuantifierVariables();
        EClass[] variableClasses = Stream.of(quantifier.getQuantifierVariables()).map(v -> v.getEClass()).collect(Collectors.toList()).toArray(new EClass[0]);
        BoolExpr[] containmentExprs = quantifier.getContainmentExpr();
        BoolExpr body = quantifier.getBody();
        boolean isForAll = quantifier.isForAll();
        BoolExpr ret = this.createLiftedQuantifier(quantifierValiables, variableClasses, containmentExprs, body, isForAll);
        return ret;
    }

    protected BoolExpr createLiftedQuantifier(Expr<?>[] quantifierValiables, EClass[] variableClasses, BoolExpr[] containmentExprs, BoolExpr body, boolean isForAll) {
        BoolExpr[] selExprs = new BoolExpr[quantifierValiables.length + containmentExprs.length];
        int i = 0;
        while (i < quantifierValiables.length) {
            EClass cls = variableClasses[i];
            Expr<?> var = quantifierValiables[i];
            FuncDecl<?> selFun = this.eClass2SelectionFunction.get(cls);
            BoolExpr selected = (BoolExpr)this.ctx.mkApp(selFun, new Expr[]{var});
            BoolExpr notNull = this.ctx.mkNot((Expr)this.ctx.mkEq(var, this.getNullElement(cls)));
            selExprs[i] = this.ctx.mkAnd(new Expr[]{selected, notNull});
            ++i;
        }
        int j = 0;
        int i2 = quantifierValiables.length;
        while (i2 < quantifierValiables.length + containmentExprs.length) {
            selExprs[i2] = containmentExprs[j++];
            ++i2;
        }
        if (isForAll) {
            BoolExpr liftedBody = this.ctx.mkImplies((Expr)this.ctx.mkAnd((Expr[])selExprs), (Expr)body);
            return this.ctx.mkForall(quantifierValiables, (Expr)liftedBody, 0, null, null, null, null);
        }
        BoolExpr liftedBody = this.ctx.mkAnd(new Expr[]{this.ctx.mkAnd((Expr[])selExprs), body});
        return this.ctx.mkExists(quantifierValiables, (Expr)liftedBody, 0, null, null, null, null);
    }

    private EnumSort<?> getSortForReference(EReference er, EClass ec) {
        return this.metamodel.eClass2z3Sort.get(this.metamodel.reference2TranslatedEClass.get(er, ec));
    }

    protected PresenceConditionTerm getLocalPresenceCondition(EObject model) {
        if (model instanceof IOptionalVariationPoint) {
            PresenceCondition presenceCondition = ((IOptionalVariationPoint)model).getPresenceCondition();
            if (presenceCondition == null) {
                return null;
            }
            return presenceCondition.resolveToFeatureLiterals();
        }
        if (model instanceof IAlternative) {
            return ((IAlternative)model).getPresenceCondition().resolveToFeatureLiterals();
        }
        return null;
    }

    protected PresenceConditionTerm computeParentPresenceCondition(EObject model) {
        EObject container = model.eContainer();
        ArrayList<PresenceConditionTerm> parentPCs = new ArrayList<PresenceConditionTerm>();
        while (container != null) {
            PresenceConditionTerm containerPC = this.getLocalPresenceCondition(container);
            if (containerPC != null) {
                parentPCs.add(containerPC);
            }
            container = container.eContainer();
        }
        if (parentPCs.size() == 0) {
            return null;
        }
        PresenceConditionTerm accumulator = (PresenceConditionTerm)parentPCs.get(0);
        int i = parentPCs.size() - 1;
        while (i > 0) {
            accumulator = VariabilityModelElementFactory.createAndPC(accumulator, (PresenceConditionTerm)parentPCs.get(i), "");
            --i;
        }
        return accumulator;
    }

    @Override
    public void setTranslatedEClasses(Collection<EClass> clss) {
        this.translatedClasses = new LinkedHashSet<EClass>();
        this.translatedClasses.addAll(clss);
    }

    @Override
    public void setTranslatedEReferences(Collection<EReference> refs) {
        this.translatedReferences = new LinkedHashSet<EReference>();
        this.translatedReferences.addAll(refs);
    }

    @Override
    public void setTranslatedEAttributes(Collection<EAttribute> atts) {
        this.translatedAttributes = new LinkedHashSet<EAttribute>();
        this.translatedAttributes.addAll(atts);
    }

    @Override
    public void setPreComputedFunctions(Collection<IPreComputedFunction<?, ?>> preComputedFunctions) {
        this.eClass2PreComputedFunctions.clear();
        for (IPreComputedFunction<?, ?> f : preComputedFunctions) {
            EClass inputClass = f.getInputClass();
            this.eClass2PreComputedFunctions.add(inputClass, f);
        }
    }

    public void setIslandOptimizationEnabled(boolean setEnabled) {
        this.isIslandOptimizationEnabled = setEnabled;
    }

    public void setIslandOptimizationStepNum(int stepNum) {
        this.islandOptimizationStepNum = stepNum;
    }

    protected EClass getTranslatedClass(EClass objClass) {
        if (this.translatedClasses.contains(objClass)) {
            return objClass;
        }
        for (EClass ecls : this.translatedClasses) {
            if (!ecls.isSuperTypeOf(objClass)) continue;
            return ecls;
        }
        return null;
    }

    @Override
    public void setTranslatedClassForEReferences(EReference reference, EClass sourceClass, EClass targetClass) {
        this.metamodel.reference2TranslatedEClass.put(reference, sourceClass, targetClass);
    }
}

