/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.variability.analysis;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Model;
import com.microsoft.z3.Solver;
import com.microsoft.z3.Status;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.fortiss.variability.analysis.IProductLineTranslation;
import org.fortiss.variability.analysis.constraint.IProductLineConstraint;
import org.fortiss.variability.analysis.constraint.ProductLineConstraintViolation;

public abstract class GenericProductLineAnalysis {
    protected final IProductLineTranslation translation;
    protected Collection<IProductLineConstraint> plConstraints;

    protected GenericProductLineAnalysis(IProductLineTranslation translation) {
        this.translation = translation;
    }

    protected abstract Collection<IProductLineConstraint> createConstraints();

    public List<ProductLineConstraintViolation> doCheck(EObject model) {
        this.plConstraints = this.createConstraints();
        this.setTranslatedMetamodelElements();
        this.translation.translateModel(model);
        Map<BoolExpr, IProductLineConstraint> constraintTracker2Constraint = this.translation.translateConstraints(this.plConstraints);
        Solver solver = this.translation.createSolver();
        Status result = solver.check();
        List<ProductLineConstraintViolation> ret = this.processSolverResults(constraintTracker2Constraint, solver, result, model);
        this.translation.getContext().close();
        return ret;
    }

    private List<ProductLineConstraintViolation> processSolverResults(Map<BoolExpr, IProductLineConstraint> constraintTracker2Constraint, Solver solver, Status overallResult, EObject model) {
        ArrayList<ProductLineConstraintViolation> ret = new ArrayList<ProductLineConstraintViolation>();
        if (overallResult.equals((Object)Status.SATISFIABLE)) {
            Model z3Model = solver.getModel();
            for (Expr expr : constraintTracker2Constraint.keySet()) {
                solver.push();
                solver.add(new Expr[]{expr});
                Status individualResult = solver.check();
                solver.pop();
                if (!individualResult.equals((Object)Status.SATISFIABLE)) continue;
                IProductLineConstraint failedConstraint = constraintTracker2Constraint.get(expr);
                ArrayList<EObject> violatingObjects = new ArrayList<EObject>();
                Expr<?>[] exprArray = failedConstraint.getVariableTrackers();
                int n = exprArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Expr<?> varTrack = exprArray[n2];
                    Expr interpr = z3Model.getConstInterp(varTrack);
                    EObject eObject = this.translation.getEObjectForExpression(interpr);
                    violatingObjects.add(eObject);
                    ++n2;
                }
                if (violatingObjects.isEmpty()) {
                    violatingObjects.add(model);
                }
                ret.add(new ProductLineConstraintViolation(failedConstraint, violatingObjects, null));
            }
        }
        return ret;
    }

    private void setTranslatedMetamodelElements() {
        LinkedHashSet<EClass> classes = new LinkedHashSet<EClass>();
        LinkedHashSet<EReference> references = new LinkedHashSet<EReference>();
        LinkedHashSet<EAttribute> attributes = new LinkedHashSet<EAttribute>();
        LinkedHashSet functions = new LinkedHashSet();
        for (IProductLineConstraint constraint : this.plConstraints) {
            classes.addAll(constraint.getTranslatedClasses());
            references.addAll(constraint.getTranslatedReferences());
            attributes.addAll(constraint.getTranslatedAttributes());
            functions.addAll(constraint.getPrecomputedFunctions());
            constraint.addReferenceTypeExceptions(this.translation);
        }
        this.translation.setTranslatedEClasses(classes);
        this.translation.setTranslatedEReferences(references);
        this.translation.setTranslatedEAttributes(attributes);
        this.translation.setPreComputedFunctions(functions);
    }
}

