/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.variability.analysis.constraint;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.EnumSort;
import com.microsoft.z3.Expr;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.fortiss.variability.analysis.IProductLineTranslation;
import org.fortiss.variability.analysis.constraint.IPreComputedFunction;
import org.fortiss.variability.analysis.constraint.IProductLineConstraint;
import org.fortiss.variability.analysis.constraint.QuantifierBase;
import org.fortiss.variability.analysis.constraint.QuantifierVariable;

public abstract class ProductLineConstraintBase
extends QuantifierBase
implements IProductLineConstraint {
    private static final String TRACK_PREFIX = "TRACK_";
    private Expr<?>[] trackerVars = this.areVariablesTracked() ? new Expr[this.getQuantifierVariables().length] : new Expr[0];

    public ProductLineConstraintBase(IProductLineTranslation translation) {
        super(translation);
    }

    @Override
    public boolean isForAll() {
        return false;
    }

    @Override
    public final Expr<?>[] getVariableTrackers() {
        return this.trackerVars;
    }

    @Override
    final void createVariables() {
        super.createVariables();
        if (this.areVariablesTracked()) {
            QuantifierVariable[] variables = this.getQuantifierVariables();
            int i = 0;
            while (i < variables.length) {
                QuantifierVariable var = variables[i];
                EClass ec = var.getEClass();
                EnumSort<?> ecSort = this.translation.getDatatype(ec);
                String varName = var.getName();
                this.trackerVars[i] = this.translation.getContext().mkConst(TRACK_PREFIX + varName, ecSort);
                ++i;
            }
        }
    }

    private final boolean areVariablesTracked() {
        return !this.isForAll();
    }

    @Override
    public final BoolExpr getBody() {
        BoolExpr body = super.getBody();
        if (this.areVariablesTracked()) {
            body = this.addTracking(body);
        }
        return body;
    }

    private final BoolExpr addTracking(BoolExpr body) {
        Expr<?>[] variables = this.getZ3Variables();
        int numVariables = variables.length;
        BoolExpr[] trackExprs = new BoolExpr[numVariables + 1];
        int i = 0;
        while (i < numVariables) {
            trackExprs[i] = this.translation.getContext().mkEq(this.trackerVars[i], variables[i]);
            ++i;
        }
        trackExprs[numVariables] = body;
        return this.translation.getContext().mkAnd((Expr[])trackExprs);
    }

    @Override
    public void addReferenceTypeExceptions(IProductLineTranslation translation) {
    }

    @Override
    public Collection<EAttribute> getTranslatedAttributes() {
        return Collections.emptyList();
    }

    @Override
    public Collection<IPreComputedFunction<?, ?>> getPrecomputedFunctions() {
        return Collections.emptyList();
    }
}

