/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.variability.analysis.constraint;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.EnumSort;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.SeqExpr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.fortiss.variability.analysis.IProductLineTranslation;
import org.fortiss.variability.analysis.constraint.ContainedQuantifierVariable;
import org.fortiss.variability.analysis.constraint.IQuantifier;
import org.fortiss.variability.analysis.constraint.QuantifierVariable;

public abstract class QuantifierBase
implements IQuantifier {
    private QuantifierVariable[] variables;
    private Expr<?>[] translatedVariables;
    private Map<String, Expr<?>> name2Variables = new HashMap();
    protected IProductLineTranslation translation;

    public QuantifierBase(IProductLineTranslation translation) {
        this.translation = translation;
        this.variables = this.getQuantifierVariables();
    }

    protected abstract BoolExpr createBody();

    @Override
    public final Expr<?>[] translateQuantifierVariables() {
        this.createVariables();
        return this.translatedVariables;
    }

    void createVariables() {
        int numVariables = this.variables.length;
        this.translatedVariables = new Expr[numVariables];
        this.name2Variables = new HashMap();
        int i = 0;
        while (i < numVariables) {
            Expr var;
            EClass ec = this.variables[i].getEClass();
            EnumSort<?> ecSort = this.translation.getDatatype(ec);
            String varName = this.variables[i].getName();
            this.translatedVariables[i] = var = this.translation.getContext().mkConst(varName, ecSort);
            this.name2Variables.put(varName, var);
            ++i;
        }
    }

    @Override
    public BoolExpr getBody() {
        return this.createBody();
    }

    protected final Expr<?> getZ3Variable(String name) {
        return this.name2Variables.get(name);
    }

    protected final Expr<?>[] getZ3Variables() {
        return this.translatedVariables;
    }

    @Override
    public final BoolExpr[] getContainmentExpr() {
        ArrayList<BoolExpr> ret = new ArrayList<BoolExpr>();
        int i = 0;
        while (i < this.variables.length) {
            QuantifierVariable var = this.variables[i];
            if (var instanceof ContainedQuantifierVariable) {
                ContainedQuantifierVariable containedVar = (ContainedQuantifierVariable)var;
                Expr<?> z3Var = this.getZ3Variable(containedVar.getName());
                Expr<?> z3VarParent = containedVar.getParentZ3Var();
                EClass varParentClass = containedVar.getParentClass();
                String containmentRefName = containedVar.getParentRefName();
                Context ctx = this.translation.getContext();
                FuncDecl<?> containmentRefFun = this.translation.getAttributeReferenceFunctionDeclaration(varParentClass, containmentRefName);
                SeqExpr containmentNavExpr = (SeqExpr)ctx.mkApp(containmentRefFun, new Expr[]{z3VarParent});
                ret.add(ctx.mkContains((Expr)containmentNavExpr, (Expr)ctx.mkUnit(z3Var)));
            }
            ++i;
        }
        return ret.toArray(new BoolExpr[ret.size()]);
    }
}

