/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.variability.bind;

import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.variability.model.IBindingStrategy;
import org.fortiss.variability.model.IVariationPoint;
import org.fortiss.variability.model.VariabilityModelElementFactory;
import org.fortiss.variability.model.features.AbstractAlternativeFeature;
import org.fortiss.variability.model.features.AbstractCompositionalFeature;
import org.fortiss.variability.model.features.AbstractCrossFeatureConstraint;
import org.fortiss.variability.model.features.AbstractFeature;
import org.fortiss.variability.model.features.configuration.AlternativeFeatureConfiguration;
import org.fortiss.variability.model.features.configuration.CompositionalFeatureConfiguration;
import org.fortiss.variability.model.features.configuration.IFeatureConfiguration;
import org.fortiss.variability.model.features.configuration.VariantConfiguration;
import org.fortiss.variability.util.Pair;

public class BindUtils {
    public static <T extends EObject> T configureEObject(T eObj, VariantConfiguration varConf, IBindingStrategy strategy) {
        EObject evaluatedObj;
        if (eObj instanceof IVariationPoint && (evaluatedObj = (EObject)((IVariationPoint)eObj).bind(varConf, strategy)) == null) {
            return null;
        }
        EList contents = eObj.eContents();
        int i = contents.size() - 1;
        while (i >= 0) {
            if (i < contents.size()) {
                BindUtils.configureEObject((EObject)contents.get(i), varConf, strategy);
            }
            --i;
        }
        return eObj;
    }

    protected static <T extends EObject> T configureEObject(T eObj, VariantConfiguration varConf) {
        return BindUtils.configureEObject(eObj, varConf, VariabilityModelElementFactory.getRemoveBindingStrategyInstance());
    }

    private static Pair<String, List<EObject>> checkVariantConfiguration(IFeatureConfiguration<?> conf, AbstractFeature feature, Set<AbstractFeature> selectedFeatures, Map<AbstractFeature, AbstractFeature> requiredFeatures, Map<AbstractFeature, AbstractFeature> excludedFeatures) {
        String msg;
        for (AbstractCrossFeatureConstraint cnstr : feature.getConstraints()) {
            AbstractFeature cnstrTarget = cnstr.getTarget();
            switch (cnstr.getType()) {
                case EXCLUDES: {
                    excludedFeatures.put(feature, cnstrTarget);
                    break;
                }
                case REQUIRES: {
                    requiredFeatures.put(feature, cnstrTarget);
                    break;
                }
                default: {
                    System.err.println("Unknown Constraint \"" + String.valueOf(cnstr.getClass()) + "\" found.");
                }
            }
        }
        if (feature instanceof AbstractCompositionalFeature) {
            AbstractCompositionalFeature compFeature = (AbstractCompositionalFeature)feature;
            if (!(conf instanceof CompositionalFeatureConfiguration)) {
                System.err.println("A feature configuration has an invalid configuration of type " + conf.getClass().getCanonicalName() + " for the compositional feature " + feature.getName());
                return null;
            }
            CompositionalFeatureConfiguration compConf = (CompositionalFeatureConfiguration)conf;
            Pair<String, List<EObject>> res = BindUtils.checkVariantConfigurationForCompositionalFeature(selectedFeatures, requiredFeatures, excludedFeatures, compFeature, compConf);
            if (res != null) {
                return res;
            }
        }
        if (feature instanceof AbstractAlternativeFeature) {
            AbstractAlternativeFeature altFeature = (AbstractAlternativeFeature)feature;
            if (!(conf instanceof AlternativeFeatureConfiguration)) {
                System.err.println("A feature configuration has an invalid configuration of type " + conf.getClass().getCanonicalName() + " for the alternative feature " + feature.getName());
                return null;
            }
            AlternativeFeatureConfiguration altConf = (AlternativeFeatureConfiguration)conf;
            IFeatureConfiguration altSelectedConf = altConf.getSelectedConfiguration();
            Pair<String, List<EObject>> res = BindUtils.checkVariantConfigurationForAlternativeFeature(selectedFeatures, requiredFeatures, excludedFeatures, altFeature, altSelectedConf);
            if (res != null) {
                return res;
            }
        }
        for (AbstractFeature source : requiredFeatures.keySet()) {
            AbstractFeature reqFeat = requiredFeatures.get(source);
            if (!selectedFeatures.contains(source) || selectedFeatures.contains(reqFeat)) continue;
            msg = "The selected feature \"" + source.getName() + "\" requires the feature \"" + reqFeat.getName() + "\" to be selected, too.";
            return new Pair<CallSite, List<EObject>>((CallSite)((Object)msg), Arrays.asList(reqFeat, source));
        }
        for (AbstractFeature source : excludedFeatures.keySet()) {
            AbstractFeature exclFeat = excludedFeatures.get(source);
            if (!selectedFeatures.contains(source) || !selectedFeatures.contains(exclFeat)) continue;
            msg = "The selected feature \"" + source.getName() + "\" excludes the feature \"" + exclFeat.getName() + "\" to be selected at the same time.";
            return new Pair<CallSite, List<EObject>>((CallSite)((Object)msg), Arrays.asList(exclFeat, source));
        }
        return null;
    }

    private static Pair<String, List<EObject>> checkVariantConfigurationForAlternativeFeature(Set<AbstractFeature> selectedFeatures, Map<AbstractFeature, AbstractFeature> requiredFeatures, Map<AbstractFeature, AbstractFeature> excludedFeatures, AbstractAlternativeFeature altFeature, IFeatureConfiguration<?> altSelectedConf) {
        if (!altFeature.isOptional() && altSelectedConf == null) {
            String msg = "The alternative feature \"" + altFeature.getName() + "\" is not optional, but has no alternative selected.";
            return new Pair<CallSite, List<AbstractAlternativeFeature>>((CallSite)((Object)msg), Collections.singletonList(altFeature));
        }
        if (altSelectedConf != null) {
            Object altSelectedFeature = altSelectedConf.getFeatureReference();
            selectedFeatures.add((AbstractFeature)altSelectedFeature);
            Pair<String, List<EObject>> altResult = BindUtils.checkVariantConfiguration(altSelectedConf, altSelectedFeature, selectedFeatures, requiredFeatures, excludedFeatures);
            if (altResult != null) {
                return altResult;
            }
        }
        return null;
    }

    private static Pair<String, List<EObject>> checkVariantConfigurationForCompositionalFeature(Set<AbstractFeature> selectedFeatures, Map<AbstractFeature, AbstractFeature> requiredFeatures, Map<AbstractFeature, AbstractFeature> excludedFeatures, AbstractCompositionalFeature compFeature, CompositionalFeatureConfiguration compConf) {
        HashMap feature2conf = new HashMap();
        compConf.getSubConfigurations().stream().forEach(c -> {
            IFeatureConfiguration iFeatureConfiguration = feature2conf.put(c.getFeatureReference(), c);
        });
        for (AbstractFeature f : compFeature.getSubFeatures()) {
            IFeatureConfiguration fConf = (IFeatureConfiguration)feature2conf.get(f);
            if (!(f.isOptional() || fConf != null && fConf.isSelected())) {
                String msg = "The feature \"" + f.getName() + "\" is mandatory but not selected.";
                if (f instanceof AbstractAlternativeFeature) {
                    msg = "The feature \"" + f.getName() + "\" is mandatory but no alternative has been selected.";
                }
                return new Pair<CallSite, List<AbstractFeature>>((CallSite)((Object)msg), Collections.singletonList(f));
            }
            if (fConf == null || !fConf.isSelected()) continue;
            selectedFeatures.add(f);
            Pair<String, List<EObject>> fResult = BindUtils.checkVariantConfiguration(fConf, f, selectedFeatures, requiredFeatures, excludedFeatures);
            if (fResult == null) continue;
            return fResult;
        }
        return null;
    }

    public static Pair<String, List<EObject>> checkVariantConfiguration(VariantConfiguration varConf) {
        HashSet<AbstractFeature> selected = new HashSet<AbstractFeature>();
        HashMap<AbstractFeature, AbstractFeature> required = new HashMap<AbstractFeature, AbstractFeature>();
        HashMap<AbstractFeature, AbstractFeature> excluded = new HashMap<AbstractFeature, AbstractFeature>();
        Pair<String, List<EObject>> result = BindUtils.checkVariantConfiguration(varConf, varConf.getFeatureModel(), selected, required, excluded);
        return result;
    }
}

