/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.variability.model;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.variability.model.base.BaseFactory;
import org.fortiss.variability.model.base.RemoveBindingStrategy;
import org.fortiss.variability.model.features.AbstractAlternativeFeature;
import org.fortiss.variability.model.features.AbstractCompositionalFeature;
import org.fortiss.variability.model.features.AbstractFeature;
import org.fortiss.variability.model.features.AbstractFeatureModel;
import org.fortiss.variability.model.features.configuration.AlternativeFeatureConfiguration;
import org.fortiss.variability.model.features.configuration.CompositionalFeatureConfiguration;
import org.fortiss.variability.model.features.configuration.ConfigurationFactory;
import org.fortiss.variability.model.features.configuration.IFeatureConfiguration;
import org.fortiss.variability.model.features.configuration.VariantConfiguration;
import org.fortiss.variability.model.presence.AndPC;
import org.fortiss.variability.model.presence.DefaultPC;
import org.fortiss.variability.model.presence.ILiteralReferencable;
import org.fortiss.variability.model.presence.LiteralPC;
import org.fortiss.variability.model.presence.NotPC;
import org.fortiss.variability.model.presence.OrPC;
import org.fortiss.variability.model.presence.PresenceConditionTerm;
import org.fortiss.variability.model.presence.PresenceFactory;
import org.fortiss.variability.util.VariabilityUtilsInternal;

public class VariabilityModelElementFactory {
    private static final RemoveBindingStrategy REMOVE_BINDING_STRATEGY_SINGLETON = BaseFactory.eINSTANCE.createRemoveBindingStrategy();

    public static OrPC createOrPC(PresenceConditionTerm operand1, PresenceConditionTerm operand2, String str) {
        OrPC or = PresenceFactory.eINSTANCE.createOrPC();
        or.setStringRepresentation(str);
        or.setOperand1(operand1);
        or.setOperand2(operand2);
        return or;
    }

    public static AndPC createAndPC(PresenceConditionTerm operand1, PresenceConditionTerm operand2, String str) {
        AndPC and = PresenceFactory.eINSTANCE.createAndPC();
        and.setStringRepresentation(str);
        and.setOperand1(operand1);
        and.setOperand2(operand2);
        return and;
    }

    public static NotPC createNotPC(PresenceConditionTerm operand, String str) {
        NotPC not = PresenceFactory.eINSTANCE.createNotPC();
        not.setStringRepresentation(str);
        not.setOperand(operand);
        return not;
    }

    public static LiteralPC createLiteralPC(String literalString, EObject context) {
        LiteralPC ret = PresenceFactory.eINSTANCE.createLiteralPC();
        ret.setStringRepresentation(literalString);
        List<ILiteralReferencable> literalRefs = VariabilityUtilsInternal.getAllElementsFromSameContainmentTree(context, ILiteralReferencable.class);
        for (ILiteralReferencable l : literalRefs) {
            if (!l.getName().equals(literalString)) continue;
            ret.setLiteralReference(l);
            break;
        }
        return ret;
    }

    public static LiteralPC createLiteralPC(ILiteralReferencable literalRef) {
        LiteralPC ret = PresenceFactory.eINSTANCE.createLiteralPC();
        ret.setLiteralReference(literalRef);
        ret.setStringRepresentation(literalRef.getName());
        return ret;
    }

    public static DefaultPC createDefaultPC() {
        DefaultPC def = PresenceFactory.eINSTANCE.createDefaultPC();
        def.setStringRepresentation("DEFAULT");
        return def;
    }

    public static VariantConfiguration createVariantConfiguration(AbstractFeatureModel featureModel) {
        VariantConfiguration varConfig = ConfigurationFactory.eINSTANCE.createVariantConfiguration();
        varConfig.setSelected(true);
        varConfig.setFeatureModel(featureModel);
        List subConfigs = featureModel.getSubFeatures().stream().map(f -> VariabilityModelElementFactory.createFeatureConfigurationForFeature(f)).collect(Collectors.toList());
        varConfig.getSubConfigurations().addAll(subConfigs);
        return varConfig;
    }

    public static IFeatureConfiguration<?> createFeatureConfigurationForFeature(AbstractFeature feature) {
        if (feature instanceof AbstractAlternativeFeature) {
            AlternativeFeatureConfiguration afc = ConfigurationFactory.eINSTANCE.createAlternativeFeatureConfiguration();
            afc.setFeatureReference((AbstractAlternativeFeature)feature);
            if (feature.isOptional()) {
                afc.setSelected(false);
            } else {
                afc.setSelected(true);
            }
            return afc;
        }
        if (feature instanceof AbstractCompositionalFeature) {
            CompositionalFeatureConfiguration cfc = ConfigurationFactory.eINSTANCE.createCompositionalFeatureConfiguration();
            cfc.setFeatureReference((AbstractCompositionalFeature)feature);
            if (feature.isOptional()) {
                cfc.setSelected(false);
            } else {
                cfc.setSelected(true);
                EList<IFeatureConfiguration<?>> subConfigurations = cfc.getSubConfigurations();
                AbstractCompositionalFeature acf = (AbstractCompositionalFeature)feature;
                for (AbstractFeature sf : acf.getSubFeatures()) {
                    subConfigurations.add(VariabilityModelElementFactory.createFeatureConfigurationForFeature(sf));
                }
            }
            return cfc;
        }
        return null;
    }

    public static RemoveBindingStrategy getRemoveBindingStrategyInstance() {
        return REMOVE_BINDING_STRATEGY_SINGLETON;
    }

    public static PresenceConditionTerm createTruePC() {
        return PresenceFactory.eINSTANCE.createTruePC();
    }
}

