/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.variability.model;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.variability.model.IAlternativeVariationPoint;
import org.fortiss.variability.model.IBindingStrategy;
import org.fortiss.variability.model.IOptionalVariationPoint;
import org.fortiss.variability.model.VariabilityModelElementFactory;
import org.fortiss.variability.model.base.RemoveBindingStrategy;
import org.fortiss.variability.model.features.AbstractAlternativeFeature;
import org.fortiss.variability.model.features.AbstractFeature;
import org.fortiss.variability.model.features.AbstractFeatureModel;
import org.fortiss.variability.model.features.configuration.AlternativeFeatureConfiguration;
import org.fortiss.variability.model.features.configuration.CompositionalFeatureConfiguration;
import org.fortiss.variability.model.features.configuration.IFeatureConfiguration;
import org.fortiss.variability.model.presence.AndPC;
import org.fortiss.variability.model.presence.DefaultPC;
import org.fortiss.variability.model.presence.ICompleteEvaluationContext;
import org.fortiss.variability.model.presence.IHasPresenceCondition;
import org.fortiss.variability.model.presence.ILiteralReferencable;
import org.fortiss.variability.model.presence.LiteralPC;
import org.fortiss.variability.model.presence.NotPC;
import org.fortiss.variability.model.presence.OrPC;
import org.fortiss.variability.model.presence.PresenceCondition;
import org.fortiss.variability.model.presence.PresenceConditionTerm;
import org.fortiss.variability.model.presence.TruePC;
import org.fortiss.variability.model.presence.impl.DefaultPCImpl;
import org.fortiss.variability.util.VariabilityUtilsInternal;

public class VariabilityStaticImpl {
    public static final String ALTERNATIVE_NOTHING_SELECTED_STRING = "<Select Alternative>";
    public static final String OPTIONAL_ALTERNATIVE_NOT_SELECTED_STRING = "None";

    public static <T> T bindOptionalVariationPoint(IOptionalVariationPoint<T> variationPoint, ICompleteEvaluationContext context, IBindingStrategy strategy) {
        PresenceCondition pc = variationPoint.getPresenceCondition();
        if (pc == null || pc.evaluate(context)) {
            return (T)variationPoint;
        }
        return strategy.deactivateOptionalVariationPoint(variationPoint);
    }

    public static PresenceConditionTerm translateFeatureConfigurationToPresenceCondition(IFeatureConfiguration<?> featureConfig) {
        Object feature = featureConfig.getFeatureReference();
        LiteralPC featurePCTerm = VariabilityModelElementFactory.createLiteralPC(feature);
        if (featureConfig.isSelected()) {
            if (featureConfig instanceof CompositionalFeatureConfiguration) {
                EList<IFeatureConfiguration<?>> allSubConfig = ((CompositionalFeatureConfiguration)featureConfig).getSubConfigurations();
                Stream<PresenceConditionTerm> allSubConfigTerms = allSubConfig.stream().map(sc -> sc.translateToPresenceCondition());
                return allSubConfigTerms.reduce(featurePCTerm, (a, b) -> VariabilityModelElementFactory.createAndPC(a, b, ""));
            }
            if (featureConfig instanceof AlternativeFeatureConfiguration) {
                IFeatureConfiguration selectedSubConfig = ((AlternativeFeatureConfiguration)featureConfig).getSelectedConfiguration();
                PresenceConditionTerm selectedSubConfigTerm = VariabilityStaticImpl.translateFeatureConfigurationToPresenceCondition(selectedSubConfig);
                if (feature instanceof AbstractAlternativeFeature) {
                    Object alternatives = ((AbstractAlternativeFeature)feature).getAlternatives();
                    alternatives = alternatives.stream().filter(f -> !f.equals(selectedSubConfig.getFeatureReference())).collect(Collectors.toList());
                    PresenceConditionTerm subTerms = alternatives.stream().map(a -> VariabilityStaticImpl.translateFeatureToDeselectedPresenceCondition(a)).reduce(selectedSubConfigTerm, (a, b) -> VariabilityModelElementFactory.createAndPC(a, b, ""));
                    return VariabilityModelElementFactory.createAndPC(featurePCTerm, subTerms, "");
                }
            }
            throw new RuntimeException("Invalid FeatureConfiguration found for feature \"" + feature.getName() + "\":\n" + String.valueOf(featureConfig));
        }
        return VariabilityStaticImpl.translateFeatureToDeselectedPresenceCondition(feature);
    }

    private static PresenceConditionTerm translateFeatureToDeselectedPresenceCondition(AbstractFeature feature) {
        NotPC notCurrent = VariabilityModelElementFactory.createNotPC(VariabilityModelElementFactory.createLiteralPC(feature), "");
        EList allSubFeatures = EcoreUtils.getChildrenWithType((EObject)feature, AbstractFeature.class);
        Stream<PresenceConditionTerm> allSubFeaturesNegatedTerms = allSubFeatures.stream().map(sf -> VariabilityModelElementFactory.createNotPC(VariabilityModelElementFactory.createLiteralPC(sf), ""));
        PresenceConditionTerm result = allSubFeaturesNegatedTerms.reduce(notCurrent, (a, f) -> VariabilityModelElementFactory.createAndPC(a, f, ""));
        return result;
    }

    public static String featureConfigurationValueToString(IFeatureConfiguration<?> featureConf) {
        if (featureConf instanceof AlternativeFeatureConfiguration) {
            AlternativeFeatureConfiguration afc = (AlternativeFeatureConfiguration)featureConf;
            IFeatureConfiguration selectedConfiguration = afc.getSelectedConfiguration();
            if (selectedConfiguration != null) {
                return selectedConfiguration.getFeatureReference().getName();
            }
            if (((AbstractAlternativeFeature)afc.getFeatureReference()).isOptional()) {
                return OPTIONAL_ALTERNATIVE_NOT_SELECTED_STRING;
            }
            return ALTERNATIVE_NOTHING_SELECTED_STRING;
        }
        if (featureConf.isSelected()) {
            return "Selected";
        }
        return "Deselected";
    }

    public static boolean evaluateLiteral(IFeatureConfiguration<?> varConf, LiteralPC literal) {
        ILiteralReferencable litRef = literal.getLiteralReference();
        Object confFeat = varConf.getFeatureReference();
        if (litRef == null) {
            System.err.println("Empy Literal found in Presence Condition. String representation is: \"" + literal.getStringRepresentation() + "\". The literal will be ignored!");
            return true;
        }
        if (litRef.equals(confFeat) && varConf.isSelected()) {
            return true;
        }
        if (varConf instanceof AlternativeFeatureConfiguration) {
            IFeatureConfiguration selectedAltConf = ((AlternativeFeatureConfiguration)varConf).getSelectedConfiguration();
            return selectedAltConf != null && VariabilityStaticImpl.evaluateLiteral(selectedAltConf, literal);
        }
        if (varConf instanceof CompositionalFeatureConfiguration) {
            return ((CompositionalFeatureConfiguration)varConf).getSubConfigurations().stream().anyMatch(c -> VariabilityStaticImpl.evaluateLiteral(c, literal));
        }
        throw new RuntimeException("Unknown FeatureCofiguration of type " + varConf.eClass().getName() + " found when evaluating the literal " + literal.getStringRepresentation() + "!");
    }

    public static boolean evaluatePresenceCondition(PresenceCondition pc, ICompleteEvaluationContext context) {
        if (pc instanceof LiteralPC) {
            LiteralPC lit = (LiteralPC)pc;
            return context.evaluateLiteral(lit);
        }
        if (pc instanceof NotPC) {
            NotPC not = (NotPC)pc;
            return !not.getOperand().evaluate(context);
        }
        if (pc instanceof OrPC) {
            OrPC or = (OrPC)pc;
            return or.getOperand1().evaluate(context) || or.getOperand2().evaluate(context);
        }
        if (pc instanceof AndPC) {
            AndPC and = (AndPC)pc;
            return and.getOperand1().evaluate(context) && and.getOperand2().evaluate(context);
        }
        if (pc instanceof TruePC) {
            return true;
        }
        throw new IllegalArgumentException("The passed PresenceCondition is null or cannot be evaluated!");
    }

    public static <D> D deactivateOptionalVariationPoint(IOptionalVariationPoint<D> element, IBindingStrategy strategy) {
        EList<EObject> dependingElements = element.getDependingElements();
        dependingElements.stream().forEach(e -> {
            EObject eObject = strategy.doDeactivateElement(e);
        });
        return (D)strategy.doDeactivateElement(element);
    }

    public static <E> E doRemoveElement(E element) {
        if (element instanceof EObject) {
            EcoreUtil.delete((EObject)((EObject)element), (boolean)true);
        }
        return null;
    }

    public static RemoveBindingStrategy getRemoveBindingStrategyInstance() {
        return VariabilityStaticImpl.getRemoveBindingStrategyInstance();
    }

    public static boolean areFeaturesEqual(AbstractFeature subject, Object target) {
        if (target == null) {
            return false;
        }
        if (target instanceof AbstractFeatureModel) {
            return subject == target;
        }
        return target.getClass() == subject.getClass() && ((AbstractFeature)target).getName().equals(subject.getName());
    }

    public static PresenceConditionTerm resolveToFeatureLiterals(AndPC and) {
        return VariabilityModelElementFactory.createAndPC(and.getOperand1().resolveToFeatureLiterals(), and.getOperand2().resolveToFeatureLiterals(), "");
    }

    public static PresenceConditionTerm resolveToFeatureLiterals(OrPC or) {
        return VariabilityModelElementFactory.createOrPC(or.getOperand1().resolveToFeatureLiterals(), or.getOperand2().resolveToFeatureLiterals(), "");
    }

    public static PresenceConditionTerm resolveToFeatureLiterals(NotPC not) {
        return VariabilityModelElementFactory.createNotPC(not.getOperand().resolveToFeatureLiterals(), "");
    }

    public static PresenceConditionTerm resolveToFeatureLiterals(LiteralPC literal) {
        ILiteralReferencable reference = literal.getLiteralReference();
        if (reference == null || reference instanceof AbstractFeature) {
            return (PresenceConditionTerm)EcoreUtils.copy((EObject)literal);
        }
        return reference.resolveToFeatureLiterals();
    }

    public static PresenceConditionTerm resolveToFeatureLiterals(DefaultPCImpl defaultPCImpl) {
        IAlternativeVariationPoint altVarPoint = VariabilityUtilsInternal.getFirstParentWithType(defaultPCImpl, IAlternativeVariationPoint.class);
        if (altVarPoint == null || altVarPoint.getAlternatives().size() <= 1) {
            return VariabilityModelElementFactory.createTruePC();
        }
        EList alternatives = altVarPoint.getAlternatives();
        boolean hasDefault = false;
        ArrayList<PresenceConditionTerm> otherAlternativePCs = new ArrayList<PresenceConditionTerm>();
        for (IHasPresenceCondition alt : alternatives) {
            PresenceCondition altPC = alt.getPresenceCondition();
            if (altPC instanceof DefaultPC) {
                if (altPC == defaultPCImpl) {
                    hasDefault = true;
                    continue;
                }
                VariabilityUtilsInternal.logInfo("The is an AlternativeVariationPoint \"" + altVarPoint.getName() + "\" with more than one DEFAULT presence condition.");
                return VariabilityModelElementFactory.createTruePC();
            }
            otherAlternativePCs.add(alt.getPresenceCondition().resolveToFeatureLiterals());
        }
        if (hasDefault) {
            PresenceConditionTerm others = (PresenceConditionTerm)otherAlternativePCs.get(0);
            int i = 1;
            while (i < otherAlternativePCs.size()) {
                others = VariabilityModelElementFactory.createOrPC(others, (PresenceConditionTerm)otherAlternativePCs.get(i), "");
                ++i;
            }
            return VariabilityModelElementFactory.createNotPC(others, "");
        }
        return VariabilityModelElementFactory.createTruePC();
    }
}

