/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.variability.util;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Z3javaAPIWrapper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.fortiss.variability.model.features.AbstractAlternativeFeature;
import org.fortiss.variability.model.features.AbstractCompositionalFeature;
import org.fortiss.variability.model.features.AbstractCrossFeatureConstraint;
import org.fortiss.variability.model.features.AbstractFeature;
import org.fortiss.variability.model.features.AbstractFeatureModel;
import org.fortiss.variability.model.features.CrossFeatureConstraintType;

public class FeatureModelTransformationUtils {
    public static BoolExpr feature2Z3(AbstractFeature feature, Context ctx) {
        return FeatureModelTransformationUtils.feature2Z3(feature, ctx, false);
    }

    public static BoolExpr feature2Z3(AbstractFeature feature, Context ctx, boolean sanatizeName) {
        return FeatureModelTransformationUtils.createBoolConst(ctx, feature.getName(), sanatizeName);
    }

    public static BoolExpr featureModel2Z3(AbstractFeatureModel featureModel, Context ctx, Map<BoolExpr, AbstractFeature> expr2FeatureMap) {
        return FeatureModelTransformationUtils.featureModel2Z3(featureModel, ctx, expr2FeatureMap, false);
    }

    public static BoolExpr featureModel2Z3(AbstractFeatureModel featureModel, Context ctx, Map<BoolExpr, AbstractFeature> expr2FeatureMap, boolean sanatizeLiteralNames) {
        ArrayDeque<AbstractFeature> worklist = new ArrayDeque<AbstractFeature>();
        ArrayList<BoolExpr> clauses = new ArrayList<BoolExpr>();
        EList<AbstractFeature> rootFeatures = featureModel.getSubFeatures();
        worklist.addAll((Collection<AbstractFeature>)rootFeatures);
        worklist.stream().filter(f -> !f.isOptional()).map(f -> FeatureModelTransformationUtils.createBoolConst(ctx, f.getName(), sanatizeLiteralNames)).forEach(e -> {
            boolean bl = clauses.add((BoolExpr)e);
        });
        while (worklist.size() > 0) {
            AbstractFeature currentFeature = (AbstractFeature)worklist.poll();
            BoolExpr currentLiteral = FeatureModelTransformationUtils.createBoolConst(ctx, currentFeature.getName(), sanatizeLiteralNames);
            expr2FeatureMap.put(currentLiteral, currentFeature);
            if (currentFeature instanceof AbstractAlternativeFeature) {
                EList<AbstractFeature> alternatives = ((AbstractAlternativeFeature)currentFeature).getAlternatives();
                ArrayList<BoolExpr> altExprs = new ArrayList<BoolExpr>();
                for (AbstractFeature alt : alternatives) {
                    BoolExpr altLiteral = FeatureModelTransformationUtils.createBoolConst(ctx, alt.getName(), sanatizeLiteralNames);
                    expr2FeatureMap.put(altLiteral, alt);
                    altExprs.add(altLiteral);
                    clauses.add(Z3javaAPIWrapper.createImplication((Context)ctx, (BoolExpr)altLiteral, (BoolExpr)currentLiteral));
                }
                clauses.add(Z3javaAPIWrapper.createImplication((Context)ctx, (BoolExpr)currentLiteral, (BoolExpr)Z3javaAPIWrapper.createXor((Context)ctx, (BoolExpr[])altExprs.toArray(new BoolExpr[0]))));
                worklist.addAll((Collection<AbstractFeature>)alternatives);
            }
            if (currentFeature instanceof AbstractCompositionalFeature) {
                EList<AbstractFeature> subFeatures = ((AbstractCompositionalFeature)currentFeature).getSubFeatures();
                for (AbstractFeature f2 : subFeatures) {
                    BoolExpr literal = FeatureModelTransformationUtils.createBoolConst(ctx, f2.getName(), sanatizeLiteralNames);
                    expr2FeatureMap.put(literal, f2);
                    clauses.add(Z3javaAPIWrapper.createImplication((Context)ctx, (BoolExpr)literal, (BoolExpr)currentLiteral));
                    if (!f2.isOptional()) {
                        clauses.add(Z3javaAPIWrapper.createImplication((Context)ctx, (BoolExpr)currentLiteral, (BoolExpr)literal));
                    }
                    worklist.add(f2);
                }
            }
            EList<AbstractCrossFeatureConstraint> constraints = currentFeature.getConstraints();
            for (AbstractCrossFeatureConstraint cfc : constraints) {
                AbstractFeature target = cfc.getTarget();
                if (target == null) continue;
                BoolExpr targetLiteral = FeatureModelTransformationUtils.createBoolConst(ctx, target.getName(), sanatizeLiteralNames);
                if (cfc.getType() == CrossFeatureConstraintType.EXCLUDES) {
                    clauses.add(Z3javaAPIWrapper.createImplication((Context)ctx, (BoolExpr)currentLiteral, (BoolExpr)Z3javaAPIWrapper.createNot((Context)ctx, (BoolExpr)targetLiteral)));
                }
                if (cfc.getType() != CrossFeatureConstraintType.REQUIRES) continue;
                clauses.add(Z3javaAPIWrapper.createImplication((Context)ctx, (BoolExpr)currentLiteral, (BoolExpr)targetLiteral));
            }
        }
        return Z3javaAPIWrapper.createAnd((Context)ctx, (BoolExpr[])clauses.toArray(new BoolExpr[0]));
    }

    private static BoolExpr createBoolConst(Context ctx, String name, boolean sanatizeName) {
        if (sanatizeName) {
            name = FeatureModelTransformationUtils.sanitizeZ3LiteralName(name);
        }
        return Z3javaAPIWrapper.createBoolConst((Context)ctx, (String)name);
    }

    public static String sanitizeZ3LiteralName(String literal) {
        literal = ((String)literal).replaceAll("\\s+", "");
        literal = ((String)literal).replace("\u00e4", "ae");
        literal = ((String)literal).replace("\u00fc", "ue");
        literal = ((String)literal).replace("\u00f6", "oe");
        literal = ((String)literal).replace("\u00df", "ss");
        literal = "lit" + (String)literal;
        return literal;
    }
}

