/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.variability.util;

import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.variability.model.VariabilityModelElementFactory;
import org.fortiss.variability.model.features.AbstractCompositionalFeature;
import org.fortiss.variability.model.features.AbstractCrossFeatureConstraint;
import org.fortiss.variability.model.features.AbstractFeature;
import org.fortiss.variability.model.features.configuration.CompositionalFeatureConfiguration;
import org.fortiss.variability.model.features.configuration.IFeatureConfiguration;
import org.fortiss.variability.model.presence.ILiteralReferencable;
import org.fortiss.variability.model.presence.PresenceConditionTerm;
import org.fortiss.variability.util.VariabilityUtilsInternal;

public class VariabilityUtils {
    public static final String FEATURE_LITERAL_LEGAL_CHAR_REGEX = "[a-zA-Z\\d\\$&\\[\\]_\\-\\+@/\\\\,\\.=]";
    public static final String PRESENCE_CONDITIONS_KEYWORDS = "OR|AND|NOT|DEFAULT";

    public static void renameLiteralReferencable(ILiteralReferencable literal, String newName) {
        String oldName = literal.getName();
        literal.setName(newName);
        Collection allReferences = VariabilityUtilsInternal.getAllReferences(literal).stream().filter(e -> e instanceof PresenceConditionTerm).map(e -> (PresenceConditionTerm)e).collect(Collectors.toList());
        for (PresenceConditionTerm r : allReferences) {
            VariabilityUtils.fixStringRepresentation(r, oldName, newName);
        }
    }

    private static void fixStringRepresentation(PresenceConditionTerm presCond, String oldName, String newName) {
        String oldStrRep = presCond.getStringRepresentation();
        Pattern p = Pattern.compile("(\\A|[^A-Za-z\\d])(" + oldName + ")([^A-Za-z\\d]|\\Z)");
        Matcher m = p.matcher(oldStrRep);
        if (m.find()) {
            String newStrRep = m.replaceAll("$1" + newName + "$3");
            presCond.setStringRepresentation(newStrRep);
        }
        if (presCond.eContainer() instanceof PresenceConditionTerm) {
            PresenceConditionTerm parent = (PresenceConditionTerm)presCond.eContainer();
            VariabilityUtils.fixStringRepresentation(parent, oldName, newName);
        }
    }

    public static void selectFeatureConfiguration(CompositionalFeatureConfiguration fc) {
        EList<IFeatureConfiguration<?>> subConfigs = fc.getSubConfigurations();
        subConfigs.clear();
        EList<AbstractFeature> subFeatures = ((AbstractCompositionalFeature)fc.getFeatureReference()).getSubFeatures();
        List newSubConfigs = subFeatures.stream().map(f -> VariabilityModelElementFactory.createFeatureConfigurationForFeature(f)).collect(Collectors.toList());
        subConfigs.addAll(newSubConfigs);
        fc.setSelected(true);
    }

    public static void deselectFeatureConfiguration(CompositionalFeatureConfiguration fc) {
        fc.getSubConfigurations().clear();
        fc.setSelected(false);
    }

    public static boolean checkAndDeselectFeatureConfiguration(CompositionalFeatureConfiguration fc) {
        AbstractCompositionalFeature feature = (AbstractCompositionalFeature)fc.getFeatureReference();
        if (feature != null && feature.isOptional()) {
            VariabilityUtils.deselectFeatureConfiguration(fc);
            return true;
        }
        return false;
    }

    public static boolean isNameLegalInPresenceCondition(String literalName) {
        if (literalName.matches(PRESENCE_CONDITIONS_KEYWORDS)) {
            return false;
        }
        return literalName.matches("[a-zA-Z\\d\\$&\\[\\]_\\-\\+@/\\\\,\\.=]+");
    }

    public static List<AbstractFeature> getAllLegalConstraintTargets(AbstractCrossFeatureConstraint constraint) {
        List<AbstractFeature> features = VariabilityUtilsInternal.getAllElementsFromSameContainmentTree(constraint, AbstractFeature.class);
        features.removeAll((Collection<?>)VariabilityUtilsInternal.getParentsWithType(constraint, AbstractFeature.class));
        return features;
    }

    public static List<ILiteralReferencable> getLiteralsWithName(EObject context, String name) {
        return VariabilityUtilsInternal.getAllElementsFromSameContainmentTree(context, ILiteralReferencable.class).stream().filter(l -> l.getName().equals(name)).collect(Collectors.toList());
    }
}

