/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.variability.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.variability.VariabilityActivator;
import org.fortiss.variability.model.VariabilityModelElementFactory;
import org.fortiss.variability.model.presence.IHasPresenceCondition;
import org.fortiss.variability.model.presence.PresenceConditionTerm;

public class VariabilityUtilsInternal {
    public static <T extends EObject> List<T> getAllElementsFromSameContainmentTree(EObject context, Class<T> clazz) {
        if (context == null) {
            throw new IllegalArgumentException("The given context is either null or is not contained in a FileProject!");
        }
        EObject root = context;
        while (root.eContainer() != null) {
            root = root.eContainer();
        }
        return VariabilityUtilsInternal.getChildrenWithType(root, clazz);
    }

    public static <T> T performNearestClassLookup(Class<?> clazz, Map<Class<?>, T> classMap) {
        LinkedList q = new LinkedList();
        q.add(clazz);
        while (!q.isEmpty()) {
            Class current = (Class)q.poll();
            if (classMap.containsKey(current)) {
                return classMap.get(current);
            }
            Class superClass = current.getSuperclass();
            if (superClass != null && superClass != Object.class) {
                q.add(superClass);
            }
            Class<?>[] classArray = current.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> iface = classArray[n2];
                q.add(iface);
                ++n2;
            }
        }
        return classMap.get(Object.class);
    }

    public static <S> EList<S> getChildrenWith(EObject parent, Predicate<EObject> pred) {
        BasicEList children = new BasicEList();
        TreeIterator content = EcoreUtil.getAllContents((EObject)parent, (boolean)true);
        while (content.hasNext()) {
            EObject child = (EObject)content.next();
            if (!pred.test(child)) continue;
            children.add((Object)child);
        }
        return children;
    }

    public static <S> EList<S> getChildrenWithType(EObject parent, Class<S> type) {
        Predicate<EObject> isAssignable = element -> type.isAssignableFrom(element.getClass());
        return VariabilityUtilsInternal.getChildrenWith(parent, isAssignable);
    }

    public static <T extends EObject> EList<T> getParentsWith(EObject child, Predicate<EObject> pred) {
        BasicEList parentElements = new BasicEList();
        EObject currentParent = child.eContainer();
        while (currentParent != null) {
            if (pred.test(currentParent)) {
                parentElements.add((Object)currentParent);
            }
            currentParent = currentParent.eContainer();
        }
        return parentElements;
    }

    public static <T extends EObject> EList<T> getParentsWithType(EObject child, Class<T> type) {
        Predicate<EObject> isAssignable = element -> type.isAssignableFrom(element.getClass());
        return VariabilityUtilsInternal.getParentsWith(child, isAssignable);
    }

    public static <T extends EObject> T getFirstParentWith(EObject child, Predicate<EObject> pred) {
        EObject currentParent = child.eContainer();
        while (currentParent != null) {
            if (pred.test(currentParent)) {
                return (T)currentParent;
            }
            currentParent = currentParent.eContainer();
        }
        return null;
    }

    public static <T extends EObject> T getFirstParentWithType(EObject child, Class<T> type) {
        Predicate<EObject> isAssignable = element -> type.isAssignableFrom(element.getClass());
        return VariabilityUtilsInternal.getFirstParentWith(child, isAssignable);
    }

    public static Collection<EStructuralFeature.Setting> getAllReferences(EObject referencedEObject) {
        ResourceSet resourceSet;
        EObject rootEObject = EcoreUtil.getRootContainer((EObject)referencedEObject);
        Resource resource = rootEObject.eResource();
        Collection usages = resource == null ? EcoreUtil.UsageCrossReferencer.find((EObject)referencedEObject, (EObject)rootEObject) : ((resourceSet = resource.getResourceSet()) == null ? EcoreUtil.UsageCrossReferencer.find((EObject)referencedEObject, (Resource)resource) : EcoreUtil.UsageCrossReferencer.find((EObject)referencedEObject, (ResourceSet)resourceSet));
        return usages;
    }

    public static PresenceConditionTerm calculateGlobalPresenceCondition(EObject elem) {
        EObject parent = elem.eContainer();
        PresenceConditionTerm parentPC = null;
        if (parent != null) {
            parentPC = VariabilityUtilsInternal.calculateGlobalPresenceCondition(parent);
        }
        PresenceConditionTerm rest = null;
        if (elem instanceof IHasPresenceCondition) {
            rest = ((IHasPresenceCondition)elem).getPresenceCondition().resolveToFeatureLiterals();
        }
        if (parentPC != null) {
            if (rest != null) {
                return VariabilityModelElementFactory.createAndPC(parentPC, rest, "");
            }
            return parentPC;
        }
        return rest;
    }

    private static void log(Plugin plugin, String message, int severity, Throwable cause) {
        String pluginId = plugin.getBundle().getSymbolicName();
        Status status = new Status(severity, pluginId, message, cause);
        plugin.getLog().log((IStatus)status);
    }

    public static void logInfo(String message) {
        VariabilityUtilsInternal.log(VariabilityActivator.getDefault(), message, 1, null);
    }

    public static void logWarning(String message) {
        VariabilityUtilsInternal.log(VariabilityActivator.getDefault(), message, 2, null);
    }

    public static void logError(String message, Exception exception) {
        VariabilityUtilsInternal.log(VariabilityActivator.getDefault(), message, 4, exception);
    }

    public static void logError(String message) {
        VariabilityUtilsInternal.log(VariabilityActivator.getDefault(), message, 4, null);
    }
}

