/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.cosimulation.textgen;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.behavior.IComponentBehaviorDefinitionSpecification;
import org.fortiss.af3.component.utils.ComponentArchitectureUtils;
import org.fortiss.af3.cosimulation.model.ExternalSimulationConfiguration;
import org.fortiss.af3.cosimulation.model.FMUSpecification;
import org.fortiss.af3.project.utils.FileUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class CosimulationConfigurationTextGenerator {
    public static String JSONFileContents(Component root, ExternalSimulationConfiguration simConfig) {
        StringBuffer buf = new StringBuffer();
        buf.append("{\"fmus\":{\n");
        buf.append(CosimulationConfigurationTextGenerator.getFMULinks(root));
        buf.append("\n},\n");
        buf.append("\"connections\":{\n");
        buf.append(CosimulationConfigurationTextGenerator.getConnectionBetweenComponents(root));
        buf.append("\n},\n");
        buf.append("\"parameters\":{\n");
        buf.append("},\n");
        buf.append("\"logVariables\":{\n");
        buf.append(CosimulationConfigurationTextGenerator.getLogVariables(root));
        buf.append("},\n");
        buf.append("\"algorithm\":{\n");
        buf.append(CosimulationConfigurationTextGenerator.getAlgorithmInformation(simConfig));
        buf.append("}\n");
        buf.append("}\n");
        return buf.toString();
    }

    private static Object getAlgorithmInformation(ExternalSimulationConfiguration simConfig) {
        Object buf = "";
        buf = (String)buf + "\"type\":\"fixed-step\",\n";
        buf = (String)buf + "\"size\":" + simConfig.getStepSize() + "\n";
        return buf;
    }

    private static Object getLogVariables(Component root) {
        Object buf = "";
        for (OutputPort port : root.getOutputPorts()) {
            Port sourcePort = ComponentArchitectureUtils.computeSourcePort((Port)port);
            if (sourcePort == null) continue;
            String componentPort = sourcePort.getName();
            String comp = sourcePort.getComponent().getName().replace(".", "");
            buf = (String)buf + "\"{" + comp + "}." + comp + "Instance\":[\"" + componentPort + "\"],\n";
        }
        return buf == "" ? "" : ((String)buf).substring(0, ((String)buf).length() - 2);
    }

    private static Object getConnectionBetweenComponents(Component root) {
        Object buf = "";
        for (Component currentComponent : root.getSubComponents()) {
            for (Port outputPortCurrentComponent : currentComponent.getOutputPorts()) {
                Object tempBuf = "";
                for (Channel ch : outputPortCurrentComponent.getOutgoingChannels()) {
                    Port inputPortNextComponent = ch.getTarget();
                    if (inputPortNextComponent.getComponent().equals(root)) continue;
                    Component nextComponent = inputPortNextComponent.getComponent();
                    if (tempBuf == "") {
                        buf = (String)buf + "\"{" + currentComponent.getName().replace(".", "") + "}." + currentComponent.getName().replace(".", "") + "Instance." + outputPortCurrentComponent.getName() + "\":[";
                    }
                    tempBuf = (String)tempBuf + "\"{" + nextComponent.getName().replace(".", "") + "}." + nextComponent.getName().replace(".", "") + "Instance." + inputPortNextComponent.getName() + "\",";
                }
                if (tempBuf == "") continue;
                buf = (String)buf + ((String)tempBuf).substring(0, ((String)tempBuf).length() - 1);
                buf = (String)buf + "],\n";
            }
        }
        return buf == "" ? "" : ((String)buf).substring(0, ((String)buf).length() - 2);
    }

    private static Object getFMULinks(Component root) {
        Object buf = "";
        for (Component c : root.getSubComponents()) {
            if (!ComponentArchitectureUtils.hasBehaviorDefinitionSpecification((Component)c)) continue;
            EList spec = EcoreUtils.pickInstanceOf(IComponentBehaviorDefinitionSpecification.class, (List)c.getSpecifications());
            if (spec.get(0) instanceof FMUSpecification) {
                FMUSpecification fmu = (FMUSpecification)spec.get(0);
                buf = (String)buf + "\"{" + c.getName().replace(".", "") + "}\":\"file:///" + fmu.getFMUPath().replace("\\", "/") + "\",\n";
                continue;
            }
            IPath af3Prj = FileUtils.getAF3EclipseProject().getLocation();
            String fmuLocation = String.valueOf(af3Prj) + "/" + c.getName() + ".fmu";
            buf = (String)buf + "\"{" + c.getName().replace(".", "") + "}\":\"file:///" + fmuLocation + "\",\n";
        }
        return buf == "" ? "" : ((String)buf).substring(0, ((String)buf).length() - 2);
    }
}

