/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.ganttchartview;

import java.math.BigDecimal;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.schedule.model.ResourceSchedule;
import org.fortiss.af3.schedule.model.Schedule;
import org.fortiss.af3.schedule.model.SubSchedule;
import org.fortiss.af3.schedule.ui.ganttchartview.AbstractObjectToDraw;
import org.fortiss.af3.schedule.ui.utils.ScheduleViewUtils;
import org.fortiss.tooling.kernel.model.INamedElement;

public class LabelToDraw
extends AbstractObjectToDraw {
    private String labelName;

    public LabelToDraw(BigDecimal startingPoint_x, BigDecimal startingPoint_y, BigDecimal width, boolean withBorder, Color color, String labelName) {
        super(startingPoint_x, startingPoint_y, width, withBorder, color);
        this.labelName = labelName;
    }

    @Override
    public String getName() {
        return this.labelName;
    }

    public static void drawLabel(GC gc, LabelToDraw label, int x, int y, int width, int height, Font font) {
        ScheduleViewUtils.drawSubscriptedCaptionCentered(label.getName(), "", new Rectangle(x, y, width, height), gc, font, font);
    }

    public static LabelToDraw createLabel(Schedule schedule, int y, int width, Color color, Map<EObject, Color> objectToColor) {
        Object labelString;
        Schedule resource = null;
        if (schedule instanceof ResourceSchedule) {
            ResourceSchedule resSched = (ResourceSchedule)schedule;
            resource = (INamedElement)resSched.getResource();
            labelString = resource.getName();
            if (resource instanceof ExecutionUnit) {
                long frequency = resSched.getFrequency();
                labelString = (String)labelString + " [fr: " + frequency + "]";
            }
        } else if (schedule instanceof SubSchedule) {
            resource = schedule;
            labelString = resource.getName();
        } else {
            throw new UnknownError("Unknown schedule " + String.valueOf(schedule.getClass()));
        }
        objectToColor.put((EObject)resource, color);
        return new LabelToDraw(BigDecimal.ZERO, BigDecimal.valueOf(y), BigDecimal.valueOf(width), false, color, (String)labelString);
    }
}

