/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.ganttchartview;

import java.math.BigDecimal;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.fortiss.af3.schedule.ui.ganttchartview.AbstractObjectToDraw;
import org.fortiss.af3.schedule.ui.ganttchartview.ScheduleViewLayoutData;

public class LineToDraw
extends AbstractObjectToDraw {
    private boolean isHorizontal;
    private String label;

    public LineToDraw(BigDecimal startingPoint_x, BigDecimal startingPoint_y, BigDecimal length, boolean isHorizontal, Color color, String label) {
        super(startingPoint_x, startingPoint_y, length, false, color);
        this.isHorizontal = isHorizontal;
        this.label = label;
    }

    @Override
    public String getName() {
        return this.label;
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    public static void drawLine(GC gc, LineToDraw line, Color color1, Color color2, Color color3, ScheduleViewLayoutData layoutData) {
        int yLabel;
        int xLabel;
        int y2;
        int x2;
        int x = layoutData.objectSpaceToDiagramSpaceX(line.getStartingPoint_X());
        int y = layoutData.objectSpaceToDiagramSpaceY(line.getStartingPoint_Y());
        int width = layoutData.scaleLengthObjectSpaceToDiagramSpaceX(line.getWidth());
        gc.setForeground(color1);
        if (line.isHorizontal()) {
            x2 = x + width;
            y2 = y;
            xLabel = x + width / 2;
            yLabel = y - 10;
        } else {
            x2 = x;
            y2 = y + width;
            xLabel = x;
            yLabel = y + width / 2;
        }
        int lineWidth = gc.getLineWidth();
        gc.setLineWidth(lineWidth + 2);
        gc.setBackground(color2);
        gc.drawLine(x, y, x2, y2);
        gc.drawText(line.getName(), xLabel, yLabel);
        gc.setForeground(color3);
        gc.setLineWidth(lineWidth);
    }
}

