/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.ganttchartview;

import java.math.BigDecimal;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.ResourceAllocationFragment;
import org.fortiss.af3.schedule.ui.ganttchartview.AbstractObjectToDraw;
import org.fortiss.af3.schedule.ui.utils.ScheduleViewUtils;
import org.fortiss.af3.schedule.utils.ScheduleUtils;
import org.fortiss.tooling.kernel.model.INamedElement;

public class ScheduleModelElementToDraw
extends AbstractObjectToDraw {
    private EObject object;

    public ScheduleModelElementToDraw(EObject object, BigDecimal startingPoint_x, BigDecimal startingPoint_y, BigDecimal width, boolean withBorder, Color color) {
        super(startingPoint_x, startingPoint_y, width, withBorder, color);
        this.object = object;
    }

    public EObject getObject() {
        return this.object;
    }

    @Override
    public String getName() {
        if (this.object instanceof INamedElement) {
            return ((INamedElement)this.object).getName();
        }
        return this.object.toString();
    }

    public static void drawScheduleModelElement(GC gc, ScheduleModelElementToDraw scheduleModelElement, int x, int y, int width, int maxWidth, int height, Font font) {
        int x2 = x + width;
        x = Math.max(x, -1);
        width = Math.max(Math.min(x2 - x, maxWidth), 1);
        Rectangle rectangle = new Rectangle(x, y, width, height);
        if (scheduleModelElement.hasBorder()) {
            gc.setAlpha(190);
            gc.setBackground(scheduleModelElement.getColor());
            gc.fillRectangle(rectangle);
            gc.setAlpha(255);
            gc.drawRectangle(rectangle);
        }
        ScheduleViewUtils.drawSubscriptedCaptionCentered(scheduleModelElement.getName(), "", rectangle, gc, font, font);
        BigDecimal period = null;
        ResourceAllocation ra = null;
        EObject object2 = scheduleModelElement.getObject();
        if (object2 instanceof ResourceAllocation) {
            ra = (ResourceAllocation)object2;
        } else if (object2 instanceof ResourceAllocationFragment) {
            ra = (ResourceAllocation)object2.eContainer();
        }
        period = ScheduleUtils.getPeriod((ResourceAllocation)ra);
        if (period != null && period.compareTo(BigDecimal.ZERO) != 0) {
            String periodLabel = "p=" + String.valueOf(period);
            Point periodLabelExtend = gc.stringExtent(periodLabel);
            if (3 * periodLabelExtend.y < height) {
                ScheduleViewUtils.drawInfoLabel(gc, periodLabel, rectangle);
            }
        }
    }

    public static ScheduleModelElementToDraw createScheduleModelElement(ResourceAllocation resourceAllocation, BigDecimal roundOffset, int y, Color color) {
        BigDecimal phase = ScheduleUtils.getPhase((ResourceAllocation)resourceAllocation);
        if (phase == null) {
            phase = BigDecimal.ZERO;
        }
        if (resourceAllocation.getDuration() == null) {
            return null;
        }
        return new ScheduleModelElementToDraw((EObject)resourceAllocation, roundOffset.add(phase), BigDecimal.valueOf(y), resourceAllocation.getDuration(), true, color);
    }

    public static ScheduleModelElementToDraw createScheduleModelElement(ResourceAllocationFragment fragment, BigDecimal roundOffset, int y, Color color) {
        BigDecimal phase = ScheduleUtils.getPhase((ResourceAllocationFragment)fragment);
        if (phase == null) {
            return null;
        }
        if (fragment.getDuration() == null) {
            return null;
        }
        return new ScheduleModelElementToDraw((EObject)fragment, roundOffset.add(phase), BigDecimal.valueOf(y), fragment.getDuration(), true, color);
    }
}

