/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.ganttchartview;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.schedule.model.Schedule;
import org.fortiss.af3.schedule.model.SubSchedule;
import org.fortiss.af3.schedule.model.SystemSchedule;
import org.fortiss.af3.schedule.ui.ganttchartview.ScheduleViewComposite;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.ui.util.SelectionUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.ResourceUtils;

public class ScheduleView
extends ViewPart
implements ISelectionListener {
    public static final String ID = "org.fortiss.af3.schedule.ui.ganttchartview.ScheduleView";
    private static final String MEMENTO_KEY_SCHEDULE_URI = "scheduleUri";
    private ScheduleViewComposite viewer;
    private boolean isSelectionChangedEnabled = true;
    private EObject scheduleContainer;
    private FileProject fileProject;
    private EContentAdapter fileProjectScheduleChangeAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            int eventType = notification.getEventType();
            Object notifier = notification.getNotifier();
            if ((eventType == 3 || eventType == 5 || eventType == 4 || eventType == 6) && notifier == ScheduleView.this.scheduleContainer) {
                ScheduleView.this.setSchedule();
            }
            if ((eventType == 4 || eventType == 6) && notification.getOldValue() == ScheduleView.this.scheduleContainer) {
                ScheduleView.this.scheduleContainer = null;
                ScheduleView.this.fileProject.eAdapters().remove((Object)ScheduleView.this.fileProjectScheduleChangeAdapter);
                ScheduleView.this.fileProject = null;
                ScheduleView.this.setSchedule();
            }
            if (ScheduleView.this.scheduleContainer instanceof INamedElement && eventType == 1 && notifier == ScheduleView.this.scheduleContainer) {
                ScheduleView.this.updateTitle();
            }
        }
    };

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.isSelectionChangedEnabled) {
            return;
        }
        this.isSelectionChangedEnabled = false;
        SystemSchedule systemSchedule = null;
        EObject obj = (EObject)SelectionUtils.checkAndPickFirst((ISelection)selection, EObject.class);
        if (obj != null) {
            systemSchedule = (SystemSchedule)KernelModelElementUtils.getParentElement((EObject)obj, SystemSchedule.class, (boolean)true);
        }
        if (systemSchedule != null) {
            this.scheduleContainer = systemSchedule;
            this.setSchedule();
            FileProject fp = (FileProject)KernelModelElementUtils.getParentElement((EObject)systemSchedule, FileProject.class, (boolean)false);
            if (fp != this.fileProject) {
                if (this.fileProject != null) {
                    this.fileProject.eAdapters().remove((Object)this.fileProjectScheduleChangeAdapter);
                }
                this.fileProject = fp;
                this.fileProject.eAdapters().add((Object)this.fileProjectScheduleChangeAdapter);
            }
        }
        this.isSelectionChangedEnabled = true;
    }

    public void createPartControl(Composite parent) {
        this.viewer = new ScheduleViewComposite(parent, 0);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.setSchedule();
    }

    public void setSchedule(SubSchedule subSchedule) {
        this.scheduleContainer = subSchedule;
        this.fileProject = (FileProject)KernelModelElementUtils.getParentElement((EObject)subSchedule, FileProject.class, (boolean)false);
        if (this.fileProject != null) {
            this.fileProject.eAdapters().add((Object)this.fileProjectScheduleChangeAdapter);
        }
        this.setSchedule();
        this.isSelectionChangedEnabled = false;
    }

    private void setSchedule() {
        Object scheduleList = null;
        BigDecimal majorFrame = BigDecimal.ZERO;
        if (this.scheduleContainer instanceof SystemSchedule) {
            SystemSchedule systemSchedule = (SystemSchedule)this.scheduleContainer;
            scheduleList = systemSchedule.getScheduleList();
            if (systemSchedule.getMajorFrame() != null) {
                majorFrame = systemSchedule.getMajorFrame();
            }
        } else if (this.scheduleContainer instanceof SubSchedule) {
            scheduleList = Arrays.asList((SubSchedule)this.scheduleContainer);
            SystemSchedule systemSchedule = (SystemSchedule)KernelModelElementUtils.getParentElement((EObject)this.scheduleContainer, SystemSchedule.class, (boolean)false);
            majorFrame = systemSchedule != null ? systemSchedule.getMajorFrame() : BigDecimal.ZERO;
        }
        this.isSelectionChangedEnabled = true;
        this.viewer.setSchedule(this.scheduleContainer, (List<Schedule>)scheduleList, majorFrame);
        this.updateTitle();
    }

    private void updateTitle() {
        String scheduleName;
        if (this.scheduleContainer instanceof INamedElement && (scheduleName = ((INamedElement)this.scheduleContainer).getName()) != null && !scheduleName.isEmpty()) {
            this.setPartName(scheduleName);
        }
        if (this.scheduleContainer != null) {
            String projectHint;
            FileProject fp = (FileProject)KernelModelElementUtils.getParentElement((EObject)this.scheduleContainer, FileProject.class, (boolean)false);
            String string = projectHint = fp != null ? " in \"" + fp.getName() + "\"" : "";
            if (this.scheduleContainer instanceof SystemSchedule) {
                this.setTitleToolTip("System schedule" + projectHint);
            } else if (this.scheduleContainer instanceof SubSchedule) {
                this.setTitleToolTip("Sub-schedule refining resource allocation \"" + ((SubSchedule)this.scheduleContainer).getRefinedResourceAllocation().getName() + "\"" + projectHint);
            }
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        if (this.fileProject != null) {
            this.fileProject.eAdapters().remove((Object)this.fileProjectScheduleChangeAdapter);
        }
        if (this.viewer != null) {
            this.viewer.dispose();
        }
        super.dispose();
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        int numViewInstances = 0;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference[] iViewReferenceArray = activePage.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference viewReference = iViewReferenceArray[n2];
            if (viewReference.getId().equals(ID)) {
                ++numViewInstances;
            }
            ++n2;
        }
        if (numViewInstances > 1 && this.scheduleContainer != null) {
            memento.putString(MEMENTO_KEY_SCHEDULE_URI, EcoreUtil.getURI((EObject)this.scheduleContainer).toString());
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        URI uri;
        ITopLevelElement topLevelElement;
        String persistedURI;
        super.init(site, memento);
        String string = persistedURI = memento != null ? memento.getString(MEMENTO_KEY_SCHEDULE_URI) : null;
        if (persistedURI != null && (topLevelElement = ResourceUtils.getTopLevelElement((URI)(uri = URI.createURI((String)persistedURI)).trimFragment())) != null) {
            this.scheduleContainer = topLevelElement.getResourceSet().getEObject(uri, false);
        }
    }

    public void setSchedule(List<Schedule> schedule, BigDecimal majorFrame) {
        this.viewer.setSchedule(this.scheduleContainer, schedule, majorFrame);
    }
}

