/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.ganttchartview;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.SubSchedule;
import org.fortiss.af3.schedule.ui.ganttchartview.ScheduleModelElementToDraw;
import org.fortiss.af3.schedule.ui.ganttchartview.ScheduleViewComposite;
import org.fortiss.af3.schedule.ui.ganttchartview.ScheduleViewGraphModel;
import org.fortiss.af3.schedule.ui.ganttchartview.ScheduleViewLayoutData;
import org.fortiss.af3.schedule.ui.ganttchartview.ScheduleViewModel;
import org.fortiss.af3.schedule.ui.utils.ScheduleUIUtils;
import org.fortiss.af3.schedule.ui.utils.ScheduleViewUtils;
import org.fortiss.af3.schedule.utils.MathUtils;

public class ScheduleViewCanvas
extends Canvas {
    private ScheduleViewModel scheduleModel = new ScheduleViewModel(this);
    private static final int DIAGRAM_TOOLTIP_OFFSET_X = 20;
    public static final int DIAGRAM_COORDINATE_SYSTEM_EXTRA_LINE_LENGTH = 5;
    private ScheduleViewLayoutData scheduleLayoutData = new ScheduleViewLayoutData(this);
    private ScheduleViewGraphModel scheduleGraphModel = new ScheduleViewGraphModel(this);
    private int diagramMouseX;
    private int diagramMouseY;
    private int diagramMouseDownX = -1;
    private boolean displayPeriodsSchedulableEntities = true;
    private boolean displayPeriodsSchedules = true;

    public ScheduleViewCanvas(ScheduleViewComposite scheduleViewComposite, int style) {
        super((Composite)scheduleViewComposite, style | 0x100000 | 0x100 | 0x20000000);
        this.addPaintListener(new PaintListener());
        this.addMouseMoveListener(new MouseMoveListener());
        this.addMouseListener((MouseListener)new MouseClickListener(scheduleViewComposite));
        this.addKeyListener(new KeyListener());
        this.addListener(11, new ResizeListener());
        ScrollBar hBar = this.getHorizontalBar();
        hBar.addListener(13, (Listener)new HorizontalScrollBarListener(hBar));
    }

    private void updateHorizontalBar() {
        ScrollBar hBar = this.getHorizontalBar();
        Rectangle client = this.getClientArea();
        int pageWidth = Math.min(this.scheduleLayoutData.getDiagramWidthOfGraph(), client.width);
        int increment = this.scheduleLayoutData.scaleLengthObjectSpaceToDiagramSpaceX(this.scheduleLayoutData.getModelLabelInterval());
        hBar.setMaximum(this.scheduleLayoutData.getDiagramWidthOfGraph());
        hBar.setThumb(pageWidth);
        hBar.setPageIncrement(pageWidth);
        hBar.setIncrement(increment);
        int hPage = this.scheduleLayoutData.getDiagramWidthOfGraph() - client.width;
        int hSelection = hBar.getSelection();
        if (hSelection >= hPage) {
            if (hPage <= 0) {
                hSelection = 0;
            }
            this.scheduleLayoutData.getDiagramOrigin().x = -hSelection;
        }
    }

    private void setHorizontalBarSelection(BigDecimal objectSelectionX) {
        this.scheduleLayoutData.update();
        this.updateHorizontalBar();
        int diagramSelectionX = this.scheduleLayoutData.scaleLengthObjectSpaceToDiagramSpaceX(objectSelectionX) + 20 + 150;
        this.getHorizontalBar().setSelection(diagramSelectionX);
        this.scheduleLayoutData.getDiagramOrigin().x = -diagramSelectionX;
    }

    private void drawToolTip(GC gc) {
        BigDecimal object_y;
        BigDecimal object_x = this.scheduleLayoutData.diagramSpaceToObjectSpaceX(this.diagramMouseX);
        ScheduleModelElementToDraw object = this.scheduleGraphModel.findObjectAt(object_x, object_y = this.scheduleLayoutData.diagramSpaceToObjectSpaceY(this.diagramMouseY));
        if (object != null) {
            String toolTipText = object.getName() + "\n";
            toolTipText = toolTipText + "start: " + String.valueOf(ScheduleViewUtils.getPhase(object)) + "\n";
            toolTipText = toolTipText + "duration: " + String.valueOf(ScheduleViewUtils.getDuration(object));
            gc.setForeground(this.getDisplay().getSystemColor(2));
            gc.drawText(toolTipText, this.diagramMouseX + 20, this.diagramMouseY);
        }
    }

    private void drawSelection(GC gc) {
        if (this.diagramMouseDownX > 0) {
            int x = this.diagramMouseDownX < this.diagramMouseX ? this.diagramMouseDownX : this.diagramMouseX;
            int width = Math.abs(this.diagramMouseDownX - this.diagramMouseX);
            Rectangle rectangle = new Rectangle(x, 0, width, this.getClientArea().height);
            gc.setAlpha(50);
            gc.setBackground(this.getDisplay().getSystemColor(9));
            gc.fillRectangle(rectangle);
        }
    }

    private int getHorizontalLineY(int i) {
        return (int)((double)(50 + i * this.scheduleLayoutData.getDiagramHeightOfSchedule()) - 1.0);
    }

    private void drawCoordinateSystem(GC gc) {
        Rectangle clientArea = this.getClientArea();
        int marginWidth = clientArea.width - this.scheduleLayoutData.getDiagramWidthOfGraph();
        if (marginWidth > 0) {
            gc.fillRectangle(this.scheduleLayoutData.getDiagramWidthOfGraph(), 0, marginWidth, clientArea.width);
        }
        int diagramX = this.scheduleLayoutData.objectSpaceToDiagramSpaceX(BigDecimal.ZERO);
        int diagramY = this.getHorizontalLineY(this.scheduleModel.getSchedules().size());
        int diagramY2 = 50;
        gc.drawLine(diagramX, diagramY + 10, diagramX, diagramY2);
        BigDecimal scheduleLength = this.scheduleModel.getScheduleLength();
        BigDecimal numHyperPeriods = BigDecimal.valueOf(this.scheduleModel.getNumberOfHyperPeriods());
        int diagramX2 = diagramX + this.scheduleLayoutData.scaleLengthObjectSpaceToDiagramSpaceX(scheduleLength.multiply(numHyperPeriods));
        diagramX = Math.max(diagramX, 0);
        diagramX2 = Math.min(diagramX2, clientArea.width);
        gc.drawLine(diagramX - 10, diagramY, diagramX2, diagramY);
        gc.setForeground(this.getDisplay().getSystemColor(18));
        int i = 1;
        while (i < this.scheduleModel.getSchedules().size()) {
            int diagramHorizotalLineY = this.getHorizontalLineY(i);
            gc.drawLine(diagramX - 5, diagramHorizotalLineY, diagramX2 + 5, diagramHorizotalLineY);
            ++i;
        }
        BigDecimal modelLabelInterval_bd = this.scheduleLayoutData.getModelLabelInterval();
        BigDecimal modelStartCoordinateLabel = this.scheduleLayoutData.scaleLengthDiagramSpaceToObjectSpaceX(-this.scheduleLayoutData.getDiagramOrigin().x).divide(modelLabelInterval_bd, ScheduleViewLayoutData.MATH_CONTEXT_DOUBLE_MAXIMUM_PRECISION).setScale(0, 3).multiply(modelLabelInterval_bd);
        BigDecimal modelEndCoordinateLabel = numHyperPeriods.multiply(scheduleLength).min(this.scheduleLayoutData.scaleLengthDiagramSpaceToObjectSpaceX(clientArea.width - this.scheduleLayoutData.getDiagramOrigin().x));
        DecimalFormat df = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.ROOT));
        int decimals = MathUtils.getPrecision((BigDecimal)this.scheduleLayoutData.getModelLabelInterval(), (int)6);
        df.setMaximumFractionDigits(decimals);
        df.setMinimumFractionDigits(decimals);
        df.setGroupingUsed(false);
        BigDecimal i2 = modelStartCoordinateLabel;
        while (i2.compareTo(modelEndCoordinateLabel) < 1) {
            int diagramLabelX = this.scheduleLayoutData.objectSpaceToDiagramSpaceX(i2);
            gc.drawLine(diagramLabelX, 45, diagramLabelX, diagramY + 15);
            gc.drawText(df.format(i2.setScale(5, 1)), diagramLabelX, diagramY + 15);
            i2 = i2.add(modelLabelInterval_bd);
        }
        BigDecimal majorFrame = this.scheduleModel.getMajorFrame();
        if (majorFrame == null || majorFrame.compareTo(BigDecimal.ZERO) == 0) {
            int lineWidth = gc.getLineWidth();
            gc.setLineWidth(lineWidth + 3);
            int i3 = 0;
            while (i3 < this.scheduleModel.getNumberOfHyperPeriods()) {
                diagramX = this.scheduleLayoutData.objectSpaceToDiagramSpaceX(BigDecimal.valueOf(i3 + 1).multiply(scheduleLength));
                if (this.displayPeriodsSchedulableEntities) {
                    this.drawPeriods(this.scheduleModel.getSchedulableEntityPeriods(), gc, 2, i3, diagramY);
                }
                if (this.displayPeriodsSchedules) {
                    this.drawPeriods(this.scheduleModel.getResourceSchedulePeriods(), gc, 9, i3, diagramY);
                }
                gc.setForeground(this.getDisplay().getSystemColor(3));
                gc.drawLine(diagramX, 25, diagramX, diagramY + 40);
                gc.drawString("Round " + (i3 + 1), diagramX + 5, diagramY + 40 - 15);
                ++i3;
            }
            gc.setLineWidth(lineWidth);
        }
    }

    private void drawPeriods(List<BigDecimal> periods, GC gc, int color, int round, int offsetY) {
        for (BigDecimal period : periods) {
            gc.setForeground(this.getDisplay().getSystemColor(color));
            int diagramPeriodX = this.scheduleLayoutData.objectSpaceToDiagramSpaceX(period.add(BigDecimal.valueOf(round).multiply(this.scheduleModel.getScheduleLength())));
            gc.drawLine(diagramPeriodX, 45, diagramPeriodX, offsetY + 5);
            gc.drawText(String.valueOf(MathUtils.round((BigDecimal)period, (int)6)), diagramPeriodX, offsetY + 5);
        }
    }

    public void setScalingUserX(int scaling) {
        if (scaling == this.scheduleLayoutData.getScalingUserX()) {
            return;
        }
        int diagramLeftXOld = this.scheduleLayoutData.getDiagramLeftX();
        BigDecimal objectLeftXOld = this.scheduleLayoutData.diagramSpaceToObjectSpaceX(diagramLeftXOld);
        BigDecimal objectVisibleWidthOld = this.scheduleLayoutData.getObjectVisibleWidth();
        BigDecimal middleOld = objectLeftXOld.add(objectVisibleWidthOld).divide(BigDecimal.valueOf(2L), ScheduleViewLayoutData.MATH_CONTEXT_DOUBLE_MAXIMUM_PRECISION);
        this.scheduleLayoutData.setScalingUserX(scaling);
        this.scheduleLayoutData.update();
        BigDecimal objectVisibleWidthNew = this.scheduleLayoutData.getObjectVisibleWidth();
        BigDecimal objectLeftNew = BigDecimal.ZERO.max(middleOld.subtract(objectVisibleWidthNew).divide(BigDecimal.valueOf(2L), ScheduleViewLayoutData.MATH_CONTEXT_DOUBLE_MAXIMUM_PRECISION));
        this.setHorizontalBarSelection(objectLeftNew);
        this.scheduleGraphModel.refresh();
    }

    public ScheduleViewModel getScheduleModel() {
        return this.scheduleModel;
    }

    public ScheduleViewLayoutData getScheduleLayoutData() {
        return this.scheduleLayoutData;
    }

    public ScheduleViewGraphModel getScheduleGraphModel() {
        return this.scheduleGraphModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ScheduleViewCanvas scheduleViewCanvas = this;
        synchronized (scheduleViewCanvas) {
            this.scheduleModel.unregisterModelChangeListener();
            super.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redraw() {
        ScheduleViewCanvas scheduleViewCanvas = this;
        synchronized (scheduleViewCanvas) {
            if (!this.isDisposed()) {
                super.redraw();
            }
        }
    }

    public void setDisplayPeriodsSchedulableEntities(boolean displayPeriodsSchedulableEntities) {
        this.displayPeriodsSchedulableEntities = displayPeriodsSchedulableEntities;
    }

    public void setDisplayPeriodsSchedules(boolean displayPeriodsSchedules) {
        this.displayPeriodsSchedules = displayPeriodsSchedules;
    }

    private final class HorizontalScrollBarListener
    implements Listener {
        private final ScrollBar hBar;

        public HorizontalScrollBarListener(ScrollBar hBar) {
            this.hBar = hBar;
        }

        public void handleEvent(Event e) {
            int hSelection = this.hBar.getSelection();
            ScheduleViewCanvas.this.scheduleLayoutData.getDiagramOrigin().x = -hSelection;
            ScheduleViewCanvas.this.redraw();
        }
    }

    private final class KeyListener
    implements org.eclipse.swt.events.KeyListener {
        private KeyListener() {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 27) {
                ScheduleViewCanvas.this.diagramMouseDownX = -1;
                ScheduleViewCanvas.this.redraw();
            }
        }
    }

    private final class MouseClickListener
    extends MouseAdapter {
        private ScheduleViewComposite scheduleViewComposite;

        public MouseClickListener(ScheduleViewComposite scheduleViewComposite) {
            this.scheduleViewComposite = scheduleViewComposite;
        }

        public void mouseDown(MouseEvent e) {
            switch (e.button) {
                case 1: {
                    if (ScheduleViewCanvas.this.scheduleLayoutData.getScalingUserX() >= 10) break;
                    ScheduleViewCanvas.this.diagramMouseDownX = e.x;
                    break;
                }
                case 2: {
                    SubSchedule subSchedule;
                    EObject object;
                    BigDecimal x = ScheduleViewCanvas.this.scheduleLayoutData.diagramSpaceToObjectSpaceX(e.x);
                    BigDecimal y = ScheduleViewCanvas.this.scheduleLayoutData.diagramSpaceToObjectSpaceY(e.y);
                    ScheduleModelElementToDraw findObjectAt = ScheduleViewCanvas.this.scheduleGraphModel.findObjectAt(x, y);
                    if (findObjectAt == null || !((object = findObjectAt.getObject()) instanceof ResourceAllocation) || (subSchedule = ((ResourceAllocation)object).getSubSchedule()) == null) break;
                    ScheduleUIUtils.showSubScheduleView(subSchedule);
                    break;
                }
                case 3: {
                    if (ScheduleViewCanvas.this.scheduleLayoutData.getScalingUserX() <= 1) break;
                    ScheduleViewCanvas.this.setScalingUserX(ScheduleViewCanvas.this.scheduleLayoutData.getScalingUserX() - 1);
                    this.scheduleViewComposite.setScale(ScheduleViewCanvas.this.scheduleLayoutData.getScalingUserX());
                }
            }
            ScheduleViewCanvas.this.redraw();
        }

        public void mouseUp(MouseEvent e) {
            if (ScheduleViewCanvas.this.diagramMouseDownX < 0 || ScheduleViewCanvas.this.scheduleLayoutData.getScalingUserX() == 10) {
                return;
            }
            int diagramEffectiveSelectionLeftX = Math.max(ScheduleViewCanvas.this.scheduleLayoutData.getDiagramLeftX(), ScheduleViewCanvas.this.diagramMouseDownX < ScheduleViewCanvas.this.diagramMouseX ? ScheduleViewCanvas.this.diagramMouseDownX : ScheduleViewCanvas.this.diagramMouseX);
            int diagramEffectiveSelectionRightX = Math.min(ScheduleViewCanvas.this.scheduleLayoutData.getDiagramRightX(), ScheduleViewCanvas.this.diagramMouseDownX < ScheduleViewCanvas.this.diagramMouseX ? ScheduleViewCanvas.this.diagramMouseX : ScheduleViewCanvas.this.diagramMouseDownX);
            int diagramSelectionWidth = diagramEffectiveSelectionRightX - diagramEffectiveSelectionLeftX;
            if (diagramSelectionWidth == 0) {
                ScheduleViewCanvas.this.setScalingUserX(ScheduleViewCanvas.this.scheduleLayoutData.getScalingUserX() + 1);
                this.scheduleViewComposite.setScale(ScheduleViewCanvas.this.scheduleLayoutData.getScalingUserX());
            } else {
                BigDecimal ratioLargerScalingFactor;
                BigDecimal objectSelectionLeftX = ScheduleViewCanvas.this.scheduleLayoutData.diagramSpaceToObjectSpaceX(diagramEffectiveSelectionLeftX);
                int diagramWidth = ScheduleViewCanvas.this.scheduleLayoutData.getDiagramRightX() - ScheduleViewCanvas.this.scheduleLayoutData.getDiagramLeftX();
                BigDecimal objectSelectionWidth = ScheduleViewCanvas.this.scheduleLayoutData.scaleLengthDiagramSpaceToObjectSpaceX(diagramSelectionWidth);
                while ((ratioLargerScalingFactor = this.setScalingUserX(ScheduleViewCanvas.this.scheduleLayoutData.getScalingUserX() + 1, diagramWidth, objectSelectionWidth)).compareTo(BigDecimal.ONE) == -1 && ScheduleViewCanvas.this.scheduleLayoutData.getScalingUserX() < 10) {
                }
                BigDecimal ratioSmallerScalingFactor = this.setScalingUserX(ScheduleViewCanvas.this.scheduleLayoutData.getScalingUserX() - 1, diagramWidth, objectSelectionWidth);
                if (ratioLargerScalingFactor.subtract(BigDecimal.ONE).abs().compareTo(ratioSmallerScalingFactor.subtract(BigDecimal.ONE).abs()) == -1) {
                    this.setScalingUserX(ScheduleViewCanvas.this.scheduleLayoutData.getScalingUserX() + 1, diagramWidth, objectSelectionWidth);
                }
                this.scheduleViewComposite.setScale(ScheduleViewCanvas.this.scheduleLayoutData.getScalingUserX());
                ScheduleViewCanvas.this.setHorizontalBarSelection(objectSelectionLeftX);
            }
            ScheduleViewCanvas.this.diagramMouseDownX = -1;
            ScheduleViewCanvas.this.redraw();
        }

        private BigDecimal setScalingUserX(int scalingUserX, int diagramWidth, BigDecimal objectSelectionWidth) {
            ScheduleViewCanvas.this.setScalingUserX(scalingUserX);
            return ScheduleViewCanvas.this.scheduleLayoutData.scaleLengthDiagramSpaceToObjectSpaceX(diagramWidth).divide(objectSelectionWidth, ScheduleViewLayoutData.MATH_CONTEXT_DOUBLE_MAXIMUM_PRECISION);
        }
    }

    private final class MouseMoveListener
    implements org.eclipse.swt.events.MouseMoveListener {
        private MouseMoveListener() {
        }

        public void mouseMove(MouseEvent e) {
            ScheduleViewCanvas.this.diagramMouseX = e.x;
            ScheduleViewCanvas.this.diagramMouseY = e.y;
            ScheduleViewCanvas.this.redraw();
        }
    }

    private final class PaintListener
    implements org.eclipse.swt.events.PaintListener {
        private PaintListener() {
        }

        public void paintControl(PaintEvent e) {
            if (ScheduleViewCanvas.this.isDisposed() || ScheduleViewCanvas.this.scheduleModel.getSchedules().isEmpty()) {
                return;
            }
            if (ScheduleViewCanvas.this.scheduleGraphModel.update()) {
                ScheduleViewCanvas.this.updateHorizontalBar();
            }
            ScheduleViewCanvas.this.drawCoordinateSystem(e.gc);
            ScheduleViewCanvas.this.scheduleGraphModel.draw(e.gc);
            ScheduleViewCanvas.this.drawToolTip(e.gc);
            ScheduleViewCanvas.this.drawSelection(e.gc);
        }
    }

    private final class ResizeListener
    implements Listener {
        private ResizeListener() {
        }

        public void handleEvent(Event e) {
            ScheduleViewCanvas.this.scheduleGraphModel.refresh();
        }
    }
}

