/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.ganttchartview;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.Schedule;
import org.fortiss.af3.schedule.ui.ganttchartview.ScheduleViewCanvas;
import org.fortiss.af3.schedule.ui.ganttchartview.ScheduleViewModel;
import org.fortiss.af3.schedule.utils.ScheduleUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class ScheduleViewComposite
extends Composite {
    private ScheduleViewCanvas viewer;
    private Scale scale;
    private Spinner numPeriodsSpinner;
    private Button displayPeriodsSchedulableEntitiesCheckBox;
    private Button displayPeriodsSchedules;
    private EObject scheduleContainer;

    public ScheduleViewComposite(Composite parent, int style) {
        super(parent, style);
        this.setParent(parent);
        this.setLayout((Layout)new GridLayout(2, false));
        GridData compositeGd = new GridData(16384, 4, true, true);
        this.setLayoutData(compositeGd);
        Composite settingsComposite = new Composite((Composite)this, 0);
        settingsComposite.setLayout((Layout)new GridLayout(1, false));
        GridData settingsCompositeGd = new GridData(16384, 128, true, true);
        this.setLayoutData(settingsCompositeGd);
        this.viewer = new ScheduleViewCanvas(this, 0);
        this.viewer.setBackground(Display.getCurrent().getSystemColor(1));
        GridData viewerGd = new GridData(4, 4, true, true);
        this.viewer.setLayoutData(viewerGd);
        this.scale = this.createScale(settingsComposite);
        GridData scaleData = new GridData(768);
        this.scale.setLayoutData((Object)scaleData);
        this.numPeriodsSpinner = this.createNumPeriodsSpinner(settingsComposite, this.viewer);
        this.displayPeriodsSchedulableEntitiesCheckBox = this.createDisplayPeriodsCheckBox(settingsComposite, "Display periods of schedulable entities");
        this.displayPeriodsSchedulableEntitiesCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleViewComposite.this.viewer.setDisplayPeriodsSchedulableEntities(ScheduleViewComposite.this.displayPeriodsSchedulableEntitiesCheckBox.getSelection());
                ScheduleViewComposite.this.redrawCanvas();
            }
        });
        this.displayPeriodsSchedules = this.createDisplayPeriodsCheckBox(settingsComposite, "Display periods of schedules");
        this.displayPeriodsSchedules.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleViewComposite.this.viewer.setDisplayPeriodsSchedules(ScheduleViewComposite.this.displayPeriodsSchedules.getSelection());
                ScheduleViewComposite.this.redrawCanvas();
            }
        });
    }

    private Button createDisplayPeriodsCheckBox(Composite settingsComposite, String label) {
        Button checkBox = new Button(settingsComposite, 32);
        checkBox.setText(label);
        checkBox.setSelection(true);
        return checkBox;
    }

    private Spinner createNumPeriodsSpinner(Composite settingsComposite, final ScheduleViewCanvas viewer) {
        Label numPeriodsLabel = new Label(settingsComposite, 0);
        numPeriodsLabel.setText("Number of periods to display");
        final Spinner numPeriodsSpinner = new Spinner(settingsComposite, 2048);
        numPeriodsSpinner.setMinimum(1);
        numPeriodsSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                viewer.getScheduleModel().setNumberOfHyperPeriods(numPeriodsSpinner.getSelection());
                ScheduleViewComposite.this.redrawCanvas();
            }
        });
        return numPeriodsSpinner;
    }

    public Spinner getNumPeriodsSpinner() {
        return this.numPeriodsSpinner;
    }

    private Scale createScale(Composite settingsComposite) {
        Label scaleLabel = new Label(settingsComposite, 0);
        scaleLabel.setText("Scale");
        final Scale scale = new Scale(settingsComposite, 0);
        scale.setMaximum(10);
        scale.setMinimum(1);
        scale.setIncrement(1);
        scale.setSelection(1);
        scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleViewComposite.this.setScale(scale.getSelection());
                ScheduleViewComposite.this.redrawCanvas();
            }
        });
        return scale;
    }

    public Scale getScale() {
        return this.scale;
    }

    public void setScale(int userScale) {
        int userScaleEffective = Math.min(Math.max(0, userScale), 10);
        this.scale.setSelection(userScaleEffective);
        this.scale.setToolTipText("" + userScaleEffective);
        this.viewer.setScalingUserX(userScaleEffective);
    }

    public void redrawCanvas() {
        if (!this.viewer.isDisposed()) {
            this.viewer.redraw();
            BigDecimal majorFrame = this.viewer.getScheduleModel().getMajorFrame();
            boolean hasPeriods = majorFrame != null && majorFrame.compareTo(BigDecimal.ZERO) != 0;
            this.numPeriodsSpinner.setEnabled(hasPeriods);
            this.displayPeriodsSchedulableEntitiesCheckBox.setEnabled(hasPeriods);
            this.displayPeriodsSchedules.setEnabled(hasPeriods);
        }
    }

    public void setSchedule(EObject scheduleContainer, final List<Schedule> schedules, final BigDecimal majorFrame) {
        this.scheduleContainer = scheduleContainer;
        this.viewer.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ScheduleViewModel scheduleModel = ScheduleViewComposite.this.viewer.getScheduleModel();
                if (schedules != null) {
                    scheduleModel.setSchedule(schedules.stream().sorted((schedule1, schedule2) -> schedule1.getName().compareTo(schedule2.getName())).collect(Collectors.toList()), majorFrame);
                    scheduleModel.setSchedulableEntityPeriods(ScheduleViewComposite.this.getSchedulableEntityPeriods(majorFrame));
                    scheduleModel.setResourceSchedulePeriods(ScheduleViewComposite.this.getResourceSchedulePeriods(majorFrame));
                    ScheduleViewComposite.this.redrawCanvas();
                }
            }
        });
    }

    private List<BigDecimal> getSchedulableEntityPeriods(BigDecimal majorFrame) {
        if (this.scheduleContainer == null) {
            return Collections.emptyList();
        }
        TreeSet<BigDecimal> periods = new TreeSet<BigDecimal>();
        for (ResourceAllocation ra : EcoreUtils.getChildrenWithType((EObject)this.scheduleContainer, ResourceAllocation.class)) {
            BigDecimal period = ScheduleUtils.getPeriod((ResourceAllocation)ra);
            this.unfoldPeriod(periods, period, majorFrame);
        }
        BigDecimal[] periodsArray = new BigDecimal[periods.size()];
        periods.toArray(periodsArray);
        return Arrays.asList(periodsArray);
    }

    private List<BigDecimal> getResourceSchedulePeriods(BigDecimal majorFrame) {
        if (this.scheduleContainer == null) {
            return Collections.emptyList();
        }
        TreeSet<BigDecimal> periods = new TreeSet<BigDecimal>();
        for (Schedule ra : EcoreUtils.getChildrenWithType((EObject)this.scheduleContainer, Schedule.class)) {
            BigDecimal period = ScheduleUtils.getHyperPeriod((Schedule)ra);
            this.unfoldPeriod(periods, period, majorFrame);
        }
        BigDecimal[] periodsArray = new BigDecimal[periods.size()];
        periods.toArray(periodsArray);
        return Arrays.asList(periodsArray);
    }

    private void unfoldPeriod(Set<BigDecimal> periods, BigDecimal period, BigDecimal majorFrame) {
        if (period != null && period.compareTo(BigDecimal.ZERO) == 1) {
            BigDecimal p = period;
            while (p.compareTo(majorFrame) <= 0) {
                periods.add(p);
                p = p.add(period);
            }
        }
    }
}

