/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.ganttchartview;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.ResourceAllocationFragment;
import org.fortiss.af3.schedule.model.Schedule;
import org.fortiss.af3.schedule.ui.ganttchartview.AbstractObjectToDraw;
import org.fortiss.af3.schedule.ui.ganttchartview.LabelToDraw;
import org.fortiss.af3.schedule.ui.ganttchartview.LineToDraw;
import org.fortiss.af3.schedule.ui.ganttchartview.ScheduleModelElementToDraw;
import org.fortiss.af3.schedule.ui.ganttchartview.ScheduleViewCanvas;
import org.fortiss.af3.schedule.ui.ganttchartview.ScheduleViewColors;
import org.fortiss.af3.schedule.ui.ganttchartview.ScheduleViewLayoutData;
import org.fortiss.af3.schedule.ui.ganttchartview.ScheduleViewModel;
import org.fortiss.af3.schedule.utils.ScheduleUtils;

public class ScheduleViewGraphModel {
    private Map<EObject, Color> objectToColor = new HashMap<EObject, Color>();
    private List<AbstractObjectToDraw> graphElementList = new ArrayList<AbstractObjectToDraw>();
    private boolean graphElementListIsUpToDate;
    private ScheduleViewCanvas canvas;

    public ScheduleViewGraphModel(ScheduleViewCanvas canvas) {
        this.canvas = canvas;
    }

    public ScheduleModelElementToDraw findObjectAt(BigDecimal x, BigDecimal y) {
        ScheduleViewModel scheduleModel = this.canvas.getScheduleModel();
        for (AbstractObjectToDraw object : this.graphElementList) {
            if (!(object instanceof ScheduleModelElementToDraw) || object.getStartingPoint_Y() != y) continue;
            int period = 0;
            while (period < scheduleModel.getNumberOfHyperPeriods()) {
                BigDecimal multiply = BigDecimal.valueOf(period).multiply(scheduleModel.getScheduleLength());
                BigDecimal objectX = object.getStartingPoint_X().add(multiply);
                if (x.compareTo(objectX) >= 0 && x.compareTo(objectX.add(object.getWidth())) <= 0) {
                    return (ScheduleModelElementToDraw)object;
                }
                ++period;
            }
        }
        return null;
    }

    public boolean update() {
        if (this.graphElementListIsUpToDate) {
            return false;
        }
        this.graphElementListIsUpToDate = true;
        this.canvas.getScheduleLayoutData().update();
        ScheduleViewModel scheduleModel = this.canvas.getScheduleModel();
        int y = 0;
        this.graphElementList.clear();
        this.objectToColor.clear();
        for (Schedule schedule : scheduleModel.getSchedules()) {
            LabelToDraw label = LabelToDraw.createLabel(schedule, y, 150, ScheduleViewColors.getColor(0), this.objectToColor);
            if (label != null) {
                this.graphElementList.add(label);
            }
            BigDecimal roundOffset = BigDecimal.ZERO;
            BigDecimal schedulePeriod = ScheduleUtils.getHyperPeriod((Schedule)schedule);
            boolean isPeriodSet = schedulePeriod != null && schedulePeriod.compareTo(BigDecimal.ZERO) == 1;
            while (!isPeriodSet || roundOffset.compareTo(scheduleModel.getScheduleLength()) == -1) {
                for (ResourceAllocation resourceAllocation : schedule.getResourceAllocationList()) {
                    Color color = ScheduleViewColors.getColor(resourceAllocation, this.objectToColor);
                    if (color == null) continue;
                    if (resourceAllocation.getFragments().isEmpty()) {
                        ScheduleModelElementToDraw object = ScheduleModelElementToDraw.createScheduleModelElement(resourceAllocation, roundOffset, y, color);
                        if (object == null) continue;
                        this.graphElementList.add(object);
                        continue;
                    }
                    for (ResourceAllocationFragment fragment : resourceAllocation.getFragments()) {
                        ScheduleModelElementToDraw object = ScheduleModelElementToDraw.createScheduleModelElement(fragment, roundOffset, y, color);
                        if (object == null) continue;
                        this.graphElementList.add(object);
                    }
                }
                if (!isPeriodSet) break;
                roundOffset = roundOffset.add(schedulePeriod);
            }
            ++y;
        }
        return true;
    }

    public void draw(GC gc) {
        ScheduleViewLayoutData scheduleLayoutData = this.canvas.getScheduleLayoutData();
        ScheduleViewModel scheduleModel = this.canvas.getScheduleModel();
        Display display = this.canvas.getDisplay();
        Color colorWhite = display.getSystemColor(1);
        Color colorRed = display.getSystemColor(4);
        Color colorBlack = display.getSystemColor(2);
        Rectangle clientArea = this.canvas.getClientArea();
        Font font = this.canvas.getFont();
        gc.setBackground(colorWhite);
        gc.setForeground(colorBlack);
        for (AbstractObjectToDraw object : this.graphElementList) {
            if (object instanceof LineToDraw) {
                LineToDraw.drawLine(gc, (LineToDraw)object, colorRed, colorWhite, colorBlack, scheduleLayoutData);
            }
            int period = 0;
            while (period < scheduleModel.getNumberOfHyperPeriods()) {
                BigDecimal startingPoint_Y = object.getStartingPoint_Y();
                int diagramHeight = scheduleLayoutData.getDiagramHeightOfSchedule();
                BigDecimal multiply = BigDecimal.valueOf(diagramHeight).multiply(startingPoint_Y);
                int intValue = multiply.setScale(0, RoundingMode.HALF_UP).intValue();
                int y = 50 + intValue;
                int height = Math.max(1, diagramHeight - 2);
                if (object instanceof LabelToDraw && period == 0) {
                    int x = scheduleLayoutData.getDiagramOrigin().x;
                    int intValue2 = object.getWidth().setScale(0, RoundingMode.HALF_UP).intValue();
                    LabelToDraw.drawLabel(gc, (LabelToDraw)object, x, y, intValue2, height, font);
                } else if (object instanceof ScheduleModelElementToDraw) {
                    int width;
                    BigDecimal majorFrame = scheduleModel.getScheduleLength();
                    BigDecimal startingPoint_X = object.getStartingPoint_X();
                    BigDecimal add = BigDecimal.valueOf(period).multiply(majorFrame).add(startingPoint_X);
                    int x = scheduleLayoutData.objectSpaceToDiagramSpaceX(add);
                    if (x + (width = scheduleLayoutData.scaleLengthObjectSpaceToDiagramSpaceX(object.getWidth())) >= 0 && x <= clientArea.width) {
                        ScheduleModelElementToDraw.drawScheduleModelElement(gc, (ScheduleModelElementToDraw)object, x, y, width, clientArea.width, height, font);
                    }
                }
                ++period;
            }
        }
        gc.setBackground(colorWhite);
        gc.setForeground(colorBlack);
    }

    public void refresh() {
        this.graphElementListIsUpToDate = false;
        this.canvas.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ScheduleViewGraphModel.this.canvas.redraw();
            }
        });
    }
}

