/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.ganttchartview;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.Schedule;
import org.fortiss.af3.schedule.ui.ganttchartview.ScheduleViewCanvas;
import org.fortiss.af3.schedule.utils.ScheduleUtils;

public class ScheduleViewModel {
    private ScheduleViewCanvas canvas;
    private EContentAdapter modelChangeListener = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (!notification.isTouch() && notification.getEventType() != 8) {
                ScheduleViewModel.this.canvas.getScheduleGraphModel().refresh();
            }
        }
    };
    private List<Schedule> schedules = Collections.emptyList();
    private BigDecimal majorFrame;
    private BigDecimal scheduleLength;
    private int numberOfHyperPeriods = 1;
    private List<BigDecimal> schedulableEntityPeriods = Collections.emptyList();
    private List<BigDecimal> resourceSchedulePeriods = Collections.emptyList();

    public ScheduleViewModel(ScheduleViewCanvas canvas) {
        this.canvas = canvas;
    }

    public List<Schedule> getSchedules() {
        return this.schedules;
    }

    public BigDecimal getMajorFrame() {
        return this.majorFrame;
    }

    public BigDecimal getScheduleLength() {
        if (this.scheduleLength != null) {
            return this.scheduleLength;
        }
        if (this.majorFrame == null || this.majorFrame.compareTo(BigDecimal.ZERO) == 0) {
            BinaryOperator max = (a, b) -> a.compareTo((BigDecimal)b) >= 0 ? a : b;
            Function<ResourceAllocation, BigDecimal> phase = r -> {
                BigDecimal p = ScheduleUtils.getPhase((ResourceAllocation)r);
                return p != null ? p : BigDecimal.ZERO;
            };
            Function<ResourceAllocation, BigDecimal> duration = r -> {
                BigDecimal d = r.getDuration();
                return d != null ? d : BigDecimal.ZERO;
            };
            this.scheduleLength = this.getSchedules().stream().map(s -> s.getResourceAllocationList().stream().map(r -> ((BigDecimal)phase.apply((ResourceAllocation)r)).add((BigDecimal)duration.apply((ResourceAllocation)r))).reduce(max).orElse(BigDecimal.ZERO)).reduce(max).orElse(BigDecimal.ZERO);
        } else {
            this.scheduleLength = this.majorFrame;
        }
        return this.scheduleLength;
    }

    public void setSchedule(List<Schedule> schedules, BigDecimal majorFrame) {
        if (schedules == null && this.schedules == null || schedules != null && this.schedules != null && schedules.equals(this.schedules) && majorFrame.equals(this.majorFrame)) {
            return;
        }
        this.unregisterModelChangeListener();
        this.schedules = schedules != null ? schedules : Collections.emptyList();
        this.registerModelChangeListener();
        this.majorFrame = majorFrame;
        this.canvas.getScheduleGraphModel().refresh();
    }

    public void setNumberOfHyperPeriods(int numberOfHyperPeriods) {
        if (numberOfHyperPeriods == this.numberOfHyperPeriods) {
            return;
        }
        this.numberOfHyperPeriods = numberOfHyperPeriods;
        this.canvas.getScheduleGraphModel().refresh();
    }

    public int getNumberOfHyperPeriods() {
        return this.numberOfHyperPeriods;
    }

    public List<BigDecimal> getSchedulableEntityPeriods() {
        return this.schedulableEntityPeriods;
    }

    public void setSchedulableEntityPeriods(List<BigDecimal> schedulableEntityPeriods) {
        this.schedulableEntityPeriods = schedulableEntityPeriods;
    }

    public List<BigDecimal> getResourceSchedulePeriods() {
        return this.resourceSchedulePeriods;
    }

    public void setResourceSchedulePeriods(List<BigDecimal> resourceSchedulePeriods) {
        this.resourceSchedulePeriods = resourceSchedulePeriods;
    }

    private void registerModelChangeListener() {
        for (Schedule schedule : this.schedules) {
            schedule.eAdapters().add((Object)this.modelChangeListener);
        }
    }

    public void unregisterModelChangeListener() {
        for (Schedule schedule : this.schedules) {
            schedule.eAdapters().remove((Object)this.modelChangeListener);
        }
    }
}

