/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.ganttchartview.fx;

import java.math.BigDecimal;
import java.util.Map;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.schedule.model.ResourceSchedule;
import org.fortiss.af3.schedule.model.Schedule;
import org.fortiss.af3.schedule.model.SubSchedule;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.AbstractObjectToDrawFX;
import org.fortiss.af3.schedule.ui.utils.ScheduleViewUtilsFX;
import org.fortiss.tooling.kernel.model.INamedElement;

public class LabelToDrawFX
extends AbstractObjectToDrawFX {
    private String labelName;

    public LabelToDrawFX(BigDecimal startingPoint_x, BigDecimal startingPoint_y, BigDecimal width, boolean withBorder, Color color, String labelName) {
        super(startingPoint_x, startingPoint_y, width, withBorder, color);
        this.labelName = labelName;
    }

    @Override
    public String getName() {
        return this.labelName;
    }

    public static void drawLabel(GraphicsContext gc, LabelToDrawFX label, int x, int y, int width, int height, Font font) {
        ScheduleViewUtilsFX.drawSubscriptedCaptionCentered(label.getName(), "", new Rectangle((double)x, (double)y, (double)width, (double)height), gc, font, font);
    }

    public static LabelToDrawFX createLabel(Schedule schedule, int y, int width, Color color, Map<EObject, Color> objectToColor) {
        Object labelString;
        Schedule resource = null;
        if (schedule instanceof ResourceSchedule) {
            ResourceSchedule resSched = (ResourceSchedule)schedule;
            resource = (INamedElement)resSched.getResource();
            labelString = resource.getName();
            if (resource instanceof ExecutionUnit) {
                long frequency = resSched.getFrequency();
                labelString = (String)labelString + " [fr: " + frequency + "]";
            }
        } else if (schedule instanceof SubSchedule) {
            resource = schedule;
            labelString = resource.getName();
        } else {
            throw new UnknownError("Unknown schedule " + String.valueOf(schedule.getClass()));
        }
        objectToColor.put((EObject)resource, color);
        return new LabelToDrawFX(BigDecimal.ZERO, BigDecimal.valueOf(y), BigDecimal.valueOf(width), false, color, (String)labelString);
    }
}

