/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.ganttchartview.fx;

import java.math.BigDecimal;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.AbstractObjectToDrawFX;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.ScheduleViewLayoutDataFX;

public class LineToDrawFX
extends AbstractObjectToDrawFX {
    private boolean isHorizontal;
    private String label;

    public LineToDrawFX(BigDecimal startingPoint_x, BigDecimal startingPoint_y, BigDecimal length, boolean isHorizontal, Color color, String label) {
        super(startingPoint_x, startingPoint_y, length, false, color);
        this.isHorizontal = isHorizontal;
        this.label = label;
    }

    @Override
    public String getName() {
        return this.label;
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    public static void drawLine(GraphicsContext gc, LineToDrawFX line, Color color1, Color color2, ScheduleViewLayoutDataFX layoutData) {
        int yLabel;
        int xLabel;
        int y2;
        int x2;
        int x = layoutData.objectSpaceToDiagramSpaceX(line.getStartingPoint_X());
        int y = layoutData.objectSpaceToDiagramSpaceY(line.getStartingPoint_Y());
        int width = layoutData.scaleLengthObjectSpaceToDiagramSpaceX(line.getWidth());
        gc.setFill((Paint)color1);
        if (line.isHorizontal()) {
            x2 = x + width;
            y2 = y;
            xLabel = x + width / 2;
            yLabel = y - 10;
        } else {
            x2 = x;
            y2 = y + width;
            xLabel = x;
            yLabel = y + width / 2;
        }
        double lineWidth = gc.getLineWidth();
        gc.setLineWidth(lineWidth + 2.0);
        gc.beginPath();
        gc.moveTo((double)x, (double)y);
        gc.lineTo((double)x2, (double)y2);
        gc.stroke();
        gc.setFill((Paint)Color.BLACK);
        gc.fillText(line.getName(), (double)xLabel, (double)yLabel);
        gc.setFill((Paint)color2);
        gc.setLineWidth(lineWidth);
    }
}

