/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.ganttchartview.fx;

import java.math.BigDecimal;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.ResourceAllocationFragment;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.AbstractObjectToDrawFX;
import org.fortiss.af3.schedule.ui.utils.ScheduleViewUtilsFX;
import org.fortiss.af3.schedule.utils.ScheduleUtils;
import org.fortiss.tooling.kernel.model.INamedElement;

public class ScheduleModelElementToDrawFX
extends AbstractObjectToDrawFX {
    private EObject object;

    public ScheduleModelElementToDrawFX(EObject object, BigDecimal startingPoint_x, BigDecimal startingPoint_y, BigDecimal width, boolean withBorder, Color color) {
        super(startingPoint_x, startingPoint_y, width, withBorder, color);
        this.object = object;
    }

    public EObject getObject() {
        return this.object;
    }

    @Override
    public String getName() {
        if (this.object instanceof INamedElement) {
            return ((INamedElement)this.object).getName();
        }
        return this.object.toString();
    }

    public static void drawScheduleModelElement(GraphicsContext gc, ScheduleModelElementToDrawFX scheduleModelElement, int x, int y, int width, int maxWidth, int height, Font font) {
        int x2 = x + width;
        x = Math.max(x, -1);
        width = Math.max(Math.min(x2 - x, maxWidth), 1);
        Rectangle rectangle = new Rectangle((double)x, (double)y, (double)width, (double)height);
        if (scheduleModelElement.hasBorder()) {
            gc.setGlobalAlpha(0.7450980544090271);
            gc.setFill((Paint)scheduleModelElement.getColor());
            gc.fillRect((double)x, (double)y, (double)width, (double)height);
            gc.setGlobalAlpha(1.0);
            gc.setStroke((Paint)Color.BLACK);
            gc.strokeRect((double)x, (double)y, (double)width, (double)height);
        }
        ScheduleViewUtilsFX.drawSubscriptedCaptionCentered(scheduleModelElement.getName(), "", rectangle, gc, font, font);
        BigDecimal period = null;
        ResourceAllocation ra = null;
        EObject object2 = scheduleModelElement.getObject();
        if (object2 instanceof ResourceAllocation) {
            ra = (ResourceAllocation)object2;
        } else if (object2 instanceof ResourceAllocationFragment) {
            ra = (ResourceAllocation)object2.eContainer();
        }
        period = ScheduleUtils.getPeriod((ResourceAllocation)ra);
        if (period != null && period.compareTo(BigDecimal.ZERO) != 0) {
            String periodLabel = "p=" + String.valueOf(period);
            double lineHeight = gc.getFont().getSize();
            if (3.0 * lineHeight < (double)height) {
                ScheduleViewUtilsFX.drawInfoLabel(gc, periodLabel, rectangle);
            }
        }
    }

    public static ScheduleModelElementToDrawFX createScheduleModelElement(ResourceAllocation resourceAllocation, BigDecimal roundOffset, int y, Color color) {
        BigDecimal phase = ScheduleUtils.getPhase((ResourceAllocation)resourceAllocation);
        if (phase == null) {
            phase = BigDecimal.ZERO;
        }
        if (resourceAllocation.getDuration() == null) {
            return null;
        }
        return new ScheduleModelElementToDrawFX((EObject)resourceAllocation, roundOffset.add(phase), BigDecimal.valueOf(y), resourceAllocation.getDuration(), true, color);
    }

    public static ScheduleModelElementToDrawFX createScheduleModelElement(ResourceAllocationFragment fragment, BigDecimal roundOffset, int y, Color color) {
        BigDecimal phase = ScheduleUtils.getPhase((ResourceAllocationFragment)fragment);
        if (phase == null) {
            return null;
        }
        if (fragment.getDuration() == null) {
            return null;
        }
        return new ScheduleModelElementToDrawFX((EObject)fragment, roundOffset.add(phase), BigDecimal.valueOf(y), fragment.getDuration(), true, color);
    }
}

