/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.schedule.ui.ganttchartview.fx;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ScrollBar;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.schedule.model.ResourceAllocation;
import org.fortiss.af3.schedule.model.SubSchedule;
import org.fortiss.af3.schedule.ui.ganttchartview.ScheduleViewLayoutData;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.ScheduleModelElementToDrawFX;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.ScheduleViewCompositeFX;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.ScheduleViewGraphModelFX;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.ScheduleViewLayoutDataFX;
import org.fortiss.af3.schedule.ui.ganttchartview.fx.ScheduleViewModelFX;
import org.fortiss.af3.schedule.ui.utils.ScheduleUIUtils;
import org.fortiss.af3.schedule.ui.utils.ScheduleViewUtilsFX;
import org.fortiss.af3.schedule.utils.MathUtils;

public class ScheduleViewCanvasFX {
    private ScheduleViewModelFX scheduleModel;
    private static final int DIAGRAM_TOOLTIP_OFFSET_X = 20;
    private static final int DIAGRAM_TOOLTIP_PADDING = 5;
    public static final int DIAGRAM_COORDINATE_SYSTEM_EXTRA_LINE_LENGTH = 5;
    private ScheduleViewLayoutDataFX scheduleLayoutData;
    private ScheduleViewGraphModelFX scheduleGraphModel;
    private int diagramMouseX;
    private int diagramMouseY;
    private int diagramMouseDownX = -1;
    private boolean displayPeriodsSchedulableEntities = true;
    private boolean displayPeriodsSchedules = true;
    private Canvas canvas;
    private ScrollBar scrollBar;
    private ScheduleViewCompositeFX composite;
    ScheduleModelElementToDrawFX mouseOverTarget = null;

    public ScheduleViewCanvasFX(ScheduleViewCompositeFX composite, Canvas canvas, ScrollBar scrollBar) {
        this.composite = composite;
        this.canvas = canvas;
        this.scrollBar = scrollBar;
        this.scheduleModel = new ScheduleViewModelFX(this);
        this.scheduleLayoutData = new ScheduleViewLayoutDataFX(this);
        this.scheduleGraphModel = new ScheduleViewGraphModelFX(this);
        scrollBar.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                ScheduleViewCanvasFX.this.scheduleLayoutData.getDiagramOrigin().x = -newValue.intValue();
                ScheduleViewCanvasFX.this.repaint();
            }
        });
    }

    public void repaint() {
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        if (this.scheduleModel.getSchedules().isEmpty()) {
            return;
        }
        if (this.scheduleGraphModel.update()) {
            this.updateHorizontalBar();
        }
        gc.setFill((Paint)Color.WHITE);
        gc.fillRect(0.0, 0.0, this.getBounds().getWidth(), this.getBounds().getHeight());
        this.drawCoordinateSystem(gc);
        this.scheduleGraphModel.draw(gc);
        this.drawToolTip(gc);
        this.drawSelection(gc);
    }

    private void updateHorizontalBar() {
        Bounds client = this.getBounds();
        double pageWidth = Math.min((double)this.scheduleLayoutData.getDiagramWidthOfGraph(), client.getWidth());
        this.scrollBar.setMax((double)this.scheduleLayoutData.getDiagramWidthOfGraph() - client.getWidth());
        this.scrollBar.setVisibleAmount(pageWidth / 2.0);
        double hPage = (double)this.scheduleLayoutData.getDiagramWidthOfGraph() - client.getWidth();
        int hSelection = (int)this.scrollBar.getValue();
        if ((double)hSelection >= hPage) {
            if (hPage <= 0.0) {
                hSelection = 0;
            }
            this.scheduleLayoutData.getDiagramOrigin().x = -hSelection;
        }
    }

    private void setHorizontalBarSelection(BigDecimal objectSelectionX) {
        this.scheduleLayoutData.update();
        this.updateHorizontalBar();
        int diagramSelectionX = this.scheduleLayoutData.scaleLengthObjectSpaceToDiagramSpaceX(objectSelectionX) + 20 + 150;
        this.scrollBar.setValue((double)diagramSelectionX + this.scrollBar.getVisibleAmount() / 2.0);
        this.scheduleLayoutData.getDiagramOrigin().x = -((int)Math.min((double)diagramSelectionX + this.scrollBar.getVisibleAmount() / 2.0, this.scrollBar.getMax()));
    }

    public Bounds getBounds() {
        return this.canvas.getBoundsInLocal();
    }

    private void drawToolTip(GraphicsContext gc) {
        if (this.mouseOverTarget != null) {
            Object toolTipText = this.mouseOverTarget.getName();
            Text textField = new Text((String)toolTipText);
            textField.setFont(gc.getFont());
            double singleLineHeight = textField.getLayoutBounds().getHeight();
            toolTipText = (String)toolTipText + "\nstart: " + String.valueOf(ScheduleViewUtilsFX.getPhase(this.mouseOverTarget));
            toolTipText = (String)toolTipText + "\nduration: " + String.valueOf(ScheduleViewUtilsFX.getDuration(this.mouseOverTarget));
            textField = new Text((String)toolTipText);
            textField.setFont(gc.getFont());
            Bounds area = textField.getLayoutBounds();
            gc.setFill((Paint)Color.WHITE);
            gc.fillRect((double)(this.diagramMouseX + 20 - 5), (double)this.diagramMouseY - singleLineHeight, area.getWidth() + 10.0, area.getHeight() + 5.0);
            gc.setStroke((Paint)Color.BLACK);
            gc.strokeRect((double)(this.diagramMouseX + 20 - 5), (double)this.diagramMouseY - singleLineHeight, area.getWidth() + 10.0, area.getHeight() + 5.0);
            gc.setFill((Paint)Color.BLACK);
            gc.fillText((String)toolTipText, (double)(this.diagramMouseX + 20), (double)this.diagramMouseY);
        }
    }

    private void drawSelection(GraphicsContext gc) {
        if (this.diagramMouseDownX > 0) {
            int x = this.diagramMouseDownX < this.diagramMouseX ? this.diagramMouseDownX : this.diagramMouseX;
            int width = Math.abs(this.diagramMouseDownX - this.diagramMouseX);
            gc.setGlobalAlpha(0.5);
            gc.setFill((Paint)Color.BLUE);
            gc.fillRect((double)x, 0.0, (double)width, (double)((int)this.getBounds().getHeight()));
            gc.setGlobalAlpha(1.0);
        }
    }

    private int getHorizontalLineY(int i) {
        return (int)((double)(50 + i * this.scheduleLayoutData.getDiagramHeightOfSchedule()) - 1.0);
    }

    private void drawCoordinateSystem(GraphicsContext gc) {
        Bounds clientArea = this.getBounds();
        int marginWidth = (int)(clientArea.getWidth() - (double)this.scheduleLayoutData.getDiagramWidthOfGraph());
        if (marginWidth > 0) {
            gc.setFill((Paint)Color.WHITE);
            gc.fillRect((double)this.scheduleLayoutData.getDiagramWidthOfGraph(), 0.0, (double)marginWidth, clientArea.getWidth());
            gc.setFill((Paint)Color.BLACK);
        }
        gc.setStroke((Paint)Color.BLACK);
        gc.beginPath();
        int diagramX = this.scheduleLayoutData.objectSpaceToDiagramSpaceX(BigDecimal.ZERO);
        int diagramY = this.getHorizontalLineY(this.scheduleModel.getSchedules().size());
        int diagramY2 = 50;
        gc.moveTo((double)diagramX, (double)(diagramY + 10));
        gc.lineTo((double)diagramX, (double)diagramY2);
        BigDecimal scheduleLength = this.scheduleModel.getScheduleLength();
        BigDecimal numHyperPeriods = BigDecimal.valueOf(this.scheduleModel.getNumberOfHyperPeriods());
        int diagramX2 = diagramX + this.scheduleLayoutData.scaleLengthObjectSpaceToDiagramSpaceX(scheduleLength.multiply(numHyperPeriods));
        diagramX = Math.max(diagramX, 0);
        diagramX2 = (int)Math.min((double)diagramX2, clientArea.getWidth());
        gc.moveTo((double)(diagramX - 10), (double)diagramY);
        gc.lineTo((double)diagramX2, (double)diagramY);
        gc.stroke();
        gc.beginPath();
        gc.setStroke((Paint)Color.LIGHTGRAY);
        gc.setFill((Paint)Color.LIGHTGRAY);
        int i = 1;
        while (i < this.scheduleModel.getSchedules().size()) {
            int diagramHorizotalLineY = this.getHorizontalLineY(i);
            gc.moveTo((double)(diagramX - 5), (double)diagramHorizotalLineY);
            gc.lineTo((double)(diagramX2 + 5), (double)diagramHorizotalLineY);
            ++i;
        }
        gc.stroke();
        BigDecimal modelLabelInterval_bd = this.scheduleLayoutData.getModelLabelInterval();
        BigDecimal modelStartCoordinateLabel = this.scheduleLayoutData.scaleLengthDiagramSpaceToObjectSpaceX(-this.scheduleLayoutData.getDiagramOrigin().x).divide(modelLabelInterval_bd, ScheduleViewLayoutData.MATH_CONTEXT_DOUBLE_MAXIMUM_PRECISION).setScale(0, RoundingMode.FLOOR).multiply(modelLabelInterval_bd);
        BigDecimal modelEndCoordinateLabel = numHyperPeriods.multiply(scheduleLength).min(this.scheduleLayoutData.scaleLengthDiagramSpaceToObjectSpaceX((int)(clientArea.getWidth() - (double)this.scheduleLayoutData.getDiagramOrigin().x)));
        DecimalFormat df = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.ROOT));
        int decimals = MathUtils.getPrecision((BigDecimal)this.scheduleLayoutData.getModelLabelInterval(), (int)6);
        df.setMaximumFractionDigits(decimals);
        df.setMinimumFractionDigits(decimals);
        df.setGroupingUsed(false);
        gc.setStroke((Paint)Color.BLACK);
        gc.setFill((Paint)Color.BLACK);
        gc.beginPath();
        BigDecimal i2 = modelStartCoordinateLabel;
        while (i2.compareTo(modelEndCoordinateLabel) < 1) {
            int diagramLabelX = this.scheduleLayoutData.objectSpaceToDiagramSpaceX(i2);
            gc.moveTo((double)diagramLabelX, 45.0);
            gc.lineTo((double)diagramLabelX, (double)(diagramY + 15));
            gc.fillText(df.format(i2.setScale(5, RoundingMode.DOWN)), (double)diagramLabelX, (double)(diagramY + 15));
            i2 = i2.add(modelLabelInterval_bd);
        }
        gc.stroke();
        BigDecimal majorFrame = this.scheduleModel.getMajorFrame();
        if (majorFrame == null || majorFrame.compareTo(BigDecimal.ZERO) == 0) {
            double lineWidth = gc.getLineWidth();
            gc.setLineWidth(lineWidth + 3.0);
            gc.setStroke((Paint)Color.RED);
            gc.setFill((Paint)Color.BLACK);
            gc.beginPath();
            int i3 = 0;
            while (i3 < this.scheduleModel.getNumberOfHyperPeriods()) {
                diagramX = this.scheduleLayoutData.objectSpaceToDiagramSpaceX(BigDecimal.valueOf(i3 + 1).multiply(scheduleLength));
                if (this.displayPeriodsSchedulableEntities) {
                    this.drawPeriods(this.scheduleModel.getSchedulableEntityPeriods(), gc, Color.BLACK, i3, diagramY);
                }
                if (this.displayPeriodsSchedules) {
                    this.drawPeriods(this.scheduleModel.getResourceSchedulePeriods(), gc, Color.BLUE, i3, diagramY);
                }
                gc.moveTo((double)diagramX, 25.0);
                gc.lineTo((double)diagramX, (double)(diagramY + 40));
                gc.fillText("Round " + (i3 + 1), (double)(diagramX + 5), (double)(diagramY + 40 - 15));
                ++i3;
            }
            gc.stroke();
            gc.setLineWidth(lineWidth);
        }
    }

    private void drawPeriods(List<BigDecimal> periods, GraphicsContext gc, Color color, int round, int offsetY) {
        gc.beginPath();
        for (BigDecimal period : periods) {
            gc.setStroke((Paint)color);
            int diagramPeriodX = this.scheduleLayoutData.objectSpaceToDiagramSpaceX(period.add(BigDecimal.valueOf(round).multiply(this.scheduleModel.getScheduleLength())));
            gc.moveTo((double)diagramPeriodX, 45.0);
            gc.lineTo((double)diagramPeriodX, (double)(offsetY + 5));
            gc.setFill((Paint)Color.BLACK);
            gc.fillText(String.valueOf(MathUtils.round((BigDecimal)period, (int)6)), (double)diagramPeriodX, (double)(offsetY + 5));
        }
        gc.stroke();
    }

    public void setScalingUserX(int scaling) {
        if (scaling == this.scheduleLayoutData.getScalingUserX()) {
            return;
        }
        int diagramLeftXOld = this.scheduleLayoutData.getDiagramLeftX();
        BigDecimal objectLeftXOld = this.scheduleLayoutData.diagramSpaceToObjectSpaceX(diagramLeftXOld);
        BigDecimal objectVisibleWidthOld = this.scheduleLayoutData.getObjectVisibleWidth();
        BigDecimal middleOld = objectLeftXOld.add(objectVisibleWidthOld).divide(BigDecimal.valueOf(2L), ScheduleViewLayoutData.MATH_CONTEXT_DOUBLE_MAXIMUM_PRECISION);
        this.scheduleLayoutData.setScalingUserX(scaling);
        this.scheduleLayoutData.update();
        BigDecimal objectVisibleWidthNew = this.scheduleLayoutData.getObjectVisibleWidth();
        BigDecimal objectLeftNew = BigDecimal.ZERO.max(middleOld.subtract(objectVisibleWidthNew).divide(BigDecimal.valueOf(2L), ScheduleViewLayoutData.MATH_CONTEXT_DOUBLE_MAXIMUM_PRECISION));
        this.setHorizontalBarSelection(objectLeftNew);
        this.scheduleGraphModel.refresh();
    }

    public ScheduleViewModelFX getScheduleModel() {
        return this.scheduleModel;
    }

    public ScheduleViewLayoutDataFX getScheduleLayoutData() {
        return this.scheduleLayoutData;
    }

    public ScheduleViewGraphModelFX getScheduleGraphModel() {
        return this.scheduleGraphModel;
    }

    public void setDisplayPeriodsSchedulableEntities(boolean displayPeriodsSchedulableEntities) {
        this.displayPeriodsSchedulableEntities = displayPeriodsSchedulableEntities;
    }

    public void setDisplayPeriodsSchedules(boolean displayPeriodsSchedules) {
        this.displayPeriodsSchedules = displayPeriodsSchedules;
    }

    public void mouseMoved(int x, int y, boolean isDrag) {
        BigDecimal object_y;
        this.diagramMouseX = x;
        this.diagramMouseY = y;
        BigDecimal object_x = this.scheduleLayoutData.diagramSpaceToObjectSpaceX(this.diagramMouseX);
        ScheduleModelElementToDrawFX object = this.scheduleGraphModel.findObjectAt(object_x, object_y = this.scheduleLayoutData.diagramSpaceToObjectSpaceY(this.diagramMouseY));
        if (object != this.mouseOverTarget || isDrag) {
            this.mouseOverTarget = object;
            this.repaint();
        }
    }

    private BigDecimal setScalingUserX(int scalingUserX, int diagramWidth, BigDecimal objectSelectionWidth) {
        this.setScalingUserX(scalingUserX);
        return this.scheduleLayoutData.scaleLengthDiagramSpaceToObjectSpaceX(diagramWidth).divide(objectSelectionWidth, ScheduleViewLayoutData.MATH_CONTEXT_DOUBLE_MAXIMUM_PRECISION);
    }

    public void mousePressedPrimary(int x) {
        if (this.scheduleLayoutData.getScalingUserX() < 10) {
            this.diagramMouseDownX = x;
        }
    }

    public void mouseReleasedPrimary() {
        if (this.diagramMouseDownX < 0 || this.scheduleLayoutData.getScalingUserX() == 10) {
            return;
        }
        int diagramEffectiveSelectionLeftX = Math.max(this.scheduleLayoutData.getDiagramLeftX(), this.diagramMouseDownX < this.diagramMouseX ? this.diagramMouseDownX : this.diagramMouseX);
        int diagramEffectiveSelectionRightX = Math.min(this.scheduleLayoutData.getDiagramRightX(), this.diagramMouseDownX < this.diagramMouseX ? this.diagramMouseX : this.diagramMouseDownX);
        int diagramSelectionWidth = diagramEffectiveSelectionRightX - diagramEffectiveSelectionLeftX;
        if (diagramSelectionWidth == 0) {
            this.setScalingUserX(this.scheduleLayoutData.getScalingUserX() + 1);
            this.composite.setScale(this.scheduleLayoutData.getScalingUserX());
        } else {
            BigDecimal ratioLargerScalingFactor;
            BigDecimal objectSelectionLeftX = this.scheduleLayoutData.diagramSpaceToObjectSpaceX(diagramEffectiveSelectionLeftX);
            int diagramWidth = this.scheduleLayoutData.getDiagramRightX() - this.scheduleLayoutData.getDiagramLeftX();
            BigDecimal objectSelectionWidth = this.scheduleLayoutData.scaleLengthDiagramSpaceToObjectSpaceX(diagramSelectionWidth);
            while ((ratioLargerScalingFactor = this.setScalingUserX(this.scheduleLayoutData.getScalingUserX() + 1, diagramWidth, objectSelectionWidth)).compareTo(BigDecimal.ONE) == -1 && this.scheduleLayoutData.getScalingUserX() < 10) {
            }
            BigDecimal ratioSmallerScalingFactor = this.setScalingUserX(this.scheduleLayoutData.getScalingUserX() - 1, diagramWidth, objectSelectionWidth);
            if (ratioLargerScalingFactor.subtract(BigDecimal.ONE).abs().compareTo(ratioSmallerScalingFactor.subtract(BigDecimal.ONE).abs()) == -1) {
                this.setScalingUserX(this.scheduleLayoutData.getScalingUserX() + 1, diagramWidth, objectSelectionWidth);
            }
            this.composite.setScale(this.scheduleLayoutData.getScalingUserX());
            this.setHorizontalBarSelection(objectSelectionLeftX);
        }
        this.diagramMouseDownX = -1;
        this.repaint();
    }

    public void mousePressedMiddle(int x, int y) {
        SubSchedule subSchedule;
        EObject object;
        BigDecimal yDiagram;
        BigDecimal xDiagram = this.scheduleLayoutData.diagramSpaceToObjectSpaceX(x);
        ScheduleModelElementToDrawFX findObjectAt = this.scheduleGraphModel.findObjectAt(xDiagram, yDiagram = this.scheduleLayoutData.diagramSpaceToObjectSpaceY(y));
        if (findObjectAt != null && (object = findObjectAt.getObject()) instanceof ResourceAllocation && (subSchedule = ((ResourceAllocation)object).getSubSchedule()) != null) {
            ScheduleUIUtils.showSubScheduleView(subSchedule);
        }
    }

    public void mousePressedSecondary() {
        if (this.scheduleLayoutData.getScalingUserX() > 1) {
            this.setScalingUserX(this.scheduleLayoutData.getScalingUserX() - 1);
            this.composite.setScale(this.scheduleLayoutData.getScalingUserX());
        }
    }

    public void updateHyperPeriods(int per) {
        this.getScheduleModel().setNumberOfHyperPeriods(per);
    }
}

